/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource.hbs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class ExtendIImportPlugin
extends BatchImportPlugin {
    private static final List<String> wrwlbNumbers = Arrays.asList("101", "102");
    private static final List<String> wrwpfljsffNumbers = Arrays.asList("201", "202", "203", "204");

    public String getDefaultKeyFields() {
        return "number";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String orgNumber;
            TaxResult result;
            ImportBillData bill = it.next();
            JSONObject data = bill.getData();
            if (data.getJSONObject("org") == null) {
                logger.log(Integer.valueOf(bill.getStartRowIndex()), ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ec4\u7ec7\u5b57\u6bb5", (String)"ExtendIImportPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                it.remove();
            }
            if (EmptyCheckUtils.isNotEmpty((Object)(result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(Collections.singletonList(orgNumber = data.getJSONObject("org").getString("number")))).getData())) {
                DynamicObject taxorg = (DynamicObject)((List)result.getData()).get(0);
                boolean notAuthorize = LicenseCheckServiceHelper.check((Object)taxorg.getLong("org.id"), null, (String)"tcret");
                if (notAuthorize) {
                    logger.log(Integer.valueOf(bill.getStartRowIndex()), String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u8bb8\u53ef\u3002", (String)"ExtendIImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), orgNumber));
                    it.remove();
                }
                if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg.getLong("org.id")).isSuccess()) {
                    logger.log(Integer.valueOf(bill.getStartRowIndex()), String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"ExtendIImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), orgNumber));
                    it.remove();
                }
            }
            JSONArray entryentity = data.getJSONArray("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                String wrwpfljsffNumber;
                JSONObject entry = entryentity.getJSONObject(i);
                String wrwlbNumber = entry.getJSONObject("wrwlb") != null ? entry.getJSONObject("wrwlb").getString("number") : "";
                String swrwzlNumber = entry.getJSONObject("swrwzl") != null ? entry.getJSONObject("swrwzl").getString("number") : "";
                String string = wrwpfljsffNumber = entry.getJSONObject("wrwpfljsff") != null ? entry.getJSONObject("wrwpfljsff").getString("number") : "";
                if (this.needInputBzndz(wrwlbNumber, swrwzlNumber, wrwpfljsffNumber)) continue;
                entry.put("bzndz", (Object)0);
            }
        }
    }

    private boolean needInputBzndz(String wrwlbNumber, String swrwzlNumber, String wrwpfljsffNumber) {
        return wrwlbNumbers.contains(wrwlbNumber) && EmptyCheckUtils.isNotEmpty((Object)swrwzlNumber) && !"303".equals(swrwzlNumber) && wrwpfljsffNumbers.contains(wrwpfljsffNumber);
    }
}

