/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource.hbs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class PollutionBaseDataUtils {
    private static final List<String> FIRST_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40201", "101212101", "101212102", "101212103", "101212104", "101212105", "101212106", "101212107", "101212108", "101212109", "101212110"});
    private static final List<String> SECOND_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40202"});
    private static final List<String> THREE_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40203", "101212301", "101212302", "101212303", "101212304"});
    private static final List<String> FOUR_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40204", "101212401", "101212402", "101212403", "101212404", "101212405", "101212406", "101212407", "101212408", "101212409"});
    private static final List<String> AIR_LIST = Lists.newArrayList((Object[])new String[]{"401"});
    private static final List<String> NOISE_LIST = Lists.newArrayList((Object[])new String[]{"403", "408", "40301", "40302", "40303", "40304", "40305", "40306"});
    private static final List<String> RUBBISH_LIST = Lists.newArrayList((Object[])new String[]{"404", "101213001", "101213002", "101213003", "101213004", "101213005", "101213006", "101213099"});

    public static List<String> getNumber(String wrwlbNumber, String swrwzlNumber) {
        if ("101".equals(wrwlbNumber) && "301".equals(swrwzlNumber)) {
            return FIRST_WATER_LIST;
        }
        if ("101".equals(wrwlbNumber) && "302".equals(swrwzlNumber)) {
            List<String> collect = IntStream.rangeClosed(1, 51).boxed().map(s -> "1012122" + String.format("%02d", s)).collect(Collectors.toList());
            collect.addAll(SECOND_WATER_LIST);
            return collect;
        }
        if ("101".equals(wrwlbNumber) && "303".equals(swrwzlNumber)) {
            return THREE_WATER_LIST;
        }
        if ("101".equals(wrwlbNumber) && "304".equals(swrwzlNumber)) {
            return FOUR_WATER_LIST;
        }
        if ("102".equals(wrwlbNumber)) {
            List<String> collect = IntStream.rangeClosed(1, 44).boxed().map(s -> "1012111" + String.format("%02d", s)).collect(Collectors.toList());
            collect.addAll(AIR_LIST);
            return collect;
        }
        if ("103".equals(wrwlbNumber)) {
            return NOISE_LIST;
        }
        if ("104".equals(wrwlbNumber)) {
            return RUBBISH_LIST;
        }
        return new ArrayList<String>();
    }

    public static DynamicObjectCollection getHbsEntryLists(String parentNumber, List<String> numbers) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)parentNumber), new QFilter("entry_detail.subnumber", "in", numbers)};
        return QueryServiceHelper.query((String)"tpo_hbs_bizdef", (String)"entry_detail.*", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getHbsEntity(Long orgid) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainHjbhsByOrgId(Collections.singletonList(orgid));
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("hjbhsentity");
        }
        return null;
    }

    public static Boolean validHbsEntityBaseData(Long orgId, Predicate<DynamicObject> predicate) {
        Boolean result = Boolean.FALSE;
        DynamicObjectCollection dynamicObjects = PollutionBaseDataUtils.getHbsEntity(orgId);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            result = dynamicObjects.stream().allMatch(s -> predicate.test((DynamicObject)s));
        }
        return result;
    }
}

