/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.zys.rule;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.common.enums.RuleTypeEnum;

public abstract class AbstractRuleCollectTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    protected static final String NEWRULE = "newrule";
    protected static final String COPY = "copy";
    protected static final String TCRET_ALL_RULE_CONFIG = "tcret_all_rule_config";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        Long parent = this.getParentTreeId();
        this.getTreeModel().getTreeFilter().add(new QFilter("parent", "=", (Object)parent));
        ((TreeListModel)this.getTreeModel()).getQueryParas().put("order", "createtime asc");
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractRuleCollectTreeListPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
        super.refreshNode(e);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("orgid")) {
            return;
        }
        List commonFilters = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            filterColumn.setDefaultValues(new Object[]{customParams.get("orgid")});
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().contains("org")) {
            OrgUtils.listFilterByIsTaxpayerAndEnableAndAudit((BeforeFilterF7SelectEvent)args);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
        if (root.getId().equals(currentNode.getId())) {
            Long parent = this.getParentTreeId();
            QFilter qFilter = new QFilter("group.parent", "=", (Object)parent);
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues;
        super.beforeDoOperation(args);
        String operationKey = ((FormOperate)args.getSource()).getOperateKey();
        if (NEWRULE.equals(operationKey)) {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
            if (root.getId().equals(currentNode.getId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (COPY.equals(operationKey) && (primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractRuleCollectTreeListPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        if (NEWRULE.equals(operationKey)) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            RuleTypeEnum nodeEnum = RuleTypeEnum.getStrategyByGroupId(currentNodeId);
            String formId = nodeEnum.getFormId();
            if (EmptyCheckUtils.isNotEmpty((Object)formId)) {
                baseShowParameter.setFormId(formId);
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
                Map customParams = baseShowParameter.getShowParameter().getCustomParams();
                customParams.put("ruletype", "private");
                customParams.put("orgid", String.valueOf(this.getCreateOrgId()));
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        } else if (COPY.equals(operationKey)) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            DynamicObject ruleObject = this.getSelectBill(Long.parseLong(primaryKeyValues[0].toString()));
            String formId = RuleTypeEnum.getStrategyByGroupId(ruleObject.getDynamicObject("group").getString("id")).getFormId();
            if (EmptyCheckUtils.isNotEmpty((Object)formId)) {
                String orgid = ruleObject.getDynamicObject("org").getString("id");
                if (((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgid)).getData()).booleanValue()) {
                    baseShowParameter.getShowParameter().getCustomParams().put("orgid", orgid);
                }
                baseShowParameter.setFormId(formId);
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
                baseShowParameter.getShowParameter().getCustomParams().put("iscopy", Boolean.TRUE);
                baseShowParameter.getShowParameter().getCustomParams().put("isCopyRelateEntity", Boolean.FALSE);
                baseShowParameter.getShowParameter().getCustomParams().put("CopyEmptyRow", Boolean.FALSE);
                baseShowParameter.setPkId(primaryKeyValues[0]);
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject ruleObject = this.getSelectBill(pkid);
        String groupId = ruleObject.getDynamicObject("group") != null ? ruleObject.getDynamicObject("group").getString("id") : "";
        String formId = RuleTypeEnum.getStrategyByGroupId(groupId).getFormId();
        if (EmptyCheckUtils.isNotEmpty((Object)formId)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId((Object)pkid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private DynamicObject getSelectBill(Long pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)TCRET_ALL_RULE_CONFIG);
    }

    public Long getCreateOrgId() {
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = selectedMainOrgIds.size() != 1 ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)selectedMainOrgIds.get(0);
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            if (orgId.compareTo(PermissionUtils.getDefaultOrgId()) == 0) {
                return 0L;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)PermissionUtils.getDefaultOrgId()).getData()).booleanValue()) {
                return 0L;
            }
            orgId = PermissionUtils.getDefaultOrgId();
        }
        return orgId;
    }

    protected abstract String sharePlanFormId();

    protected abstract Long getParentTreeId();
}

