/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.zys.rule;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class ZysRuleFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TAXSOURCE = "taxsource";
    private static final String TAXITEM = "taxitem";
    private static final String TAXSUBITEM = "taxsubitem";
    private static final String LEVY = "levy";
    private static final String SYSSYH = "syssyh";
    private static final String TAXDEDUCTION = "taxdeduction";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String ENTRYENTITY2 = "entryentity2";
    private static final String ENTRYENTITY3 = "entryentity3";
    private static final String ENTRYENTITY4 = "entryentity4";
    private static final String AMOUNTFIELD = "amountfield";
    private static final String AMOUNTFIELD1 = "amountfield1";
    private static final String AMOUNTFIELD2 = "amountfield2";
    private static final String AMOUNTFIELD3 = "amountfield3";
    private static final String AMOUNTFIELD4 = "amountfield4";
    private final List<String> CJJZ_ENTRYENTITY = Lists.newArrayList((Object[])new String[]{"entryentity", "entryentity1", "entryentity2", "entryentity4"});
    private final List<String> CLJZ_ENTRYENTITY = Lists.newArrayList((Object[])new String[]{"entryentity", "entryentity3"});

    public void registerListener(EventObject e) {
        BasedataEdit taxsource = (BasedataEdit)this.getControl(TAXSOURCE);
        taxsource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxitem = (BasedataEdit)this.getControl(TAXITEM);
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxdeduction = (BasedataEdit)this.getControl(TAXDEDUCTION);
        taxdeduction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield = (BasedataEdit)this.getControl(AMOUNTFIELD);
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield1 = (BasedataEdit)this.getControl(AMOUNTFIELD1);
        amountfield1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield2 = (BasedataEdit)this.getControl(AMOUNTFIELD2);
        amountfield2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield3 = (BasedataEdit)this.getControl(AMOUNTFIELD3);
        amountfield3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield4 = (BasedataEdit)this.getControl(AMOUNTFIELD4);
        amountfield4.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object createorg;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        }
        if (null != (createorg = customParams.get("orgid"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("orgid");
        }
    }

    public void afterBindData(EventObject e) {
        this.setAdvconap();
    }

    private void setAdvconap() {
        String levy = (String)this.getModel().getValue(LEVY);
        if ("cjjz".equals(levy)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap", "advconap1", "advconap2", "advconap4"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap3"});
        } else if ("cljz".equals(levy)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap", "advconap3"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1", "advconap2", "advconap4"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"ZysRuleFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (TAXSOURCE.equals(evt.getProperty().getName())) {
            long orgid = org.getLong("id");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("org", "=", (Object)orgid).and(new QFilter("enable", "=", (Object)"1"));
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        } else if (TAXITEM.equals(evt.getProperty().getName())) {
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue(TAXSOURCE);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (taxsource != null) {
                DynamicObjectCollection collection = taxsource.getDynamicObjectCollection(ENTRYENTITY);
                List taxitemIds = collection.stream().map(a -> a.getLong("taxitem.id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", taxitemIds);
                formShowParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                QFilter qFilter = new QFilter("id", "=", (Object)0L);
                formShowParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (TAXDEDUCTION.equals(evt.getProperty().getName())) {
            Date date = new Date();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter skssqqFilter = new QFilter("startdate", "<=", (Object)date);
            QFilter skssqzFilter = new QFilter("enddate", ">=", (Object)date).or(new QFilter("enddate", "=", null));
            formShowParameter.getListFilterParameter().setFilter(skssqqFilter.and(skssqzFilter));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            String levy = (String)this.getModel().getValue(LEVY);
            boolean isNull = false;
            if ("cjjz".equals(levy)) {
                isNull = this.entityIsNull(this.CJJZ_ENTRYENTITY);
            } else if ("cljz".equals(levy)) {
                isNull = this.entityIsNull(this.CLJZ_ENTRYENTITY);
            }
            if (isNull) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u53d6\u6570\u89c4\u5219\u3002", (String)"ZysRuleFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public boolean entityIsNull(List<String> list) {
        for (String field : list) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(field);
            if (!EmptyCheckUtils.isNotEmpty((Object)collection)) continue;
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        if (TAXSOURCE.equals(name)) {
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue(TAXSOURCE);
            this.getModel().setValue(TAXITEM, null);
            this.getModel().setValue(TAXSUBITEM, (Object)"");
            this.getModel().setValue(LEVY, (Object)"");
            this.doClearEntry();
        } else if (TAXITEM.equals(name)) {
            DynamicObject taxitem = (DynamicObject)this.getModel().getValue(TAXITEM);
            if (taxitem != null) {
                this.getModel().setValue(TAXSUBITEM, (Object)taxitem.getString(TAXSUBITEM));
                this.getModel().setValue(LEVY, (Object)taxitem.getString(LEVY));
            } else {
                this.getModel().setValue(TAXSUBITEM, (Object)"");
                this.getModel().setValue(LEVY, (Object)"");
            }
            this.doClearEntry();
        } else if (SYSSYH.equals(name)) {
            Boolean syssyh = (Boolean)this.getModel().getValue(SYSSYH);
            if (!syssyh.booleanValue()) {
                this.getModel().setValue(TAXDEDUCTION, null);
            }
        } else if (LEVY.equals(name)) {
            this.setAdvconap();
        }
    }

    private void doClearEntry() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().deleteEntryData(ENTRYENTITY1);
        this.getModel().deleteEntryData(ENTRYENTITY2);
        this.getModel().deleteEntryData(ENTRYENTITY3);
        this.getModel().deleteEntryData(ENTRYENTITY4);
    }
}

