/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.zys.taxsource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;
import kd.taxc.tcret.business.zys.ZysService;

public class ZysCollectImportPlugin
extends BatchImportPlugin {
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        DynamicObjectCollection zysRegister = ZysService.queryZysRegisterEnable();
        DynamicObjectCollection deductions = ZysService.queryTaxdeduction();
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData importBillData = it.next();
            this.validBillData(importBillData, message, zysRegister, deductions);
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), message.toString()).fail();
                it.remove();
            }
            JSONObject data = importBillData.getData();
            JSONArray entryentity = data.getJSONArray("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                JSONObject entry = entryentity.getJSONObject(i);
                entry.put("datasource", (Object)"import");
            }
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData importBillData, StringBuilder message, DynamicObjectCollection zysRegister, DynamicObjectCollection deductions) {
        int index = importBillData.getStartIndex();
        JSONObject data = importBillData.getData();
        JSONObject orgJsonObject = data.getJSONObject("org");
        JSONObject taxofficeJsonObject = data.getJSONObject("taxoffice");
        JSONObject taxsourceJsonObject = data.getJSONObject("taxsource");
        Date skssqq = data.getDate("skssqq");
        Date skssqz = data.getDate("skssqz");
        if (orgJsonObject == null || taxofficeJsonObject == null || taxsourceJsonObject == null || skssqq == null || skssqz == null) {
            return;
        }
        String orgNumber = orgJsonObject.getString("number") != null ? orgJsonObject.getString("number") : "";
        AbstractLicenseCheckBatchImportPlugin.checkOrg((String)orgNumber, (StringBuilder)message, (String)"tcret");
        String taxofficeNumber = taxofficeJsonObject.getString("number") != null ? taxofficeJsonObject.getString("number") : "";
        String taxsourceNumber = taxsourceJsonObject.getString("number") != null ? taxsourceJsonObject.getString("number") : "";
        Optional<DynamicObject> result = zysRegister.stream().filter(a -> orgNumber.equals(a.getString("org.number")) && taxofficeNumber.equals(a.getString("taxoffice.number")) && taxsourceNumber.equals(a.getString("number"))).findFirst();
        if (!result.isPresent()) {
            message.append(String.format(ResManager.loadKDString((String)"\u201c\u7a0e\u6e90\u7f16\u53f7\u201d\u548c\u201c\u7a0e\u6e90\u767b\u8bb0\u4fe1\u606f\u201d\u4e2d\u7684\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3001\u201c\u7a0e\u52a1\u673a\u5173\u201d\u4e2d\u4e0d\u5339\u914d\u3002", (String)"ZysCollectImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]));
        }
        JSONArray entryentity = data.getJSONArray("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            JSONObject entry = entryentity.getJSONObject(i);
            String levy = entry.getString("levy");
            BigDecimal gjsl = entry.getBigDecimal("gjsl");
            BigDecimal jmsxssl = entry.getBigDecimal("jmsxssl");
            BigDecimal xse = entry.getBigDecimal("xse");
            BigDecimal gjje = entry.getBigDecimal("gjje");
            BigDecimal yzf = entry.getBigDecimal("yzf");
            BigDecimal jmsxse = entry.getBigDecimal("jmsxse");
            JSONObject taxdeduction = entry.getJSONObject("taxdeduction");
            if ("cjjz".equals(levy) && (this.checkField(gjsl) || this.checkField(jmsxssl))) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u7a0e\u76ee\u7684\u8ba1\u5f81\u65b9\u5f0f\u4e3a\u201c\u4ece\u4ef7\u8ba1\u5f81\u201d\uff0c\u65e0\u9700\u586b\u5199\u201c\u51c6\u4e88\u6263\u51cf\u7684\u5916\u8d2d\u5e94\u7a0e\u4ea7\u54c1\u8d2d\u8fdb\u6570\u91cf\u201d\u3001\u201c\u51cf\u514d\u7a0e\u9500\u552e\u6570\u91cf\u201d\u3002", (String)"ZysCollectImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            } else if ("cljz".equals(levy) && (this.checkField(xse) || this.checkField(gjje) || this.checkField(yzf) || this.checkField(jmsxse))) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u7a0e\u76ee\u7684\u8ba1\u5f81\u65b9\u5f0f\u4e3a\u201c\u4ece\u91cf\u8ba1\u5f81\u201d\uff0c\u65e0\u9700\u586b\u5199\u201c\u9500\u552e\u989d\u201d\u3001\u201c\u51c6\u4e88\u6263\u51cf\u7684\u5916\u8d2d\u5e94\u7a0e\u4ea7\u54c1\u8d2d\u8fdb\u91d1\u989d\u201d\u3001\u201c\u51c6\u4e88\u6263\u9664\u7684\u8fd0\u6742\u8d39\u201d\u3001\u201c\u51cf\u514d\u7a0e\u9500\u552e\u989d\u201d\u3002", (String)"ZysCollectImportPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            }
            if (taxdeduction == null) {
                if (!this.checkField(jmsxse) && !this.checkField(jmsxssl)) continue;
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u201c\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201d\u4e3a\u7a7a\uff0c\u65e0\u9700\u586b\u5199\u201c\u51cf\u514d\u7a0e\u9500\u552e\u989d\u201d\u3001\u201c\u51cf\u514d\u7a0e\u9500\u552e\u6570\u91cf\u201d\u3002", (String)"ZysCollectImportPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
                continue;
            }
            String taxdeductionNumber = taxdeduction.getString("number");
            Optional<DynamicObject> deductionResult = deductions.stream().filter(a -> a.getString("number").equals(taxdeductionNumber) && ZysService.isEffectiveDate(skssqq, skssqz, a.getDate("startDate"), a.getDate("endDate"))).findFirst();
            if (!deductionResult.isPresent()) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u8be5\u201c\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201d\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ZysCollectImportPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            }
            if (jmsxse == null) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u201c\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201d\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u987b\u5199\u201c\u51cf\u514d\u7a0e\u9500\u552e\u989d\u201d\u7684\u503c\u3002", (String)"ZysCollectImportPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            }
            if (jmsxssl == null) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u201c\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201d\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u987b\u5199\u201c\u51cf\u514d\u7a0e\u9500\u552e\u6570\u91cf\u201d\u7684\u503c\u3002", (String)"ZysCollectImportPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            }
            if (!Lists.newArrayList((Object[])new String[]{"06049901", "06049902", "06049903"}).contains(taxdeductionNumber)) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c\u201c%d\u201d\u884c\uff0c\u8be5\u201c\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201d\u4e0d\u53ef\u9009\u62e9\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ZysCollectImportPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean checkField(BigDecimal field) {
        return field != null && !BigDecimal.ZERO.equals(field);
    }
}

