/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.zys.taxsource;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBasePlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.zys.ZysService;
import org.apache.commons.collections.CollectionUtils;

public class ZysRegisterFormPlugin
extends AbstractLicenseCheckBasePlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            long orgId = org.getLong("id");
            if (!this.checkOrg(orgId)) {
                return;
            }
            this.setTaxoffice(orgId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxitem = (BasedataEdit)this.getControl("taxitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("taxitem".equals(name)) {
            Date startdate = this.getModel().getDataEntity().getDate("startdate");
            Date enddate = this.getModel().getDataEntity().getDate("enddate");
            DynamicObject taxoffice = (DynamicObject)this.getModel().getValue("taxoffice");
            if (startdate == null || taxoffice == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u4fe1\u606f\u201d\u3002", (String)"ZysRegisterFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)0L));
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u76ee", (String)"ZysRegisterFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            List taxitemIds = entryentity.stream().filter(o -> o.getPkValue() != null && o.get("taxitem") != null).map(v -> v.getLong("taxitem.id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(taxitemIds)) {
                QFilter notInFilter = new QFilter("id", "not in", taxitemIds);
                beforeF7SelectEvent.getCustomQFilters().add(notInFilter);
            }
            List<Long> ids = ZysService.findFitTaxitemIds(startdate, enddate, taxoffice.getLong("taxorganaddress"));
            QFilter inFilter = new QFilter("id", "in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(inFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject org;
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        if ("org".equals(name) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            long orgId = org.getLong("id");
            if (!this.checkOrg(orgId)) {
                return;
            }
            this.setTaxoffice(orgId);
        }
        if ("taxoffice".equals(name) || "startdate".equals(name) || "enddate".equals(name)) {
            DynamicObjectCollection entryentity;
            Date startdate = this.getModel().getDataEntity().getDate("startdate");
            Date enddate = this.getModel().getDataEntity().getDate("enddate");
            if (startdate != null && enddate != null && enddate.before(startdate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u6709\u6548\u671f\u8d77\u5fc5\u987b\u5728\u7a0e\u6e90\u6709\u6548\u671f\u6b62\u4e4b\u524d\u3002", (String)"ZysRegisterFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getModel().setValue(name, null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(entryentity = this.getModel().getEntryEntity("entryentity"))) && this.getModel().getValue("taxitem", 0) != null && !"true".equals(this.getPageCache().get("cancelFlag"))) {
                Object oldvalue;
                if ("taxoffice".equals(name)) {
                    oldvalue = (DynamicObject)changeData[0].getOldValue();
                    this.getPageCache().put("taxofficevalue", oldvalue != null ? oldvalue.getString("id") : "");
                } else {
                    oldvalue = (Date)changeData[0].getOldValue();
                    this.getPageCache().put("datevalue", oldvalue != null ? DateUtils.format((Date)oldvalue) : "");
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(name, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"ZysRegisterFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ZysRegisterFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u7a0e\u52a1\u673a\u5173\u201d\u6216\u201c\u7a0e\u6e90\u6709\u6548\u671f\u8d77\u6b62\u201d\u5c06\u6e05\u7a7a\u201c\u5f81\u6536\u5b50\u76ee\u548c\u7a0e\u7387\u914d\u7f6e\u201d\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ZysRegisterFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            }
        }
    }

    private boolean checkOrg(Long orgId) {
        TaxResult taxResult = TaxcMainDataServiceHelper.isTaxcMainCategoryEnableByOrgIds(Collections.singletonList(orgId));
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            Map map = (Map)taxResult.getData();
            if (map.get(orgId) != null && ((Map)map.get(orgId)).containsKey("zys")) {
                boolean zysEnable = (Boolean)((Map)map.get(orgId)).get("zys");
                if (!zysEnable) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u8d44\u6e90\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u542f\u7528\u7a0e\u79cd\u5361\u7247\u3002", (String)"ZysRegisterFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getModel().setValue("org", null);
                    return false;
                }
                return true;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u8d44\u6e90\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u542f\u7528\u7a0e\u79cd\u5361\u7247\u3002", (String)"ZysRegisterFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
            this.getModel().setValue("org", null);
            return false;
        }
        return false;
    }

    private void setTaxoffice(Long orgId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (result.isSuccess() && result.getData() != null) {
            DynamicObject taxMain = (DynamicObject)result.getData();
            this.getModel().setValue("taxoffice", taxMain.get("taxoffice"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        if ("taxoffice".equals(key)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData("entryentity");
            } else {
                this.getPageCache().put("cancelFlag", "true");
                this.getModel().setValue(key, (Object)this.getPageCache().get("taxofficevalue"));
                this.getPageCache().put("cancelFlag", "false");
            }
        } else if ("startdate".equals(key) || "enddate".equals(key)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData("entryentity");
            } else {
                this.getPageCache().put("cancelFlag", "true");
                this.getModel().setValue(key, (Object)DateUtils.stringToDate2((String)this.getPageCache().get("datevalue")));
                this.getPageCache().put("cancelFlag", "false");
            }
        }
    }
}

