/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.opplugin.validator.SourceInfoDimensionSaveValidator;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.opplugin.PollutionBaseDataSaveValidator;

public class PollutionBaseDataSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new PollutionBaseDataSaveValidator());
        e.getValidators().add(new SourceInfoDimensionSaveValidator(BaseTaxCategory.HBS));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Long, DynamicObject> provisionPlanMap = this.getProvisionPlanMap(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong("org.id");
            DynamicObject provisionPlan = provisionPlanMap.get(orgId);
            if (provisionPlan != null) {
                boolean isdimprovision = provisionPlan.getBoolean("ruleentity.rule.isdimprovision");
                String provisiondimension = provisionPlan.getString("ruleentity.rule.provisiondimension");
                if (!isdimprovision || !provisiondimension.contains("accountorg")) {
                    dataEntity.set("accountorg", null);
                }
                if (isdimprovision && provisiondimension.contains("businessdimension")) continue;
                dataEntity.set("bizdimensiontype", null);
                dataEntity.set("bizdimensionname", null);
                dataEntity.set("bizdimensionid", null);
                continue;
            }
            dataEntity.set("accountorg", null);
            dataEntity.set("bizdimensiontype", null);
            dataEntity.set("bizdimensionname", null);
            dataEntity.set("bizdimensionid", null);
        }
    }

    private Map<Long, DynamicObject> getProvisionPlanMap(DynamicObject[] dataEntities) {
        List orgIds = Arrays.stream(dataEntities).map(d -> d.getLong("org.id")).collect(Collectors.toList());
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(orgIds, (Long)BaseTaxCategory.HBS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)new Date(), (Date)new Date());
        Map<Long, DynamicObject> provisionPlanMap = new HashMap<Long, DynamicObject>();
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            provisionPlanMap = ((DynamicObjectCollection)taxResult.getData()).stream().collect(Collectors.toMap(d -> d.getLong("orgentity.org"), d -> d, (k, v) -> k));
        }
        return provisionPlanMap;
    }
}

