/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class TdzzsYjRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    DynamicObject org = rule.getDynamicObject("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TdzzsYjRuleSaveOp_0", (String)"taxc-tcret", (Object[])new Object[0]));
                        return;
                    }
                    this.validate(dataEntity, rule);
                }
            }

            private void validate(ExtendedDataEntity dataEntity, DynamicObject rule) {
                List errorList = TdzzsYjRuleSaveOp.checkVatrate(rule);
                for (Map map : errorList) {
                    this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                }
            }
        });
    }

    private static List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject a1 = (DynamicObject)entryentity.get(i);
            String dataType = a1.getString("datatype");
            if (!"jsflqs".equals(dataType) && !"yjjsflqs".equals(dataType) || BigDecimal.ZERO.compareTo(a1.getBigDecimal("vatrate")) != 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "error");
            map.put("rule", (String)rule);
            map.put("msg", String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002", (String)"TdzzsYjRuleSaveOp_1", (String)"taxc-tcret", (Object[])new Object[0]), i + 1));
            msgList.add(map);
        }
        return msgList;
    }
}

