/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class ZysRuleSaveOp
extends AbstractOperationServicePlugIn {
    private Map<String, String> entryMap = new HashMap<String, String>(){
        {
            this.put("entryentity", ResManager.loadKDString((String)"\u9500\u552e\u6570\u91cf\u53d6\u6570\u914d\u7f6e", (String)"ZysRuleSaveOp_0", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put("entryentity1", ResManager.loadKDString((String)"\u9500\u552e\u989d\u53d6\u6570\u914d\u7f6e", (String)"ZysRuleSaveOp_1", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put("entryentity2", ResManager.loadKDString((String)"\u51c6\u4e88\u6263\u9664\u7684\u8fd0\u6742\u8d39\u53d6\u6570\u914d\u7f6e", (String)"ZysRuleSaveOp_2", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put("entryentity3", ResManager.loadKDString((String)"\u51c6\u4e88\u6263\u51cf\u7684\u5916\u8d2d\u5e94\u7a0e\u4ea7\u54c1\u8d2d\u8fdb\u6570\u91cf\u53d6\u6570\u914d\u7f6e", (String)"ZysRuleSaveOp_3", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put("entryentity4", ResManager.loadKDString((String)"\u51c6\u4e88\u6263\u51cf\u7684\u5916\u8d2d\u5e94\u7a0e\u4ea7\u54c1\u8d2d\u8fdb\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"ZysRuleSaveOp_4", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    };

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    DynamicObject org = rule.getDynamicObject("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ZysRuleSaveOp_6", (String)"taxc-tcret", (Object[])new Object[0]));
                        return;
                    }
                    this.validate(dataEntity, rule);
                }
            }

            private void validate(ExtendedDataEntity dataEntity, DynamicObject rule) {
                List errorList = ZysRuleSaveOp.this.checkVatrate(rule);
                for (Map map : errorList) {
                    this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                }
            }
        });
    }

    private List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        String entitySuffix = "";
        for (Map.Entry<String, String> entry : this.entryMap.entrySet()) {
            String entryName = entry.getKey();
            entitySuffix = entryName.replace("entryentity", "");
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection(entryName);
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject a1 = (DynamicObject)entryentity.get(i);
                String dataType = a1.getString("datatype" + entitySuffix);
                if (!"jsflqs".equals(dataType) && !"cysldsqs".equals(dataType) || BigDecimal.ZERO.compareTo(a1.getBigDecimal("vatrate" + entitySuffix)) < 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", "error");
                map.put("rule", entry.getValue());
                map.put("msg", String.format(ResManager.loadKDString((String)"%s\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002", (String)"ZysRuleSaveOp_5", (String)"taxc-tcret", (Object[])new Object[0]), entry.getValue(), i + 1));
                msgList.add(map);
            }
        }
        return msgList;
    }
}

