/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.common.enums.CompareListEnum;
import kd.taxc.tcret.opplugin.compare.validate.CreateProvisionValidator;

public class CompareCreateProvisionOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("drafttype", "generatebusinessdoc", "billstatus", "totalbtse", "org", "taxsystem", "taxtype", "taxareagroup", "accountsettype", "skssqq", "skssqz", "entryentity.taxitem", "entryentity.btse", "entryentity.accountorg", "entryentity.bizdimensiontype", "entryentity.bizdimensionname", "entryentity.bizdimensionid"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new CreateProvisionValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            arrayList.addAll(this.createParams(dataEntity));
            dataEntity.set("generatebusinessdoc", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(arrayList)});
    }

    private List<Map<String, Object>> createParams(DynamicObject dynamicObject) {
        DynamicObject org = dynamicObject.getDynamicObject("org");
        DynamicObject dimensionResult = this.getDimensionData(org.getLong("id"), dynamicObject.getLong("taxtype.id"), dynamicObject.getDate("skssqq"), dynamicObject.getDate("skssqz"));
        DynamicObjectCollection entryentity1 = dynamicObject.getDynamicObjectCollection("entryentity");
        Map<Long, List<DynamicObject>> accountOrgEntryentityMap = entryentity1.stream().collect(Collectors.groupingBy(d -> d.getLong("accountorg.id")));
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(accountOrgEntryentityMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : accountOrgEntryentityMap.entrySet()) {
            boolean isDimension;
            Long accountOrg = entry.getKey();
            List<DynamicObject> dynamicObjects = entry.getValue();
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String drafttype = dynamicObject.getString("drafttype");
            map.put("total", BigDecimalUtil.sumDynamicObjectAmount(dynamicObjects, (String)"btse"));
            String billno = (String)dynamicObject.get("billno");
            String userId = RequestContext.get().getUserId();
            map.put("taxtype", dynamicObject.getLong("taxtype.id"));
            map.put("taxsystem", dynamicObject.getLong("taxsystem.id"));
            map.put("taxarea", dynamicObject.getLong("taxareagroup.id"));
            map.put("coins", 1);
            map.put("provistonitem", CompareListEnum.getProvistonItemByDraftType(drafttype));
            map.put("taxorg", org.getLong("id"));
            map.put("accountorg", accountOrg);
            map.put("startdate", dynamicObject.get("skssqq"));
            map.put("enddate", dynamicObject.get("skssqz"));
            map.put("entitytype", CompareListEnum.getEntityNameByDraftType(drafttype));
            map.put("entitynumber", billno);
            map.put("creator", userId);
            map.put("modifier", userId);
            Date entrydate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)dynamicObject.getDate("skssqz"), (int)1));
            map.put("entrydate", entrydate);
            boolean bl = isDimension = dimensionResult != null && dimensionResult.getBoolean("ruleentity.rule.isdimprovision");
            if (isDimension) {
                ArrayList<HashMap<String, Object>> details = new ArrayList<HashMap<String, Object>>(dynamicObjects.size());
                for (DynamicObject object1 : dynamicObjects) {
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("taxitem", object1.get("taxitem"));
                    this.addDimensionData(detail, dimensionResult, object1);
                    detail.put("sjjt", object1.getBigDecimal("btse"));
                    details.add(detail);
                }
                map.put("details", details);
            }
            params.add(map);
        }
        return params;
    }

    private DynamicObject getDimensionData(Long orgid, Long taxtypeId, Date skssqq, Date skssqz) {
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgid), (Long)taxtypeId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
        }
        return null;
    }

    private void addDimensionData(Map<String, Object> detail, DynamicObject dimensionResult, DynamicObject entry) {
        boolean isdimprovision = dimensionResult.getBoolean("ruleentity.rule.isdimprovision");
        String provisiondimension = dimensionResult.getString("ruleentity.rule.provisiondimension");
        detail.put("accountorg", entry.getLong("accountorg.id"));
        if (isdimprovision && provisiondimension.contains("businessdimension")) {
            detail.put("bizdimensiontype", entry.getString("bizdimensiontype.id"));
            detail.put("bizdimensionname", entry.getString("bizdimensionname"));
            detail.put("bizdimensionid", entry.get("bizdimensionid"));
        }
    }
}

