/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.declarelist;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class DeclareListPayOp
extends AbstractOperationServicePlugIn {
    private static final String TCRET_QUERY_REPORT = "tcret_query_report";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("pay".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)TCRET_QUERY_REPORT, (String)MetadataUtil.getAllFieldToQuery((String)TCRET_QUERY_REPORT), (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    String payStatus = declare.getString("paystatus");
                    String billno = declare.getString("billno");
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListPayOp_0", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    if (!"declared".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListPayOp_1", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    if ("payfailed".equals(payStatus) || "unpaid".equals(payStatus) || StringUtils.isBlank((CharSequence)declare.getString("paystatus"))) continue;
                    message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u3001\u7f34\u6b3e\u5931\u8d25\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListPayOp_2", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                } else {
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }
}

