/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.declarelist;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcret.business.draft.DraftWriteBackService;
import kd.taxc.tcret.common.utils.TaxSourceUtils;

public class DeclareListSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String TCRET_QUERY_REPORT = "tcret_query_report";

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operateKey = args.getOperationKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List<Object> keyList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (dataEntities.length == 0) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u8bb0\u5f55", (String)"DeclareListSubmitOp_0", (String)"taxc-tcret", (Object[])new Object[0]);
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Warning);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                return;
            }
            ValidDataResultVo submit = DeclareUtils.submit(keyList, (String)operateKey, (String)"tcvat_nsrxx", (boolean)true);
            if (submit.getSuccess()) {
                if (TaxSourceUtils.WRITE_BACK_KEYS.contains(operateKey)) {
                    DynamicObject[] tcretDeclareMains;
                    DynamicObjectCollection queryReports = QueryServiceHelper.query((String)TCRET_QUERY_REPORT, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", keyList)});
                    Map<Long, String> collect = queryReports.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("billstatus"), (m, n) -> n));
                    for (DynamicObject tcretDeclareMain : tcretDeclareMains = BusinessDataServiceHelper.load((String)"tcret_declare_main", (String)"billstatus,sbbid,entryentity.id,entryentity.taxstatus", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", keyList)})) {
                        String newBillstatus = collect.get(tcretDeclareMain.getLong("sbbid"));
                        if (!StringUtils.isNotEmpty((CharSequence)newBillstatus)) continue;
                        tcretDeclareMain.set("billstatus", (Object)newBillstatus);
                        tcretDeclareMain.getDynamicObjectCollection("entryentity").forEach(s -> s.set("taxstatus", (Object)newBillstatus));
                    }
                    if (tcretDeclareMains.length > 0) {
                        SaveServiceHelper.update((DynamicObject[])tcretDeclareMains);
                    }
                    this.writeBack(keyList, TaxSourceUtils.KEY_BILLSTATUS_MAP.get(operateKey));
                }
                this.operationResult.setSuccess(true);
            } else if (submit.getData() == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(submit.getMessage());
                this.operationResult.setShowMessage(false);
            } else {
                OperationResult result = (OperationResult)submit.getData();
                List errorInfo = result.getAllErrorOrValidateInfo();
                if (errorInfo.size() > 1) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(1)).getMessage());
                } else if (errorInfo.size() > 0) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(0)).getMessage());
                } else {
                    this.operationResult.setMessage(result.getMessage());
                }
                this.operationResult.setShowMessage(false);
                this.operationResult.setSuccess(false);
            }
        }
    }

    private void writeBack(List<Object> pklist, String value) {
        DraftWriteBackService.writeBackDeclareReportByField(pklist, "declarebillstatus", value);
    }
}

