/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.taxsource.yhs.validate;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.utils.DateCheckUtils;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxAccountSaveValidator
extends AbstractValidator {
    private static final String ORG = "org";
    private static final String TAXITEM = "taxitem";
    private static final String SUBTAXITEM = "subtaxitem";
    private static final String QLXK = "014";
    private static final String QTZP = "013";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject org = dynamicObject.getDynamicObject(ORG);
            if (org == null) {
                return;
            }
            String declaretype = dynamicObject.getString("declaretype");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"YhsTaxAccountSaveValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            if (dynamicObject.containsProperty("entryentity")) {
                DynamicObjectCollection entryentityList = dynamicObject.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryentityList)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53f0\u8d26\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u53f0\u8d26\u4fe1\u606f", (String)"YhsTaxAccountSaveValidator_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject object : entryentityList) {
                    this.check(dataEntity, object, org, declaretype, skssqq, skssqz);
                }
                continue;
            }
            this.check(dataEntity, dynamicObject, org, declaretype, skssqq, skssqz);
        }
    }

    private void check(ExtendedDataEntity dataEntity, DynamicObject dynamicObject, DynamicObject org, String declaretype, Date skssqq, Date skssqz) {
        String number;
        BigDecimal calctaxamount = dynamicObject.getBigDecimal("calctaxamount");
        DynamicObject taxitem = dynamicObject.getDynamicObject(TAXITEM);
        DynamicObject subtaxitem = dynamicObject.getDynamicObject(SUBTAXITEM);
        if (taxitem != null && (StringUtil.equals((CharSequence)QTZP, (CharSequence)(number = taxitem.getString("number"))) || StringUtil.equals((CharSequence)QLXK, (CharSequence)number)) && new BigDecimal(calctaxamount.intValue()).compareTo(calctaxamount) != 0) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u7684\u8ba1\u7a0e\u91d1\u989d\u7684\u503c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxAccountSaveValidator_2", (String)"taxc-tcret", (Object[])new Object[0]), taxitem.getLocaleString("name").getLocaleValue());
            this.addFatalErrorMessage(dataEntity, msg);
            return;
        }
        String taxation = dynamicObject.getString("taxation");
        BigDecimal verifyrate = dynamicObject.getBigDecimal("verifyrate");
        if (StringUtil.equals((CharSequence)"hdzs", (CharSequence)taxation) && (verifyrate.compareTo(BigDecimal.ZERO) < 0 || verifyrate.compareTo(new BigDecimal(2)) > 0)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u65f6\uff0c\u6838\u5b9a\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e2\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxAccountSaveValidator_3", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.equals((CharSequence)"aqsb", (CharSequence)declaretype)) {
            if (calctaxamount.compareTo(BigDecimal.ZERO) < 0) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxAccountSaveValidator_4", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            if (skssqq != null && skssqz != null) {
                boolean existTaxitem;
                try {
                    DateCheckUtils.checkDateThrowException(true, skssqq, skssqz);
                }
                catch (KDBizException e) {
                    this.addFatalErrorMessage(dataEntity, e.getMessage());
                    return;
                }
                if (taxitem != null && !(existTaxitem = this.isExistTaxitem(taxitem, taxation, verifyrate, org, skssqq, skssqz))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u671f\u5370\u82b1\u7a0e\u7a0e\u76ee\u4fe1\u606f%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u7ef4\u62a4\u7a0e\u79cd\u4fe1\u606f\u3002", (String)"YhsTaxAccountSaveValidator_8", (String)"taxc-tcret", (Object[])new Object[0]), taxitem.getLocaleString("name").getLocaleValue());
                    this.addFatalErrorMessage(dataEntity, msg);
                    return;
                }
            }
        } else if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype) && BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal("calctaxamount")) >= 0) {
            String msg = ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u65f6\uff0c\u8ba1\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxAccountSaveValidator_9", (String)"taxc-tcret", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, msg);
            return;
        }
        if (taxitem != null && taxitem.getString("number").equals("02001") && skssqq != null && skssqq.compareTo(YhsUtils.YHS_NEW_VERSION_DATE) >= 0 && subtaxitem == null) {
            String msg = ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e\u7684\u5b50\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b50\u76ee\u201d\u3002", (String)"YhsTaxAccountSaveValidator_10", (String)"taxc-tcret", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, msg);
            return;
        }
    }

    private boolean isExistTaxitem(DynamicObject taxitem, String taxation, BigDecimal verifyrate, DynamicObject org, Date skssqq, Date skssqz) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(org.getLong("id")));
        if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData())) {
            return false;
        }
        DynamicObjectCollection yhsentity = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        Optional<DynamicObject> first = yhsentity.stream().filter(d -> d.get("isverify").equals(StringUtil.equals((CharSequence)"hdzs", (CharSequence)taxation)) && d.getLong("taxrate.id") == taxitem.getLong("id") && YhsUtils.isValidate(d, skssqq, skssqz, null, taxLimit) && this.hdrateEquals(taxation, verifyrate, (DynamicObject)d)).findFirst();
        return first.isPresent();
    }

    private boolean hdrateEquals(String taxation, BigDecimal verifyrate, DynamicObject d) {
        boolean hdzs = StringUtil.equals((CharSequence)"hdzs", (CharSequence)taxation);
        if (hdzs) {
            return d.getBigDecimal("hdrate").compareTo(verifyrate) == 0;
        }
        return true;
    }
}

