/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcwat.formplugin.declare;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class TcwatDeclareQueryListOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("delete".equals(operateKey)) {
                    Arrays.stream(this.dataEntities).forEach(dataEntity -> {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tcwat_declare_query", (String)MetadataUtil.getAllFieldToQuery((String)"tcwat_declare_query"), (QFilter[])new QFilter[]{new QFilter("id", "=", dataEntity.getBillPkId())});
                        if (dynamicObject != null) {
                            String billstatus = dynamicObject.getString("billstatus");
                            if ("B".equals(billstatus) || "C".equals(billstatus)) {
                                this.addErrorMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u6570\u636e", (String)"TcwatDeclareQueryListOp_0", (String)"taxc-tcret", (Object[])new Object[0]), dynamicObject.getString("billno")));
                            } else {
                                try (TXHandle h = TX.requiresNew();){
                                    try {
                                        DeclareServiceHelper.deleteBySbbId((Long)dynamicObject.getLong("id"));
                                    }
                                    catch (Exception e) {
                                        h.markRollback();
                                        throw new RuntimeException(e);
                                    }
                                }
                                DeclareMQSender.sendMQ((DynamicObject)dynamicObject, null, (String)DeclareMQType.DECLARE.name(), (String)operateKey);
                            }
                        }
                    });
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] waterResources;
            DynamicObject[] dataEntities = e.getDataEntities();
            List sbbids = Arrays.stream(dataEntities).map(a -> a.getLong("id")).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("sbbid", "in", sbbids)};
            for (DynamicObject waterResource : waterResources = BusinessDataServiceHelper.load((String)"tdm_water_resource", (String)"sbbid,declarestatus,sbbbillstatus,sbbbillno", (QFilter[])filters)) {
                waterResource.set("sbbid", (Object)Long.parseLong("0"));
                waterResource.set("declarestatus", (Object)" ");
                waterResource.set("sbbbillstatus", (Object)" ");
                waterResource.set("sbbbillno", (Object)this.initSbbStatus());
            }
            SaveServiceHelper.save((DynamicObject[])waterResources);
            DeleteServiceHelper.delete((String)"tcwat_source_detail", (QFilter[])filters);
        }
    }

    private String initSbbStatus() {
        return ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"TcwatDeclareQueryListOp_1", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

