/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcwat.formplugin.declare;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.querylist.TaxDeclareQueryListPlugin;
import kd.taxc.tcret.common.utils.TaxSourceUtils;

public class TcwatDeclareQueryListPlugin
extends TaxDeclareQueryListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (args.getSource() instanceof Donothing && opResult != null && opResult.isSuccess()) {
            String operationKey = ((Donothing)args.getSource()).getOperateKey();
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TcretAccrualDraftListPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("sbbid", "in", collect);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"tdm_water_resource", (String)"id,sbbbillstatus", (QFilter[])new QFilter[]{qFilter});
            String billStatus = TaxSourceUtils.KEY_BILLSTATUS_MAP.get(operationKey);
            if (object != null && StringUtil.isNotBlank((CharSequence)billStatus)) {
                object.set("sbbbillstatus", (Object)billStatus);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }
}

