/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcwat.formplugin.declare;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class TcwatSelectSourcePlugin
extends AbstractFormPlugin {
    public void initialize() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        final Map params = this.getView().getFormShowParameter().getCustomParams();
        billlistap.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
                args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int start, int limit) {
                        super.addQFilters(new QFilter("org", "=", (Object)Long.parseLong((String)params.get("orgid"))));
                        super.addQFilters(new QFilter("taxsource.taxauthority", "=", (Object)Long.parseLong((String)params.get("taxauthority"))));
                        Date declaremonth = DateUtils.stringToDate((String)((String)params.get("declaremonth")));
                        int month = DateUtils.getMonthOfDate((Date)declaremonth);
                        Date lastMonth = DateUtils.addMonth((Date)declaremonth, (int)-1);
                        if (month % 3 == 1) {
                            QFilter q1 = new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonth));
                            QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfSeason((Date)lastMonth));
                            QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth1((Date)lastMonth));
                            super.addQFilters(q3.and(q1.or(q2)));
                        } else {
                            super.addQFilters(new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonth)));
                            super.addQFilters(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth1((Date)lastMonth)));
                        }
                        super.addQFilters(new QFilter("enable", "=", (Object)"1"));
                        DynamicObjectCollection data = super.getData(start, limit);
                        if (CollectionUtils.isNotEmpty((Collection)data) && ((DynamicObject)data.get(0)).containsProperty("taxsource") && ((DynamicObject)data.get(0)).containsProperty("entryentity")) {
                            for (DynamicObject object : data) {
                                String sysbb = object.getString("taxsource.sysbb");
                                if (!sysbb.equals("A")) continue;
                                object.set("entryentity.bqqslb", object.get("bqqsl"));
                            }
                        }
                        return data;
                    }
                });
            }
        });
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"newsource", "btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        HashMap<String, String> returnData = new HashMap<String, String>();
        if ("newsource".equals(key)) {
            HashMap customParams = new HashMap();
            Map params = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("orgid", params.get("orgid"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tdm_water_resource", (IFormView)this.getView(), (Map)params, (IFormPlugin)this);
        } else if ("btnok".equals(key)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7a0e\u6e90\u3002", (String)"TcwatSelectSourcePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            returnData.put("key", "btnok");
            returnData.put("data", (String)selectedRows.get(0));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        FormView source = (FormView)e.getSource();
        Field field = ReflectionUtils.findField(source.getClass(), (String)"returnToParentData");
        AccessibleObject.setAccessible(new AccessibleObject[]{field}, Boolean.TRUE);
        HashMap<String, Object> returnData = (HashMap<String, Object>)ReflectionUtils.getField((Field)field, (Object)source);
        if (returnData == null) {
            returnData = new HashMap<String, Object>();
        }
        returnData.put("changetype", this.getView().getFormShowParameter().getCustomParam("changetype"));
        this.getView().returnDataToParent(returnData);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }
}

