/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcret.mservice.upgrade.InvoiceNameUpgradeService;

public class AccrualProjectNameUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceNameUpgradeService.class);
    private static final String SQL_SELECT1 = "select fentryid from t_tcret_accrual_entry where fitemno in (select fnumber from t_tdm_tds_basic_info where fid in (select fid from t_tdm_tds_basic_info_l)) and fentryid not in (select fentryid from t_tcret_accrual_entry_l)";
    private static final String SQL_SELECT2 = "select fentryid from t_tcret_accrual_entry where fitemno in (select fleasecontractno from t_tdm_house_rental_info where fid in (select fid from t_tdm_house_rental_info_l)) and ftaxitem = '%s' and fentryid not in (select fentryid from t_tcret_accrual_entry_l)";
    private static final String SQL_SELECT3 = "select fentryid from t_tcret_accrual_entry where fitemno in (select fnumber from t_tdm_fcs_basic_info where fid in (select fid from t_tdm_fcs_basic_info_l)) and ftaxitem = '%s' and fentryid not in (select fentryid from t_tcret_accrual_entry_l)";
    private static final String SQL_SELECTSQL1 = "select fentryid,fname from t_tcret_accrual_entry f inner join t_tdm_tds_basic_info m on m.fnumber = f.fitemno inner join t_tdm_tds_basic_info_l n on m.fid = n.fid where n.flocaleid = 'zh_CN' and fentryid in (%s)";
    private static final String SQL_SELECTSQL2 = "select fentryid,fbuildingname from t_tcret_accrual_entry f inner join t_tdm_house_rental_info m on m.fleasecontractno = f.fitemno inner join t_tdm_house_rental_info_l n on m.fid = n.fid where n.flocaleid = 'zh_CN' and fentryid in (%s)";
    private static final String SQL_SELECTSQL3 = "select fentryid,fname from t_tcret_accrual_entry f inner join t_tdm_fcs_basic_info m on m.fnumber = f.fitemno inner join t_tdm_fcs_basic_info_l n on m.fid = n.fid where n.flocaleid = 'zh_CN' and fentryid in (%s)";
    private static final String SQL_INSERT1 = "insert into t_tcret_accrual_entry_l (fpkid,fentryid,flocaleid,fprojectname) values (?,?,?,?)";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String czjz = ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"AccrualProjectNameUpgradeService_2", (String)"taxc-tcret-mservice", (Object[])new Object[0]);
        String cjjz = ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"AccrualProjectNameUpgradeService_3", (String)"taxc-tcret-mservice", (Object[])new Object[0]);
        this.updateTable("t_tdm_tds_basic_info", SQL_SELECT1, "", SQL_SELECTSQL1, "FNAME");
        this.updateTable("t_tdm_house_rental_info", SQL_SELECT2, czjz, SQL_SELECTSQL2, "FBUILDINGNAME");
        this.updateTable("t_tdm_fcs_basic_info", SQL_SELECT3, cjjz, SQL_SELECTSQL3, "FNAME");
    }

    private void updateTable(String tableName, String sql1, String item, String sql2, String name) {
        List query1;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)tableName) && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)(tableName + "_l")) && EmptyCheckUtils.isNotEmpty((Object)(query1 = DBUtils.query((String)String.format(sql1, item))))) {
            List entrys = DBUtils.query((String)String.format(sql2, StringUtils.join((Object[])query1.stream().map(s -> s.get("FENTRYID")).toArray(), (String)",")));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            String[] ids = DB.genStringIds((String)"", (int)entrys.size());
            int i = 0;
            for (Map row : entrys) {
                String fpkid = ids[i];
                Object fentryid = row.get("FENTRYID");
                String flocaleid = "zh_CN";
                Object fprojectname = row.get(name);
                ++i;
                paramList.add(new Object[]{fpkid, fentryid, flocaleid, fprojectname});
            }
            if (EmptyCheckUtils.isNotEmpty(paramList)) {
                DBUtils.executeBatch((String)"taxc", (String)SQL_INSERT1, paramList);
            }
        }
    }
}

