/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class CcxwsZbHbUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CcxwsZbHbUpgradePlugin.class);
    private static final String TCRET_CCXWS_ZB_FCS_CJ = "tcret_ccxws_zb_fcs_cj";
    private static final String TCRET_CCXWS_ZB_FCS_CZ = "tcret_ccxws_zb_fcs_cz";
    private static final String TCRET_CCXWS_ZB_TDS = "tcret_ccxws_zb_tds";
    private static final String TCRET_CCXWS_ZB_YHS = "tcret_ccxws_zb_yhs";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String T_TCRET_CCXWS_ZB_HB = "t_tcret_ccxws_zb_hb";
    private static final String FIELDS = "id,sbbid,ewblxh,ewblname,seqno,taxtype,sm,sl,startdate,enddate,jsyj,ynse,jmse,yjse,ybse";
    private static final String ZLB_INSERT_STR = "insert into t_tcret_ccxws_zb_hb (FID,FEWBLXH,FEWBLNAME,FSBBID,FSEQNO,FTAXTYPE,FSM,FSL,FSTARTDATE,FENDDATE,FJSYJ,FYNSE,FJMSE,FYJSE,FYBSE) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List<String> entitys = Arrays.asList(TCRET_CCXWS_ZB_FCS_CJ, TCRET_CCXWS_ZB_FCS_CZ, TCRET_CCXWS_ZB_TDS, TCRET_CCXWS_ZB_YHS);
        ArrayList accounts = new ArrayList(256);
        for (String number : entitys) {
            Boolean isExist = this.metaIsExist(number);
            if (!isExist.booleanValue()) {
                this.addLog(ERROR, String.format("The %s is not exist!", number));
                return;
            }
            DynamicObjectCollection id = QueryServiceHelper.query((String)number, (String)FIELDS, (QFilter[])QFilter.isNotNull((String)"id").toArray());
            accounts.addAll(id);
        }
        this.addLog(INFO, "select * from t_tctb_declare_main where fnsrtype = 'ccxws'");
        QFilter and = new QFilter("type", "=", (Object)"ccxws");
        DynamicObject[] sbbList = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)"id,maindataid,declarestatus,billstatus,billno", (QFilter[])and.toArray());
        this.addLog(INFO, String.format("Update range size: %d", sbbList.length));
        if (EmptyCheckUtils.isNotEmpty((Object)sbbList)) {
            this.addLog(INFO, "select FID,FSBBID from t_tcret_ccxws_zb_hb");
            List zbhbList = DBUtils.query((String)"select FID,FSBBID from t_tcret_ccxws_zb_hb");
            Set zbhbIds = zbhbList.stream().map(a -> (String)a.get("FSBBID")).collect(Collectors.toSet());
            Map<String, List<DynamicObject>> sbbidGroup = accounts.stream().collect(Collectors.groupingBy(a -> a.getString("sbbid")));
            ArrayList valueList = new ArrayList(sbbList.length);
            for (DynamicObject sbbObject : sbbList) {
                List<DynamicObject> taxsourceList;
                String sbbid = sbbObject.getString("id");
                if (zbhbIds.contains(sbbid) || !EmptyCheckUtils.isNotEmpty(taxsourceList = sbbidGroup.get(sbbid))) continue;
                ArrayList<Object[]> itemList = new ArrayList<Object[]>(taxsourceList.size());
                taxsourceList.sort(Comparator.comparing(a -> Integer.valueOf(StringUtil.isNumeric((String)a.getString("seqno")) ? a.getString("seqno") : "0")));
                int i = 0;
                for (DynamicObject taxSource : taxsourceList) {
                    itemList.add(new Object[]{DBUtils.getLongId((String)T_TCRET_CCXWS_ZB_HB), String.valueOf(i + 1), taxSource.getString("ewblname"), taxSource.getString("sbbid"), taxSource.getString("seqno"), taxSource.getString("taxtype"), taxSource.getString("sm"), taxSource.getString("sl"), taxSource.getDate("startdate"), taxSource.getDate("enddate"), taxSource.getBigDecimal("jsyj"), taxSource.getBigDecimal("ynse"), taxSource.getBigDecimal("jmse"), taxSource.getBigDecimal("yjse"), taxSource.getBigDecimal("ybse")});
                    ++i;
                }
                if (itemList.size() <= 0) continue;
                valueList.add(itemList);
            }
            if (EmptyCheckUtils.isNotEmpty(valueList)) {
                this.addLog(INFO, String.format("insert into t_tcret_ccxws_zb_hb batch size is: %d", valueList.size()));
                for (List list : valueList) {
                    TXHandle h = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            DBUtils.executeBatch((String)ZLB_INSERT_STR, (List)list);
                        }
                        catch (Throwable t) {
                            h.markRollback();
                            LOGGER.error(ERROR_INFO, t);
                            this.addLog(ERROR, this.getStackTraceMessage(t));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
        }
    }
}

