/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class FcsTdsSourceDetailUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(FcsTdsSourceDetailUpgradeService.class);
    private static final String SQL_SELECT1 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_tds_sum where fisxgm = '1'";
    private static final String SQL_SELECT2 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_tds_sum where fisxgm = '0'";
    private static final String SQL_SELECT3 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_fcs_price_sum where fisxgm = '1'";
    private static final String SQL_SELECT4 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_fcs_price_sum where fisxgm = '0'";
    private static final String SQL_SELECT5 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_fcs_hire_sum where fisxgm = '1'";
    private static final String SQL_SELECT6 = "select fid,fsbbid,fnumber,fskssqq,fskssqz,fsourceid from t_tcret_pbt_fcs_hire_sum where fisxgm = '0'";
    private static final String SQL_UPDATE1 = "update t_tcret_pbt_tds_sum set fsourceid = ? where fid = ?";
    private static final String SQL_UPDATE2 = "update t_tcret_pbt_fcs_price_sum set fsourceid = ? where fid = ?";
    private static final String SQL_UPDATE3 = "update t_tcret_pbt_fcs_hire_sum set fsourceid = ? where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        this.updateTable("t_tcret_pbt_tds_sum", SQL_SELECT1, SQL_SELECT2, SQL_UPDATE1);
        this.updateTable("t_tcret_pbt_fcs_price_sum", SQL_SELECT3, SQL_SELECT4, SQL_UPDATE2);
        this.updateTable("t_tcret_pbt_fcs_hire_sum", SQL_SELECT5, SQL_SELECT6, SQL_UPDATE3);
    }

    private void updateTable(String tableName, String sql1, String sql2, String updatesql) {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)tableName)) {
            List query1 = DBUtils.query((String)sql1);
            List query2 = DBUtils.query((String)sql2);
            if (EmptyCheckUtils.isNotEmpty((Object)query1)) {
                Map<String, Object> sourceidMap = query2.stream().collect(Collectors.toMap(a -> a.get("FSBBID") + "" + a.get("FNUMBER") + "" + a.get("FSKSSQQ") + "" + a.get("FSKSSQZ") + "", b -> b.get("FSOURCEID"), (m, n) -> m));
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : query1) {
                    if (sourceidMap.get(row.get("FSBBID") + "" + row.get("FNUMBER") + "" + row.get("FSKSSQQ") + "" + row.get("FSKSSQZ") + "") == null) continue;
                    Object fid = row.get("FID");
                    Object fsourceid = sourceidMap.get(row.get("FSBBID") + "" + row.get("FNUMBER") + "" + row.get("FSKSSQQ") + "" + row.get("FSKSSQZ") + "");
                    paramList.add(new Object[]{fsourceid, fid});
                }
                try (TXHandle h = TX.required();){
                    try {
                        if (EmptyCheckUtils.isNotEmpty(paramList)) {
                            DBUtils.executeBatch((String)"taxc", (String)updatesql, paramList);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
        }
    }
}

