/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import org.apache.commons.collections.CollectionUtils;

public class PollutionBaseDataUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PollutionBaseDataUpgradePlugin.class);
    private static final Map<Object, Object> PH_WATER_MAP = new HashMap<Object, Object>();
    private static final String insertZsMainSql = "INSERT INTO t_tcret_pollution_basedat(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,forgid,fstartdate,fenddate,fpfknum,fpwxkznum,fscjyszx,fsthjzgbm,fpfksszgswjg,fjingdumiao,fweidumiao,fjingdu,fjingdufen,fweidu ,fweidufen) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String insertZsSonSql = "INSERT INTO t_tcret_pollution_wrwmc(fid,fentryid,fseq,fwrwlb,fswrwzl,fwrwmc,fzszm,fwrwpfljsff,fmark) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String updateZsSql = "update t_tdm_pollution_basedata set fstatus='A' where fid in (%s)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "POLLUTIONBASEDATA DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            boolean exitsSbbTable = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tdm_pollution_basedata");
            boolean exitsSbbEntryTable = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tdm_pollution_basedata_l");
            if (exitsSbbTable && exitsSbbEntryTable) {
                this.update();
            } else {
                info = log = "not exist t_tctb_declare_main and t_tctb_declare_entry";
            }
        }
        catch (Throwable t) {
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("POLLUTIONBASEDATA DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(true);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        this.updateLangTable();
        this.updateFzs();
        this.updateZsWrwlb();
    }

    private void updateFzs() {
        String queryFzsSql = "select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,forgid,fwrwname,fstartdate,fenddate,fwrwlb,fswrwzl,fwrwmc,fwrwpfljsff,fpfknum,fzszm,fpwxkznum,fscjyszx,fsthjzgbm,fmark,fpfksszgswjg,fjingdumiao,fweidumiao,fjingdu,fjingdufen,fweidu,fweidufen from t_tdm_pollution_basedata where fstatus=? and fwrwlb<>? ";
        List fzsQueryList = DBUtils.query((String)queryFzsSql, (Object[])new Object[]{"C", 1215008151309769730L});
        if (CollectionUtils.isNotEmpty((Collection)fzsQueryList)) {
            ArrayList<Object[]> paramMainList = new ArrayList<Object[]>(fzsQueryList.size());
            ArrayList<Object[]> paramSonList = new ArrayList<Object[]>(fzsQueryList.size());
            List updateMainIds = fzsQueryList.stream().map(s -> s.get("FID")).collect(Collectors.toList());
            Map<Object, List<Map>> numberGroupBy = fzsQueryList.stream().collect(Collectors.groupingBy(s -> s.get("FNUMBER")));
            for (Map.Entry<Object, List<Map>> numberListEntry : numberGroupBy.entrySet()) {
                List<Map> numberValue = numberListEntry.getValue();
                Map<Object, List<Map>> orgGroupBy = numberValue.stream().collect(Collectors.groupingBy(s -> s.get("FORGID")));
                int orgAddbianhao = 1;
                for (Map.Entry<Object, List<Map>> orgListEntry : orgGroupBy.entrySet()) {
                    List<Map> orgValue = orgListEntry.getValue();
                    for (Map orgSonValue : orgValue) {
                        orgSonValue.put("FNUMBER", orgSonValue.get("FNUMBER").toString() + "-" + orgAddbianhao);
                    }
                    ++orgAddbianhao;
                    Map<Object, List<Map>> swjgGroupBy = orgValue.stream().collect(Collectors.groupingBy(s -> s.get("FPFKSSZGSWJG")));
                    int swjgAddbianhao = 1;
                    for (Map.Entry<Object, List<Map>> swjgListEntry : swjgGroupBy.entrySet()) {
                        List<Map> swjgValue = swjgListEntry.getValue();
                        for (Map swjgSonValue : swjgValue) {
                            swjgSonValue.put("FNUMBER", swjgSonValue.get("FNUMBER").toString() + "-" + swjgAddbianhao);
                        }
                        ++swjgAddbianhao;
                        Map mainValue = swjgValue.get(0);
                        Object fid = mainValue.get("FID");
                        String fnumber = (String)mainValue.get("FNUMBER");
                        if (orgGroupBy.size() == 1 && swjgGroupBy.size() == 1) {
                            fnumber = fnumber.substring(0, fnumber.length() - 4);
                        }
                        Object fstatus = mainValue.get("FSTATUS");
                        Object fcreatorid = mainValue.get("FCREATORID");
                        Object fmodifierid = mainValue.get("FMODIFIERID");
                        Object fenable = mainValue.get("FENABLE");
                        Object fcreatetime = mainValue.get("FCREATETIME");
                        Object fmodifytime = mainValue.get("FMODIFYTIME");
                        Object fmasterid = mainValue.get("FMASTERID");
                        Object forgid = mainValue.get("FORGID");
                        Object fpfknum = mainValue.get("FPFKNUM");
                        Object fpwxkznum = mainValue.get("FPWXKZNUM");
                        Object fscjyszx = mainValue.get("FSCJYSZX");
                        Object fsthjzgbm = mainValue.get("FSTHJZGBM");
                        Object fpfksszgswjg = mainValue.get("FPFKSSZGSWJG");
                        Object fjingdumiao = mainValue.get("FJINGDUMIAO");
                        Object fweidumiao = mainValue.get("FWEIDUMIAO");
                        Object fjingdu = mainValue.get("FJINGDU");
                        Object fjingdufen = mainValue.get("FJINGDUFEN");
                        Object fweidu = mainValue.get("FWEIDU");
                        Object fweidufen = mainValue.get("FWEIDUFEN");
                        Date fstartdate = (Date)mainValue.get("FSTARTDATE");
                        Date fenddate = (Date)mainValue.get("FENDDATE");
                        for (Map limitDate : swjgValue) {
                            Date limitStartDate = (Date)limitDate.get("FSTARTDATE");
                            if (limitStartDate != null && limitStartDate.compareTo(fstartdate) < 0) {
                                fstartdate = limitStartDate;
                            }
                            Date limitEndDate = (Date)limitDate.get("FENDDATE");
                            if (fenddate == null || limitEndDate == null) {
                                fenddate = null;
                                continue;
                            }
                            fenddate = fenddate.compareTo(limitEndDate) > 0 ? fenddate : limitEndDate;
                        }
                        paramMainList.add(new Object[]{fid, fnumber, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, forgid, fstartdate, fenddate, fpfknum, fpwxkznum, fscjyszx, fsthjzgbm, fpfksszgswjg, fjingdumiao, fweidumiao, fjingdu, fjingdufen, fweidu, fweidufen});
                        Map<String, List<Map>> endMap = swjgValue.stream().collect(Collectors.groupingBy(s -> s.get("FWRWLB").toString() + s.get("FWRWPFLJSFF") + s.get("FWRWMC") + s.get("FZSZM") + s.get("FSWRWZL")));
                        int seq = 1;
                        for (Map.Entry<String, List<Map>> endEntry : endMap.entrySet()) {
                            Object fwrwmc;
                            Map endVale = endEntry.getValue().get(0);
                            Object fwrwlb = endVale.get("FWRWLB");
                            Object fswrwzl = endVale.get("FSWRWZL");
                            if (!Objects.equals(1215008151309769728L, fwrwlb)) {
                                fswrwzl = 1221067502579091456L;
                            }
                            if (Objects.equals(fwrwmc = endVale.get("FWRWMC"), 1215040271642025984L) || Objects.equals(fwrwmc, 1215040409232071681L) || Objects.equals(fwrwmc, 1215040634734534657L)) {
                                fwrwmc = 0L;
                            }
                            Object fzszm = 0L;
                            if (PH_WATER_MAP.containsKey(fwrwmc)) {
                                fzszm = PH_WATER_MAP.get(fwrwmc);
                                fwrwmc = 1342639924817457155L;
                            }
                            paramSonList.add(new Object[]{fid, DBUtils.getLongId((String)"t_tcret_pollution_wrwmc"), seq, fwrwlb, fswrwzl, fwrwmc, fzszm, endVale.get("FWRWPFLJSFF"), endVale.get("FMARK")});
                            ++seq;
                        }
                    }
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    DBUtils.executeBatch((String)insertZsMainSql, paramMainList);
                    DBUtils.executeBatch((String)insertZsSonSql, paramSonList);
                    DBUtils.execute((String)String.format(updateZsSql, StringUtils.join((Object[])updateMainIds.toArray(), (String)",")));
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(ERROR_INFO, t);
                    this.addLog(ERROR, this.getStackTraceMessage(t));
                }
            }
        }
    }

    private void updateZsWrwlb() {
        String queryZsSql = "select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,forgid,fwrwname,fstartdate,fenddate,fwrwlb,fswrwzl,fwrwmc,fwrwpfljsff,fpfknum,fzszm,fpwxkznum,fscjyszx,fsthjzgbm,fmark,fpfksszgswjg,fjingdumiao,fweidumiao,fjingdu,fjingdufen,fweidu,fweidufen from t_tdm_pollution_basedata where fstatus=? and fwrwlb=? ";
        List zsQueryList = DBUtils.query((String)queryZsSql, (Object[])new Object[]{"C", 1215008151309769730L});
        if (CollectionUtils.isNotEmpty((Collection)zsQueryList)) {
            ArrayList<Object[]> paramMainList = new ArrayList<Object[]>(zsQueryList.size());
            ArrayList<Object[]> paramSonList = new ArrayList<Object[]>(zsQueryList.size());
            List updateMainIds = zsQueryList.stream().map(s -> s.get("FID")).collect(Collectors.toList());
            Map<Object, List<Map>> numberGroupBy = zsQueryList.stream().collect(Collectors.groupingBy(s -> s.get("FNUMBER")));
            for (Map.Entry<Object, List<Map>> objectListEntry : numberGroupBy.entrySet()) {
                List<Map> value = objectListEntry.getValue();
                for (int i = 0; i < value.size(); ++i) {
                    Map zsSingleRes = value.get(i);
                    Object fid = zsSingleRes.get("FID");
                    Object fnumber = zsSingleRes.get("FNUMBER");
                    Object fstatus = zsSingleRes.get("FSTATUS");
                    Object fcreatorid = zsSingleRes.get("FCREATORID");
                    Object fmodifierid = zsSingleRes.get("FMODIFIERID");
                    Object fenable = zsSingleRes.get("FENABLE");
                    Object fcreatetime = zsSingleRes.get("FCREATETIME");
                    Object fmodifytime = zsSingleRes.get("FMODIFYTIME");
                    Object fmasterid = zsSingleRes.get("FMASTERID");
                    Object forgid = zsSingleRes.get("FORGID");
                    Object fstartdate = zsSingleRes.get("FSTARTDATE");
                    Object fenddate = zsSingleRes.get("FENDDATE");
                    Object fpfknum = zsSingleRes.get("FPFKNUM");
                    Object fpwxkznum = zsSingleRes.get("FPWXKZNUM");
                    Object fscjyszx = zsSingleRes.get("FSCJYSZX");
                    Object fsthjzgbm = zsSingleRes.get("FSTHJZGBM");
                    Object fpfksszgswjg = zsSingleRes.get("FPFKSSZGSWJG");
                    Object fjingdumiao = zsSingleRes.get("FJINGDUMIAO");
                    Object fweidumiao = zsSingleRes.get("FWEIDUMIAO");
                    Object fjingdu = zsSingleRes.get("FJINGDU");
                    Object fjingdufen = zsSingleRes.get("FJINGDUFEN");
                    Object fweidu = zsSingleRes.get("FWEIDU");
                    Object fweidufen = zsSingleRes.get("FWEIDUFEN");
                    if (value.size() > 1) {
                        fnumber = fnumber + "-" + (i + 1) + "-ZS";
                    }
                    if (value.size() == 1) {
                        fnumber = fnumber + "-ZS";
                    }
                    paramMainList.add(new Object[]{fid, fnumber, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, forgid, fstartdate, fenddate, fpfknum, fpwxkznum, fscjyszx, fsthjzgbm, fpfksszgswjg, fjingdumiao, fweidumiao, fjingdu, fjingdufen, fweidu, fweidufen});
                    paramSonList.add(new Object[]{fid, DBUtils.getLongId((String)"t_tcret_pollution_wrwmc"), 1, zsSingleRes.get("FWRWLB"), 1221067502579091456L, 1221067502579091456L, 0, zsSingleRes.get("FWRWPFLJSFF"), zsSingleRes.get("FMARK")});
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    DBUtils.executeBatch((String)insertZsMainSql, paramMainList);
                    DBUtils.executeBatch((String)insertZsSonSql, paramSonList);
                    DBUtils.execute((String)String.format(updateZsSql, StringUtils.join((Object[])updateMainIds.toArray(), (String)",")));
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(ERROR_INFO, t);
                    this.addLog(ERROR, this.getStackTraceMessage(t));
                }
            }
        }
    }

    private void updateLangTable() {
        String queryLangSql = "select fpkid,fid,flocaleid,fname from  t_tdm_pollution_basedata_l where fid not in (select fid from t_tcret_pollution_basedat_l)";
        List langSqlList = DBUtils.query((String)queryLangSql);
        String insertLangSql = "INSERT INTO t_tcret_pollution_basedat_l(fpkid,fid,flocaleid,fname) VALUES (?, ?, ?, ?)";
        if (CollectionUtils.isNotEmpty((Collection)langSqlList)) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(langSqlList.size());
            for (Map langRes : langSqlList) {
                Object fpkid = langRes.get("FPKID");
                Object fid = langRes.get("FID");
                Object flocaleid = langRes.get("FLOCALEID");
                Object fname = langRes.get("FNAME");
                paramList.add(new Object[]{fpkid, fid, flocaleid, fname});
            }
            DBUtils.executeBatch((String)insertLangSql, paramList);
        }
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    static {
        PH_WATER_MAP.put(1215033989380037677L, 1580313732754455552L);
        PH_WATER_MAP.put(1215035712626515968L, 1580313732754455553L);
        PH_WATER_MAP.put(1215035712626515969L, 1580313732754455554L);
        PH_WATER_MAP.put(1215035712626515970L, 1580313732754455555L);
        PH_WATER_MAP.put(1215035712626515971L, 1580313732754455556L);
        PH_WATER_MAP.put(1215035712626515972L, 1580313732754455557L);
    }
}

