/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class SzysDeclareQueryUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SzysDeclareQueryUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
            this.updateBqybtse();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String exists = "select fid from t_tctb_declare_main where fid not in (select fid from t_tctb_declare_entry) and (fnsrtype = 'szys_a' or fnsrtype = 'szys_b')";
        String insertSql = "insert into t_tctb_declare_entry (fentryid,fid,fynse,fjmse,fyjse,fbqdybtse) values (?,?,?,?,?,?)";
        String szysQuerySql = "select fsbbid,fbqynse,fbqjmse,fbqyjse,fbqybtse from t_tcwat_declare_a_tax where fewblxh = 'sum'";
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main") || !DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_entry")) {
            return;
        }
        List existsData = DBUtils.query((String)"taxc", (String)exists);
        if (existsData.size() == 0) {
            return;
        }
        Set ids = existsData.stream().map(a -> a.get("FID")).collect(Collectors.toSet());
        List szysEntrys = DBUtils.query((String)"taxc", (String)szysQuerySql);
        if (!CollectionUtils.isEmpty((Collection)szysEntrys)) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : szysEntrys) {
                if (!ids.contains(Long.parseLong((String)row.get("FSBBID")))) continue;
                long fentryid = DBUtils.getLongId((String)"t_tctb_declare_entry");
                long fsbbid = Long.parseLong((String)row.get("FSBBID"));
                Object fynse = row.get("FBQYNSE");
                Object fjmse = row.get("FBQJMSE");
                Object fyjse = row.get("FBQYJSE");
                Object fybse = row.get("FBQYBTSE");
                paramList.add(new Object[]{fentryid, fsbbid, fynse, fjmse, fyjse, fybse});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)insertSql, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }

    private void updateBqybtse() {
        String exists = "select fid,fbqybtse from t_tctb_declare_main where fnsrtype = 'szys_a' or fnsrtype = 'szys_b'";
        String updateSql = "update t_tctb_declare_main set fbqybtse = ? where fid = ?";
        String szysQuerySql = "select fsbbid,fbqynse,fbqjmse,fbqyjse,fbqybtse from t_tcwat_declare_a_tax where fewblxh = 'sum'";
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main")) {
            return;
        }
        List existsData = DBUtils.query((String)"taxc", (String)exists);
        if (existsData.size() == 0) {
            return;
        }
        List szysEntrys = DBUtils.query((String)"taxc", (String)szysQuerySql);
        Map<String, Object> bqybtseMap = szysEntrys.stream().collect(Collectors.toMap(a -> a.get("FSBBID").toString(), b -> b.get("FBQYBTSE"), (m, n) -> m));
        if (!CollectionUtils.isEmpty((Collection)szysEntrys)) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : existsData) {
                if (bqybtseMap.get(row.get("FID").toString()) == null || ((BigDecimal)row.get("FBQYBTSE")).compareTo((BigDecimal)bqybtseMap.get(row.get("FID").toString())) == 0) continue;
                Object fid = row.get("FID");
                Object fbqybtse = bqybtseMap.get(row.get("FID").toString());
                paramList.add(new Object[]{fbqybtse, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

