/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class YhsAccrualDetailTaxLimitUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YhsAccrualDetailTaxLimitUpgradeService.class);
    private static final String SQL_SELECT_ACCRUAL_ENTRY = "select f.forgid,f.fskssqq,f.fskssqz,m.fentryid,m.ftaxitem from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftemplatetype = 'yhs' and (m.ftaxlimit = ' ' or m.ftaxlimit='')";
    private static final String SQL_SELECT_YHS_ENTRY = "select t3.fname,t2.forgid,t1.fperiod,t1.ftaxrateid,t1.feffectivedate,t1.fexpirydate from t_tctb_yhs_entry t1 inner join t_tctb_tax_main t2 on t1.fid=t2.fid inner join t_tpo_tcsd_taxrateentry_l t3 on t3.fentryid=t1.ftaxrateid where t2.ftaxationsys = 1 and t3.flocaleid='zh_CN'";
    private static final String SQL_UPDATE_ACCRUAL_ENTRY = "update t_tcret_accrual_entry set ftaxlimit = ? where fentryid = ?";
    private static final String SQL_UPDATE_SINGLE = "update t_tcret_accrual_entry set ftaxlimit = 'single' where (ftaxlimit = ' ' or ftaxlimit = '') and fid in (select fid from t_tpo_declare_main_tsd where ftemplatetype ='yhs');";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.info(ERROR_INFO, (Object)t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(true);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tpo_declare_main_tsd") && DB.getColumnNames((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_tax_main").contains("ftaxationsys") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_ACCRUAL_ENTRY)))) {
            List yhsEntrys = DBUtils.query((String)SQL_SELECT_YHS_ENTRY);
            Map<Object, List<Map>> taxitemNameIdMap = yhsEntrys.stream().collect(Collectors.groupingBy(d -> d.get("FORGID") + "" + d.get("FNAME")));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                Optional<Map> optional;
                Date skssqq = (Date)row.get("FSKSSQQ");
                Date skssqz = (Date)row.get("FSKSSQZ");
                Object orgid = row.get("FORGID");
                String taxitem = (String)row.get("FTAXITEM");
                List<Map> mapList = taxitemNameIdMap.get(orgid + "" + taxitem);
                if (EmptyCheckUtils.isEmpty(mapList) || !(optional = mapList.stream().filter(d -> d.get("FEFFECTIVEDATE") != null && ((Date)d.get("FEFFECTIVEDATE")).compareTo(skssqq) <= 0).filter(d -> d.get("FEXPIRYDATE") != null && ((Date)d.get("FEXPIRYDATE")).compareTo(skssqz) >= 0).findFirst()).isPresent() || !EmptyCheckUtils.isNotEmpty(optional.get().get("FPERIOD"))) continue;
                Map map = optional.get();
                Object ftaxlimit = map.get("FPERIOD");
                Object fentryid = row.get("FENTRYID");
                paramList.add(new Object[]{ftaxlimit, fentryid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE_ACCRUAL_ENTRY, paramList);
                    }
                    DBUtils.execute((String)SQL_UPDATE_SINGLE);
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

