/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class YhsTzSyxxBillnoUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YhsTzSyxxBillnoUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.updateTz();
            this.updateSyxx();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void updateTz() {
        String exists = "select fid,fskssqq from t_tcret_yhs_tz where (fbillno = ' ' or fbillno = '' or fbillno is null) order by fcreatetime";
        String updateSql = "update t_tcret_yhs_tz set fbillno = ? where fid = ?";
        List existsData = DBUtils.query((String)"taxc", (String)exists);
        if (existsData.size() == 0 || !this.metaIsExist("tcret_yhs_tax_account").booleanValue()) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(64);
        for (Map row : existsData) {
            Object fid = row.get("FID");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcret_yhs_tax_account");
            dynamicObject.set("skssqq", row.get("FSKSSQQ"));
            String number = CodeRuleServiceHelper.getNumber((String)"tcret_yhs_tax_account", (DynamicObject)dynamicObject, null);
            paramList.add(new Object[]{number, fid});
        }
        try (TXHandle h = TX.required();){
            try {
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void updateSyxx() {
        String exists = "select fid,fskssqq from t_tcret_sycj_yhsxx where (fbillno = ' ' or fbillno = '' or fbillno is null) order by fcreatetime";
        String updateSql = "update t_tcret_sycj_yhsxx set fbillno = ? where fid = ?";
        List existsData = DBUtils.query((String)"taxc", (String)exists);
        if (existsData.size() == 0 || !this.metaIsExist("tcret_yhs_tax_source_info").booleanValue()) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(64);
        for (Map row : existsData) {
            Object fid = row.get("FID");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcret_yhs_tax_source_info");
            dynamicObject.set("skssqq", row.get("FSKSSQQ"));
            String number = CodeRuleServiceHelper.getNumber((String)"tcret_yhs_tax_source_info", (DynamicObject)dynamicObject, null);
            paramList.add(new Object[]{number, fid});
        }
        try (TXHandle h = TX.required();){
            try {
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }
}

