/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.service.impl.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DeclareDraftUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(DeclareDraftUpgradeService.class);
    private static final String ZLB_INSERT_STR = "insert into t_tcsd_draft_zlb (FID, FBILLNO, FBILLSTATUS, FCREATORID, FCREATETIME,FMODIFIERID,FMODIFYTIME, FSTARTDATE, FENDDATE, FORGID, FSFXGMJZ, FJZBL) values (?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String FDEDUAMOUNT = "FDEDUAMOUNT";
    public static final String FPAYTAXCOUNT = "FPAYTAXCOUNT";
    public static final String FTAXITEM = "FTAXITEM";
    public static final String BQXGMZJE = "BQXGMZJE";
    public static final String BQYBTSE = "BQYBTSE";
    public static final String YNSE = "YNSE";
    public static final String YJSE = "YJSE";
    public static final String JMSE = "JMSE";
    private static final String LOGO_INFO = "DRAFT_TCSD MIGRATED UPDATE SUCCESS!";
    private static final BigDecimal divisor = new BigDecimal(100);
    private static final String ZT_INSERT_STR = "insert into t_tctb_draft_main(FID,FBILLNO,FBILLSTATUS,FCREATETIME,FCREATORID,FMODIFYTIME,FMODIFIERID,FORGID,FTEMPLATETYPE,FSTATUS,FSTARTDATE,FENDDATE,FTYPE) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String ZT_SE_INSERT_STR = "insert into t_tcsd_draft_entry (FID, FENTRYID, FSEQ, FBQYBTSE, FBQYNSE, FBQYJSE, FBQJMSE) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String ZLB_FB_INSERT_STR = "insert into t_tcsd_draft_zlb_entry (FID, FENTRYID, FSEQ, FTAXITEM, FYNSE, FYJSE, FJMSE, FZZSXGMJZE, FBQYBTSE) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = LOGO_INFO;
        String info = LOGO_INFO;
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.getStackTraceMessage(t);
            info = "TCSD DECLARE DRAFT UPDATE ERROR!!!\n" + log;
            LOGGER.error("TCSD DECLARE DRAFT UPDATE ERROR!!!", t);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update() {
        List results = DBUtils.query((String)"select a.fid,a.fcreatorid,a.fcreatetime,a.fmodifierid,a.fmodifytime,a.fskssqq,a.fskssqz,a.forgid,a.fnsrtype,a.fdatatype,a.fbillstatus,a.fdeclarestatus from t_tctb_declare_main a left join t_tcsd_draft_zlb b on a.fskssqq=b.fstartdate and  a.fskssqz=b.fenddate and a.forgid=b.forgid where a.fdatatype='1' and a.fbillstatus='C' and a.fdeclarestatus='declared' and a.fnsrtype='yhs' and b.fid is null order by a.fcreatetime asc");
        if (EmptyCheckUtils.isNotEmpty((Object)results)) {
            LOGGER.info(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u5df2\u7533\u62a5\uff0c\u5df2\u5ba1\u6838\u7684\u7cfb\u7edf\u751f\u6210\u7684\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5\u6570\u636e\uff1a", (String)"DeclareDraftUpgradeService_0", (String)"taxc-tcsd-mservice", (Object[])new Object[0]) + results.size());
            ArrayList<Object[]> zlbZbList = new ArrayList<Object[]>(results.size());
            ArrayList<Object[]> zlbFbList = new ArrayList<Object[]>(results.size() * 8);
            ArrayList<Object[]> ztList = new ArrayList<Object[]>(results.size());
            ArrayList<Object[]> ztSeList = new ArrayList<Object[]>(results.size());
            for (Map result : results) {
                String sbbid = String.valueOf(result.get("FID"));
                long zlbId = DBUtils.getLongId((String)"t_tcsd_draft_zlb");
                String isxgm = "0";
                BigDecimal jzbl = BigDecimal.ZERO;
                DynamicObjectCollection xgms = QueryServiceHelper.query((String)"tcsd_applicable_small", (String)"sfysxgmjzzzc,reductionratio", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid).and("ewblxh", "=", (Object)"1")});
                if (EmptyCheckUtils.isNotEmpty((Object)xgms)) {
                    String sfysxgmjzzzc = ((DynamicObject)xgms.get(0)).getString("sfysxgmjzzzc");
                    isxgm = StringUtil.equals((CharSequence)"0", (CharSequence)sfysxgmjzzzc) ? "0" : "1";
                    jzbl = ((DynamicObject)xgms.get(0)).getBigDecimal("reductionratio");
                }
                jzbl = jzbl.divide(divisor, 2, 4);
                DeclareDraftUpgradeService.fillZlbDataArray(zlbZbList, result, zlbId, isxgm, jzbl);
                HashMap<String, BigDecimal> draftEntryData = new HashMap<String, BigDecimal>(4);
                this.fillZlbFbData(zlbFbList, result, zlbId, isxgm, jzbl, draftEntryData);
                long statusId = DBUtils.getLongId((String)"t_tctb_draft_main");
                this.fillDraftBillData(ztList, result, statusId);
                this.fillDraftBillDecimalData(ztSeList, statusId, draftEntryData);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(zlbZbList)) {
                        DBUtils.executeBatch((String)ZLB_INSERT_STR, zlbZbList);
                    }
                    if (EmptyCheckUtils.isNotEmpty(zlbFbList)) {
                        DBUtils.executeBatch((String)ZLB_FB_INSERT_STR, zlbFbList);
                    }
                    if (EmptyCheckUtils.isNotEmpty(ztList)) {
                        DBUtils.executeBatch((String)ZT_INSERT_STR, ztList);
                    }
                    if (!EmptyCheckUtils.isNotEmpty(ztSeList)) return;
                    DBUtils.executeBatch((String)ZT_SE_INSERT_STR, ztSeList);
                    return;
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("TCSD DECLARE DRAFT UPDATE ERROR!!!", t);
                    throw new RuntimeException(t);
                }
            }
        } else {
            LOGGER.info(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u5df2\u7533\u62a5\uff0c\u5df2\u5ba1\u6838\u7684\u7cfb\u7edf\u751f\u6210\u7684\u5370\u82b1\u7a0e\u7533\u62a5\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u51fa\u6570\u636e\u5347\u7ea7", (String)"DeclareDraftUpgradeService_1", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
        }
    }

    private void fillDraftBillData(List<Object[]> ztList, Map<String, Object> result, long statusId) {
        Date fskssqq = (Date)result.get("FSKSSQQ");
        Date fskssqz = (Date)result.get("FSKSSQZ");
        String forgid = String.valueOf(result.get("FORGID"));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"tctb_draft_main");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        dynamicObject.set("startdate", (Object)fskssqq);
        dynamicObject.set("enddate", (Object)fskssqz);
        dynamicObject.set("org", (Object)forgid);
        dynamicObject.set("status", (Object)"3");
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("templatetype", (Object)"draft_yhs");
        String fbillno = CodeRuleServiceHelper.getNumber((String)"tctb_draft_main", (DynamicObject)dynamicObject, (String)String.valueOf(forgid));
        fbillno = fbillno.replaceAll("X", "SD-WP01");
        ztList.add(new Object[]{statusId, fbillno, "C", result.get("FCREATETIME"), result.get("FCREATORID") == null ? Integer.valueOf(0) : result.get("FCREATORID"), result.get("FMODIFYTIME"), result.get("FMODIFIERID") == null ? Integer.valueOf(0) : result.get("FMODIFIERID"), result.get("FORGID"), "draft_yhs", "3", result.get("FSKSSQQ"), result.get("FSKSSQZ"), "WP01"});
    }

    private void fillDraftBillDecimalData(List<Object[]> ztSeList, long statusId, HashMap<String, BigDecimal> draftEntryData) {
        ztSeList.add(new Object[]{statusId, DBUtils.getLongId((String)"t_tcsd_draft_entry"), "1", draftEntryData.get(BQYBTSE), draftEntryData.get(YNSE), draftEntryData.get(YJSE), draftEntryData.get(JMSE)});
    }

    private void fillZlbFbData(List<Object[]> zlbFbList, Map<String, Object> result, long zlbId, String isxgm, BigDecimal jzbl, HashMap<String, BigDecimal> draftEntryData) {
        Date fskssqq = (Date)result.get("FSKSSQQ");
        Date fskssqz = (Date)result.get("FSKSSQZ");
        String forgid = String.valueOf(result.get("FORGID"));
        String querySql = "select ftaxitem,fpaytaxcount,fdeduamount,forgid,fskssqq,fskssqz from t_tcsd_contract_summary where forgid=? and fskssqq=? and fskssqz=? union all select ftaxitem,fpaytaxcount,fdeduamount,forgid,fskssqq,fskssqz  from t_tcsd_money_book_summary where forgid=? and fskssqq=? and fskssqz=?";
        List querys = DBUtils.query((String)querySql, (Object[])new Object[]{forgid, fskssqq, fskssqz, forgid, fskssqq, fskssqz});
        HashMap taxitemMap = new HashMap(32);
        if (EmptyCheckUtils.isNotEmpty((Object)querys)) {
            for (Map query : querys) {
                if (query.get(FTAXITEM) == null) continue;
                HashMap<String, BigDecimal> ftaxitem = (HashMap<String, BigDecimal>)taxitemMap.get(query.get(FTAXITEM));
                if (ftaxitem == null) {
                    ftaxitem = new HashMap<String, BigDecimal>(8);
                }
                BigDecimal fpaytaxcount = ftaxitem.get(FPAYTAXCOUNT) == null ? BigDecimal.ZERO : (BigDecimal)ftaxitem.get(FPAYTAXCOUNT);
                BigDecimal fdeduamount = ftaxitem.get(FDEDUAMOUNT) == null ? BigDecimal.ZERO : (BigDecimal)ftaxitem.get(FDEDUAMOUNT);
                BigDecimal bqxgmzje = ftaxitem.get(BQXGMZJE) == null ? BigDecimal.ZERO : (BigDecimal)ftaxitem.get(BQXGMZJE);
                BigDecimal bqybtse = ftaxitem.get(BQYBTSE) == null ? BigDecimal.ZERO : (BigDecimal)ftaxitem.get(BQYBTSE);
                BigDecimal fpaytaxcount1 = query.get(FPAYTAXCOUNT) == null ? BigDecimal.ZERO : (BigDecimal)query.get(FPAYTAXCOUNT);
                BigDecimal fdeduamount1 = query.get(FDEDUAMOUNT) == null ? BigDecimal.ZERO : (BigDecimal)query.get(FDEDUAMOUNT);
                BigDecimal bqxgmzje1 = "0".equals(isxgm) ? BigDecimal.ZERO : fpaytaxcount1.subtract(fdeduamount1).multiply(jzbl).setScale(2, 4);
                BigDecimal bqybtse1 = fpaytaxcount1.subtract(fdeduamount1).subtract(bqxgmzje1).setScale(2, 4);
                BigDecimal fpaytaxamountSum = fpaytaxcount.add(fpaytaxcount1);
                BigDecimal fdeduamountSum = fdeduamount.add(fdeduamount1);
                BigDecimal bqxgmzjeSum = bqxgmzje.add(bqxgmzje1);
                BigDecimal bqybtseSum = bqybtse.add(bqybtse1);
                ftaxitem.put(FPAYTAXCOUNT, fpaytaxamountSum);
                ftaxitem.put(FDEDUAMOUNT, fdeduamountSum);
                ftaxitem.put(BQXGMZJE, bqxgmzjeSum);
                ftaxitem.put(BQYBTSE, bqybtseSum);
                ftaxitem.put(FTAXITEM, (BigDecimal)query.get(FTAXITEM));
                taxitemMap.put(query.get(FTAXITEM), ftaxitem);
            }
        }
        BigDecimal ynse = BigDecimal.ZERO;
        BigDecimal yjse = BigDecimal.ZERO;
        BigDecimal jmse = BigDecimal.ZERO;
        BigDecimal bqybtse = BigDecimal.ZERO;
        int i = 0;
        for (Map.Entry entry : taxitemMap.entrySet()) {
            long entryid = DBUtils.getLongId((String)"t_tcsd_draft_zlb_entry");
            Map value = (Map)entry.getValue();
            zlbFbList.add(new Object[]{zlbId, entryid, String.valueOf(++i), value.get(FTAXITEM), value.get(FPAYTAXCOUNT), BigDecimal.ZERO, value.get(FDEDUAMOUNT), value.get(BQXGMZJE), value.get(BQYBTSE)});
            ynse = ynse.add((BigDecimal)value.get(FPAYTAXCOUNT));
            jmse = jmse.add((BigDecimal)value.get(FDEDUAMOUNT));
            bqybtse = bqybtse.add((BigDecimal)value.get(BQYBTSE));
        }
        draftEntryData.put(YNSE, ynse.setScale(2, 4));
        draftEntryData.put(YJSE, yjse.setScale(2, 4));
        draftEntryData.put(JMSE, jmse.setScale(2, 4));
        draftEntryData.put(BQYBTSE, bqybtse.setScale(2, 4));
    }

    private static void fillZlbDataArray(List<Object[]> zlbZbList, Map<String, Object> result, long zlbId, String isxgm, BigDecimal jzbl) {
        zlbZbList.add(new Object[]{zlbId, " ", "A", result.get("FCREATEORID") == null ? Integer.valueOf(0) : result.get("FCREATEORID"), result.get("FCREATETIME"), result.get("FMODIFIERID") == null ? Integer.valueOf(0) : result.get("FMODIFIERID"), result.get("FMODIFYTIME"), result.get("FSKSSQQ"), result.get("FSKSSQZ"), result.get("FORGID"), isxgm, jzbl.multiply(divisor)});
    }
}

