/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.service.impl.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceTypeUpgradeService
implements IUpgradeService {
    private static Map<String, String> map = new HashMap<String, String>();
    private static final Log LOGGER = LogFactory.getLog(InvoiceTypeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        InvoiceTypeUpgradeService.update();
        result.setLog(ResManager.loadKDString((String)"\u66f4\u65b0TCSD\u53d1\u7968\u7c7b\u578b\u8fc7\u7a0b", (String)"InvoiceTypeUpgradeService_0", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
        return result;
    }

    private static void update() {
        try {
            Boolean isExist = InvoiceTypeUpgradeService.metaIsExist("bd_invoicetype");
            if (!isExist.booleanValue()) {
                return;
            }
            DynamicObject[] invoicetypes = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,number,name", null);
            Map<String, String> invoiceTypeMap = Arrays.stream(invoicetypes).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
            Map<String, String> invoiceTypeNameMap = Arrays.stream(invoicetypes).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("name")));
            for (Map.Entry<String, String> entry : map.entrySet()) {
                DynamicObject[] dynamicObjects;
                QFilter qFilter = new QFilter(entry.getValue() + ".filtercondition", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
                isExist = InvoiceTypeUpgradeService.metaIsExist(entry.getKey());
                if (!isExist.booleanValue() || (dynamicObjects = BusinessDataServiceHelper.load((String)entry.getKey(), (String)("id," + entry.getValue() + ".filtercondition," + entry.getValue() + ".conditionjson"), (QFilter[])new QFilter[]{qFilter})) == null || dynamicObjects.length <= 0) continue;
                Arrays.stream(dynamicObjects).forEach(o -> {
                    DynamicObjectCollection dynamicObjectCollection = o.getDynamicObjectCollection("entryentity");
                    if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                        dynamicObjectCollection.stream().forEach(e -> {
                            String filterCondition = e.getString("filtercondition");
                            if (StringUtils.isNotEmpty((CharSequence)filterCondition) && filterCondition.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"InvoiceTypeUpgradeService_3", (String)"taxc-tcsd-mservice", (Object[])new Object[0]))) {
                                String conditionJson = e.getString("conditionjson");
                                HashMap conditionMap = (HashMap)JsonUtil.fromJson((String)conditionJson, Map.class);
                                List simpleFilterRows = (List)conditionMap.get("FilterRow");
                                ArrayList types = new ArrayList();
                                simpleFilterRows.forEach(s -> {
                                    if ("type".equals(s.get("FieldName"))) {
                                        s.put("FieldName", "baseinvoicetype.number");
                                        ArrayList baseDataIds = new ArrayList();
                                        List values = (List)s.get("Value");
                                        values.stream().forEach(v -> {
                                            HashMap<String, String> map = new HashMap<String, String>();
                                            map.put("Id", Base39Coder.toString((long)IDService.get().genLongId()));
                                            map.put("Value", (String)invoiceTypeMap.get(v.get("Value")));
                                            types.add(invoiceTypeNameMap.get(v.get("Value")));
                                            baseDataIds.add(map);
                                        });
                                        s.put("BaseDataIds", baseDataIds);
                                    }
                                });
                                conditionMap.put("FilterRow", simpleFilterRows);
                                e.set("conditionjson", (Object)JsonUtil.toJson((Object)conditionMap));
                                if (CollectionUtils.isNotEmpty(types)) {
                                    String[] filterConditions = e.getString("filtercondition").split(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"InvoiceTypeUpgradeService_4", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
                                    ArrayList newFilterConditions = new ArrayList();
                                    Arrays.asList(filterConditions).forEach(f -> {
                                        if (f.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"InvoiceTypeUpgradeService_3", (String)"taxc-tcsd-mservice", (Object[])new Object[0]))) {
                                            Object[] tempFilterConditions = f.split(" ");
                                            tempFilterConditions[0] = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u540d\u79f0", (String)"InvoiceTypeUpgradeService_5", (String)"taxc-tcsd-mservice", (Object[])new Object[0]);
                                            tempFilterConditions[2] = String.join((CharSequence)";", types);
                                            newFilterConditions.add(StringUtils.join((Object[])tempFilterConditions, (String)" "));
                                        } else {
                                            newFilterConditions.add(f);
                                        }
                                    });
                                    if (CollectionUtils.isNotEmpty(newFilterConditions)) {
                                        if (newFilterConditions.size() > 1) {
                                            e.set("filtercondition", (Object)StringUtils.join((Object[])newFilterConditions.toArray(), (String)ResManager.loadKDString((String)"\u5e76\u4e14", (String)"InvoiceTypeUpgradeService_4", (String)"taxc-tcsd-mservice", (Object[])new Object[0])));
                                        } else {
                                            e.set("filtercondition", newFilterConditions.toArray()[0]);
                                        }
                                    }
                                }
                            }
                        });
                    }
                });
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            }
        }
        catch (Exception e) {
            LOGGER.error("update error", (Throwable)e);
            return;
        }
    }

    private static Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        map.put("tcsd_rule_cqzysj", "entryentity");
        map.put("tcsd_rule_yshtpz", "entryentity");
        map.put("tcsd_rule_zjzb", "entryentity");
    }
}

