/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.service.impl.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class RuleDeclareTypeUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(RuleDeclareTypeUpgradeService.class);
    private static final String SQL_SELECT_RULES = "select fid,forgid,ftaxitemid from %s where fdeclaretype = ' ' or fdeclaretype='';";
    private static final String SQL_SELECT_YHS_ENTRY = "select t2.forgid,t1.fperiod,t1.fdeclaretype,t1.ftaxrateid,t1.feffectivedate,t1.fexpirydate from t_tctb_yhs_entry t1 inner join t_tctb_tax_main t2 on t1.fid=t2.fid where t2.ftaxationsys = 1;";
    private static final String SQL_UPDATE_RULE_DECLARETYPE = "update %s set fdeclaretype = ? where fid = ?";
    private static final String SQL_UPDATE_ACSB = "update %s set fdeclaretype = 'acsb' where fid in (select fid from t_tcsd_rule_entry where ftable = 1783466544513174528 and ffconditionjson like '%acsb%') and (fdeclaretype = ' ' or fdeclaretype = '');";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.info(ERROR_INFO, (Object)t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(true);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_tax_main") && DB.getColumnNames((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_tax_main").contains("ftaxationsys")) {
            List yhsEntrys = DBUtils.query((String)SQL_SELECT_YHS_ENTRY);
            this.updateTable(yhsEntrys, "t_tcsd_rule_zjzb");
            this.updateTable(yhsEntrys, "t_tcsd_rule_cqzysj");
            this.updateTable(yhsEntrys, "t_tcsd_rule_yshtpz");
        }
    }

    private void updateTable(List<Map<String, Object>> yhsEntrys, String table) {
        List needUpdateDatas = DBUtils.query((String)String.format(SQL_SELECT_RULES, table));
        if (EmptyCheckUtils.isNotEmpty((Object)needUpdateDatas)) {
            Map<Object, List<Map>> taxrateidMap = yhsEntrys.stream().collect(Collectors.groupingBy(d -> d.get("FORGID") + "" + d.get("FTAXRATEID")));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            Date now = new Date();
            for (Map row : needUpdateDatas) {
                Optional<Map> optional;
                Object orgid = row.get("FORGID");
                Object ftaxitemid = row.get("FTAXITEMID");
                List<Map> mapList = taxrateidMap.get(orgid + "" + ftaxitemid);
                if (EmptyCheckUtils.isEmpty(mapList) || !(optional = mapList.stream().filter(d -> d.get("FEFFECTIVEDATE") != null && ((Date)d.get("FEFFECTIVEDATE")).compareTo(now) <= 0).filter(d -> d.get("FEXPIRYDATE") != null && ((Date)d.get("FEXPIRYDATE")).compareTo(now) >= 0).findFirst()).isPresent() || !EmptyCheckUtils.isNotEmpty(optional.get().get("FDECLARETYPE"))) continue;
                Map map = optional.get();
                Object fdeclaretype = map.get("FDECLARETYPE");
                Object fid = row.get("FID");
                paramList.add(new Object[]{fdeclaretype, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)String.format(SQL_UPDATE_RULE_DECLARETYPE, table), paramList);
                    }
                    DBUtils.execute((String)SQL_UPDATE_ACSB.replace("%s", table));
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

