/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.business.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.business.service.RuleService;
import kd.taxc.tcsd.business.service.TaxRateService;
import kd.taxc.tcsd.business.task.AccountDetailTask;
import kd.taxc.tcsd.common.util.CalUtils;
import kd.taxc.tcsd.common.util.UUID;

public class ContractVoucherEngine
extends EngineTask<EngineModel, DynamicObject>
implements IEngine<EngineModel> {
    private static final String PAGE_ACCOUNT_SUMMARY = "tcsd_contract_summary";
    private static final String PAGE_ACCOUNTING_DETAIL = "tcsd_contract_detail";
    private static final String TCSD_TAX_POLICY = "tcsd_tax_policy";
    public static final String TCSD_RULE_YSHTPZ = "tcsd_rule_yshtpz";
    public static final String TCSD_RULE_CQZYSJ = "tcsd_rule_cqzysj";
    public static final String TAX_ITEM = "taxitem";
    private static final String TAXATION = "taxation";
    private static final String TYPE = "type";
    private static final String ORG_ID = "orgid";
    public static final String AQHZ = "aqhz";
    public static final String HDZS = "hdzs";
    private static final String TAX_PERIOD = "taxperiod";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    private static Log logger = LogFactory.getLog(ContractVoucherEngine.class);

    public DynamicObject execute() throws Exception {
        EngineModel model = this.getEngineModel();
        this.deleteData(model);
        this.runEngine(model);
        return null;
    }

    public void calSummaryAccountList(List<DynamicObject> summaryList, List<DynamicObject> summaryAccountingList, Map<String, Map<String, Object>> errorMap, Map<String, String> dataMap, EngineModel engineModel, String entityName, String accountType) throws Exception {
        String orgId = engineModel.getOrgId();
        DynamicObjectCollection ruleList = RuleService.getRuleList(orgId, "private", entityName);
        String ruleType = accountType.equals("1") ? "yshtpz" : "cqzysj";
        ruleList.addAll((Collection)RuleService.getPublicRules(orgId, ruleType));
        Object validcard = engineModel.getCustom().get("validcard");
        List<Object> ids = new ArrayList();
        List validCards = new ArrayList();
        if (validcard != null) {
            validCards = (List)validcard;
            List collect = validCards.stream().map(s -> {
                String taxation = s.getBoolean("isverify") ? HDZS : AQHZ;
                return s.getString("taxrate.number") + taxation;
            }).collect(Collectors.toList());
            ids = ruleList.stream().filter(a -> {
                String key = a.getString("tnumber") + a.getString(TAXATION);
                return collect.contains(key);
            }).map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.stream().toArray(), (DynamicObjectType)type);
            Map<String, List<DynamicObject>> validCardMap = validCards.stream().collect(Collectors.groupingBy(s -> s.getString("taxrate.number") + (s.getString("isverify").equals("false") ? AQHZ : HDZS)));
            for (DynamicObject rule : load) {
                String taxation = rule.getString(TAXATION);
                String taxItemNumber = rule.getString("taxitem.number");
                List<DynamicObject> list = validCardMap.get(taxItemNumber + taxation);
                for (DynamicObject yhsCardItem : list) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)PAGE_ACCOUNT_SUMMARY);
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set(ORG_ID, (Object)orgId);
                    summary.set(TAX_PERIOD, engineModel.getCustom().get(TAX_PERIOD));
                    summary.set(SKSSQQ, (Object)DateUtils.stringToDate((String)engineModel.getStartDate()));
                    summary.set(SKSSQZ, (Object)DateUtils.stringToDate((String)engineModel.getEndDate()));
                    long taxItemId = rule.getDynamicObject(TAX_ITEM).getLong("id");
                    summary.set(TAX_ITEM, (Object)taxItemId);
                    summary.set(TAXATION, (Object)taxation);
                    summary.set("businessname", (Object)rule.getString("name"));
                    String fitTaxRate = TaxRateService.getTaxRate(taxItemId);
                    summary.set("fittaxrate", (Object)rule.getLong("id"));
                    String serialNo = UUID.randomUUID();
                    summary.set("serialno", (Object)serialNo);
                    String verifyRate = AQHZ.equals(taxation) ? "0" : yhsCardItem.getString("hdrate");
                    summary.set("verifyrate", (Object)verifyRate);
                    AccountDetailTask ruleSettingTask = new AccountDetailTask(dataMap, errorMap, rule, engineModel, rule.getDynamicObjectCollection("entryentity"), serialNo, PAGE_ACCOUNTING_DETAIL, "", accountType, yhsCardItem);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List accountingList = ContractVoucherEngine.getFutureList((List)futures);
                    summaryAccountingList.addAll(accountingList);
                    BigDecimal accountingAmount = this.getAccountingAmount(accountingList);
                    BigDecimal payTaxCount = BigDecimal.ZERO;
                    if (AQHZ.equals(taxation)) {
                        summary.set("taxamount", (Object)accountingAmount.setScale(2, 4));
                        summary.set("verifybasis", (Object)"0");
                        payTaxCount = CalUtils.getRateBigDecimal(fitTaxRate).multiply(accountingAmount);
                    } else if (HDZS.equals(taxation)) {
                        summary.set("verifybasis", (Object)accountingAmount);
                        summary.set("taxamount", (Object)"0");
                        payTaxCount = CalUtils.getRateBigDecimal(fitTaxRate).multiply(accountingAmount).multiply(new BigDecimal(verifyRate));
                    }
                    summary.set("paytaxcount", (Object)payTaxCount.setScale(2, 4));
                    summary.set(TYPE, (Object)accountType);
                    DynamicObject dynamicObject = null;
                    if (rule.getBoolean("suitable")) {
                        dynamicObject = rule.getDynamicObject("deductioncode");
                    }
                    summary.set("deductioncode", (Object)(dynamicObject != null ? dynamicObject.getString("id") : "0"));
                    String deductiontype = dynamicObject != null ? this.getDeductiontype(dynamicObject.getString("number")) : "";
                    summary.set("deductiontype", (Object)deductiontype);
                    summary.set("deduamount", this.getDeduAmount(deductiontype, payTaxCount));
                    summaryList.add(summary);
                }
            }
            SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        }
    }

    public String getDeductiontype(String number) {
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection deductionPolicy = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"deductiontype", (QFilter[])new QFilter[]{idFilter});
        if (deductionPolicy.size() > 0) {
            return ((DynamicObject)deductionPolicy.get(0)).getString("deductiontype");
        }
        return "";
    }

    private Object getDeduAmount(String deductiontype, BigDecimal payTaxCount) {
        BigDecimal deduAmount = "1".equals(deductiontype) ? payTaxCount : ("2".equals(deductiontype) ? payTaxCount.multiply(new BigDecimal("0.5")) : BigDecimal.ZERO);
        return deduAmount.setScale(2, 4);
    }

    public DynamicObjectCollection getTaxConfirmCollection() {
        EngineModel model = this.getEngineModel();
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgidFilter = new QFilter(ORG_ID, "=", (Object)Long.parseLong(orgId));
        QFilter dateFilter = new QFilter(STARTDATE, "=", (Object)startDate).and(new QFilter(ENDDATE, "=", (Object)endDate));
        DynamicObject confirm = QueryServiceHelper.queryOne((String)TCSD_TAX_POLICY, (String)"id", (QFilter[])new QFilter[]{orgidFilter, dateFilter});
        if (confirm == null) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)confirm.get("id"), (String)TCSD_TAX_POLICY);
        return dynamicObject.getDynamicObjectCollection("entryentity");
    }

    private BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("amount"));
        }
        return totalAmount;
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter orgFilter = new QFilter(ORG_ID, "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter skssqqzFilter = new QFilter(SKSSQQ, "=", (Object)startDate).and(new QFilter(SKSSQZ, "=", (Object)endDate));
        DeleteServiceHelper.delete((String)PAGE_ACCOUNT_SUMMARY, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)PAGE_ACCOUNTING_DETAIL, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
    }

    public void runEngine(EngineModel model) {
        try {
            this.setEngineModel(model);
            logger.info("\u5f00\u59cb\u6267\u884c\u5e94\u7a0e\u53f0\u8d26\u5f15\u64ce");
            long start = System.currentTimeMillis();
            DynamicObjectCollection list = this.getTaxConfirmCollection();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
                ConcurrentHashMap<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
                ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
                EngineModel engineModel = this.getEngineModel();
                this.calSummaryAccountList(summaryList, summaryAccountingList, errorMap, dataMap, engineModel, TCSD_RULE_YSHTPZ, "1");
                this.calSummaryAccountList(summaryList, summaryAccountingList, errorMap, dataMap, engineModel, TCSD_RULE_CQZYSJ, "2");
                SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
            }
            logger.info("\u7ed3\u675f\u6267\u884c\u5e94\u7a0e\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

