/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.business.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class TaxitemService {
    public static List<Long> findTaxitemIds(Long orgId, Date now) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return new ArrayList<Long>();
        }
        DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection yhsEntitys = taxMain.getDynamicObjectCollection("yhsentity");
        return yhsEntitys.stream().filter(d -> d.getDate("effectivedate") != null && d.getDate("effectivedate").compareTo(now) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(now) >= 0).map(d -> d.getLong("taxrate.id")).collect(Collectors.toList());
    }

    public static String findDeclareType(Long orgId, Long taxitemId, Date now) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return "";
        }
        DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection yhsEntitys = taxMain.getDynamicObjectCollection("yhsentity");
        Optional<String> optional = yhsEntitys.stream().filter(d -> d.getDate("effectivedate") != null && d.getDate("effectivedate").compareTo(now) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(now) >= 0).filter(d -> d.getLong("taxrate.id") == taxitemId.longValue()).map(d -> d.getString("declaretype")).findFirst();
        return optional.orElse("");
    }
}

