/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.business.service.RuleService;

public class DeclareService {
    private static final String ORG_ID = "orgid";
    private static final String TCSD_CONTRACT_VOUCHER = "tcsd_rule_yshtpz";
    private static final String TCSD_TRANSFER_DOCUMENTS = "tcsd_rule_cqzysj";
    private static final String TCSD_MONEY_ACCOUNT_BOOK = "tcsd_rule_zjzb";
    public static final String YSHTPZ = "yshtpz";
    public static final String CQZYSJ = "cqzysj";
    public static final String ZJZB = "zjzb";
    private static final String VERIFY_LEVY = "hdzs";
    private static final String GATHER_BY_DATE = "aqhz";
    private static final Set<String> NOCONTAINLIST = new LinkedHashSet<String>();
    public static final String TCSD_DRAFT_ZLB_BILL = "tcsd_draft_zlb_bill";
    public static final String ENTRYENTITY = "entryentity";
    private static final String PAGE_ACCOUNT_SUMMARY = "tcsd_contract_summary";
    private static final String TCSD_MONEY_BOOK_SUMMARY = "tcsd_money_book_summary";
    public static final String FIELDS = "taxitem,businessname,taxation,taxamount,verifybasis,verifyrate,fittaxrate,paytaxcount,serialno,deductioncode,deductiontype,deduamount";
    public static final String SFXGMJZ = "sfxgmjz";
    public static final String JZBL = "jzbl";
    public static final String YJSE = "yjse";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    public static final String TCSD_DECLARE_DRAFT = "tcsd_declare_draft";

    public static void checkCardNoRule(String orgId, Date startDate, Date endDate, AbstractFormPlugin plugin) {
        List<DynamicObject> collect = DeclareService.getValidCard(orgId, startDate, endDate);
        if (collect.size() > 0) {
            DeclareService.checkCardConfig(startDate, endDate, DeclareService.collectRuleList(orgId), collect, plugin);
        }
    }

    public static void checkCardConfig(Date startDate, Date endDate, Map<String, DynamicObject> taxItemList, List<DynamicObject> orgTaxItemMainCollection, AbstractFormPlugin plugin) {
        if (startDate == null || endDate == null) {
            return;
        }
        List noRuleItems = orgTaxItemMainCollection.stream().filter(object -> {
            if (NOCONTAINLIST.contains(object.getString("taxrate.number"))) {
                return false;
            }
            String key = object.getString("taxrate.id") + "_" + (object.getString("isverify").equals("false") ? GATHER_BY_DATE : VERIFY_LEVY);
            return taxItemList.get(key) == null;
        }).collect(Collectors.toList());
        if (noRuleItems.size() > 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("tcsd_declare_rulecheck");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "checkNoRuleCard"));
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("noRuleItems", noRuleItems);
            customParams.put(ORG_ID, plugin.getPageCache().get(ORG_ID));
            parameter.setCustomParams(customParams);
            plugin.getView().showForm(parameter);
        }
    }

    public static Map<String, DynamicObject> collectRuleList(String orgId) {
        DynamicObjectCollection voucherPrivates = RuleService.getRuleList(orgId, "private", TCSD_CONTRACT_VOUCHER);
        DynamicObjectCollection transferPrivates = RuleService.getRuleList(orgId, "private", TCSD_TRANSFER_DOCUMENTS);
        DynamicObjectCollection bookPrivates = RuleService.getRuleList(orgId, "private", TCSD_MONEY_ACCOUNT_BOOK);
        voucherPrivates.addAll((Collection)RuleService.getPublicRules(orgId, YSHTPZ));
        transferPrivates.addAll((Collection)RuleService.getPublicRules(orgId, CQZYSJ));
        bookPrivates.addAll((Collection)RuleService.getPublicRules(orgId, ZJZB));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        voucherPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        transferPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        bookPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        return map;
    }

    public static List<DynamicObject> getValidCard(String orgId, Date startDate, Date endDate) {
        TaxResult taxResult;
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        Boolean enableYhs = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)Long.parseLong(orgId)).getData();
        if (enableYhs.booleanValue() && (taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(Long.parseLong(orgId)))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObjectCollection yhsentity = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
            List collect = yhsentity.stream().filter(a -> taxLimit.equals(a.getString("period"))).filter(a -> {
                Date expirydate;
                if (a.get("effectivedate") == null || a.get("expirydate") == null) {
                    return false;
                }
                Date effectivedate = a.getDate("effectivedate");
                return !(effectivedate.before(expirydate = a.getDate("expirydate")) && effectivedate.after(endDate) || effectivedate.before(expirydate) && expirydate.before(startDate));
            }).collect(Collectors.toList());
            Supplier<Comparator> comparatorSupplier = () -> Comparator.comparing(d -> d.getString("taxrate.id")).thenComparing(d -> d.getString("isverify"));
            return collect.stream().sorted(comparatorSupplier.get()).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    public static DynamicObject queryZlb(String orgId, String startdate, String enddate) {
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCSD_DRAFT_ZLB_BILL, (String)"id,billstatus", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        return query.size() > 0 ? (DynamicObject)query.get(0) : null;
    }

    public static int deleteZlb(String orgId, String startdate, String enddate) {
        return 0;
    }

    public static void buildZlbBill(String startdate, String enddate, String orgId) {
    }

    static {
        NOCONTAINLIST.add("013");
        NOCONTAINLIST.add("014");
    }
}

