/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.business.task;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AccountDetailTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(AccountDetailTask.class);
    private BigDecimal reverse = new BigDecimal(-1);
    private BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private int batchSize = 5;
    private Map<String, String> dataMap;
    private Map<String, Map<String, Object>> errorMap;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private String type;
    private DynamicObject yhsCardItem;

    public AccountDetailTask(Map<String, String> dataMap, Map<String, Map<String, Object>> errorMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String type, DynamicObject yhsCardItem) {
        this.dataMap = dataMap;
        this.errorMap = errorMap;
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.type = type;
        this.yhsCardItem = yhsCardItem;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long startTime = System.currentTimeMillis();
        String startDate = this.model.getStartDate();
        String endDate = this.model.getEndDate();
        Date start = DateUtils.stringToDate((String)startDate);
        Date end = DateUtils.stringToDate((String)endDate);
        Date effectivedate = this.yhsCardItem.getDate("effectivedate");
        Date expirydate = this.yhsCardItem.getDate("expirydate");
        if (effectivedate.after(DateUtils.stringToDate((String)startDate))) {
            startDate = DateUtils.format((Date)effectivedate, (String)"yyyy-MM-dd");
        }
        if (expirydate.before(DateUtils.stringToDate((String)endDate))) {
            endDate = DateUtils.format((Date)expirydate, (String)"yyyy-MM-dd");
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        for (DynamicObject setting : settings) {
            this.fetchData(start, end, startDate, endDate, setting, filterList, list);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + ":" + list);
        return list;
    }

    private void fetchData(Date start, Date end, String startDate, String endDate, DynamicObject setting, List<QFilter> filterList, List<DynamicObject> list) {
        DynamicObject detailDynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
        detailDynamicObject.set("orgid", (Object)this.model.getOrgId());
        detailDynamicObject.set("taxaccountserialno", (Object)this.taxaccountserialno);
        detailDynamicObject.set("skssqq", (Object)DateUtils.stringToDate((String)this.model.getStartDate()));
        detailDynamicObject.set("skssqz", (Object)DateUtils.stringToDate((String)this.model.getEndDate()));
        detailDynamicObject.set("taxperiod", (Object)this.composeTaxPeriod(startDate, endDate));
        DynamicObject amountfield = setting.getDynamicObject("amountfield");
        detailDynamicObject.set("amountfield", (Object)amountfield.getLong("id"));
        detailDynamicObject.set("datatype", setting.get("datatype"));
        detailDynamicObject.set("datadirection", setting.get("datadirection"));
        detailDynamicObject.set("filtercondition", setting.get("filtercondition"));
        detailDynamicObject.set("type", (Object)this.type);
        String amountField = setting.getDynamicObject("amountfield").getString("fieldname");
        String fieldsubname = setting.getDynamicObject("amountfield").getString("fieldsubname");
        String advancedconf = setting.getString("advancedconfjson");
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        DynamicObject table = setting.getDynamicObject("table");
        if (table != null) {
            String selectFieldwithid;
            QFilter qFilters;
            String conditionjson;
            boolean isBeginOrEnd;
            detailDynamicObject.set("table", (Object)table.getLong("id"));
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String org = (String)fieldMap.get("orgstate");
            if (null != org) {
                filterList.add(new QFilter(org, "=", (Object)Long.parseLong(this.model.getOrgId())));
            }
            if (!(isBeginOrEnd = ((Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"GlBalanceService", (String)"financeBeginEnd", (Object[])new Object[]{fieldsubname, advancedconf})).booleanValue())) {
                RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconf, start, end, filterList, fieldsubname, fieldMap, entryName);
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setRuleConfigTimeFilter", (Object[])new Object[]{ruleTimeFilterDto});
            }
            if (StringUtils.isNotBlank((String)(conditionjson = setting.getString("conditionjson"))) && (qFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                filterList.add(qFilters);
            }
            if (entryName.equals("tdm_invoice_output")) {
                filterList.add(new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
            }
            boolean isEntityField = false;
            String selectField = amountField;
            if (!entryName.equals(fieldsubname)) {
                isEntityField = true;
                selectField = fieldsubname + "." + amountField;
                selectFieldwithid = fieldsubname + ".id as id," + fieldsubname + "." + amountField;
            } else {
                selectFieldwithid = "id," + amountField;
            }
            DynamicObjectCollection accountingList = null;
            if (!"tdm_finance_main".equals(entryName)) {
                if (isBeginOrEnd) {
                    accountingList = GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)advancedconf, (String)amountField, (String)this.model.getStartDate(), (String)this.model.getEndDate(), filterList);
                } else {
                    accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
                    isBeginOrEnd = (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"GlBalanceService", (String)"tdmBalanceNew", (Object[])new Object[]{fieldsubname, advancedconf});
                }
            } else {
                QFilter skssqzFilter;
                QFilter skssqqFilter;
                QFilter orgFilter;
                DynamicObjectCollection fidCollection;
                QFilter tableid = new QFilter("id", "=", (Object)table.getLong("id"));
                QFilter[] filters = new QFilter[]{tableid};
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.id,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
                DynamicObject orgstate = null;
                DynamicObject datastate = null;
                for (DynamicObject d : collection) {
                    if ("true".equals(d.getString("entryentity.orgstate"))) {
                        orgstate = d;
                    }
                    if (!"true".equals(d.getString("entryentity.datastate"))) continue;
                    datastate = d;
                }
                if (orgstate != null && datastate != null && CollectionUtils.isNotEmpty((Collection)(fidCollection = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{orgFilter = new QFilter(orgstate.getString("entryentity.fieldname"), "=", (Object)Long.parseLong(this.model.getOrgId())), skssqqFilter = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startDate))), skssqzFilter = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endDate)))})))) {
                    QFilter q;
                    ArrayList<String> sbbids = new ArrayList<String>();
                    for (DynamicObject dynamicObject : fidCollection) {
                        sbbids.add(dynamicObject.getString("id"));
                    }
                    QFilter filter = new QFilter("sbbid", "in", sbbids);
                    if (StringUtils.isNotBlank((String)conditionjson) && StringUtils.isNotBlank((String)fieldsubname) && (q = FilterBuilderUtils.buildFilter((String)conditionjson, (String)fieldsubname)) != null) {
                        filter = filter.and(q);
                    }
                    accountingList = QueryServiceHelper.query((String)fieldsubname, (String)selectFieldwithid, (QFilter[])new QFilter[]{filter});
                }
            }
            if (accountingList != null && accountingList.size() > 0) {
                for (DynamicObject dynamicObject : accountingList) {
                    String entryIdData;
                    if (dynamicObject == null) continue;
                    String entryId = dynamicObject.getString("id");
                    String ruletype = this.rule.getDataEntityType().getName();
                    String key = ruletype + entryName + entryId;
                    if (isEntityField) {
                        key = ruletype + entryName + fieldsubname + entryId;
                    }
                    if (null != (entryIdData = this.dataMap.get(key))) {
                        Map map = this.errorMap.computeIfAbsent(key, k -> new HashMap());
                        map.put("type", this.rule.getDataEntityType().getName());
                        map.put("field", this.rule.getDataEntityType().getName());
                        Set set = (Set)map.computeIfAbsent("rulelist", k -> new HashSet());
                        set.add(entryIdData);
                        set.add(this.rule.getString("name"));
                    }
                    this.dataMap.put(key, this.rule.getString("name"));
                    detailTotalAmount = detailTotalAmount.add(this.getAbsAmount(setting, entryName.equals("tdm_finance_main") ? amountField : selectField, dynamicObject));
                }
            }
        }
        detailDynamicObject.set("fetchamount", (Object)detailTotalAmount);
        String dataDirection = setting.getString("datadirection");
        BigDecimal amount = this.getAmount(this.taxRate, setting.getString("datatype"), detailTotalAmount, dataDirection);
        detailDynamicObject.set("amount", (Object)amount);
        detailDynamicObject.set("absolute", (Object)setting.getString("absolute"));
        list.add(detailDynamicObject);
        filterList.clear();
    }

    public String composeTaxPeriod(String startDate, String endDate) {
        String endMonth;
        String year = startDate.substring(0, 4);
        String startMonth = startDate.substring(5, 7);
        String taxPeriod = StringUtils.equals((String)startMonth, (String)(endMonth = endDate.substring(5, 7))) ? String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"AccountDetailTask_0", (String)"taxc-tcsd", (Object[])new Object[0]), year, startMonth) : String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s-%3$s\u6708", (String)"AccountDetailTask_1", (String)"taxc-tcsd", (Object[])new Object[0]), year, startMonth, endMonth);
        return taxPeriod;
    }

    public BigDecimal getAbsAmount(DynamicObject setting, String amountField, DynamicObject dynamicObject) {
        BigDecimal amount = Boolean.TRUE.equals(setting.getBoolean("absolute")) ? dynamicObject.getBigDecimal(amountField).abs() : dynamicObject.getBigDecimal(amountField);
        return amount;
    }

    private BigDecimal getAmount(String taxRate, String dataType, BigDecimal detailTotalamount, String datadirection) {
        BigDecimal amount = "positive".equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(this.reverse);
        if (StringUtils.isNotBlank((String)taxRate)) {
            BigDecimal rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(this.ONE_HUNDRED);
            if ("jsflqs".equals(dataType)) {
                amount = amount.divide(BigDecimal.ONE.add(rate), 2, RoundingMode.HALF_UP);
            } else if ("cysldsqs".equals(dataType)) {
                amount = amount.divide(rate, 2, RoundingMode.HALF_UP);
            }
            if ("sehshsj".equals(dataType)) {
                amount = amount.divide(rate, 2, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(rate));
            }
        }
        return amount;
    }
}

