/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.enums.DataType;

public class ValidateUtils {
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE = "rule";
    public static final String KEY_MSG = "msg";
    private static String[] FIELDS_SETTING = new String[]{"bizname", "table", "amountfield", "datatype", "absolute", "datadirection", "filtercondition"};

    private static String getErrorFormatAccounting() {
        return ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u7b2c%1$d\u884c\u548c%2$d\u884c\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"ValidateUtils_2", (String)"taxc-tcsd", (Object[])new Object[0]);
    }

    public static List<Map<String, Object>> validate(List<DynamicObject> currentRuleList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < currentRuleList.size(); ++i) {
            DynamicObject currentRule = currentRuleList.get(i);
            if (!currentRule.getBoolean("enable")) continue;
            result.addAll(ValidateUtils.checkVatrate(currentRule));
            result.addAll(ValidateUtils.checkInOneRule(currentRule));
        }
        return result;
    }

    private static List<Map<String, Object>> checkInOneRule(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            for (int j = i + 1; j < entryentity.size(); ++j) {
                DynamicObject a1 = (DynamicObject)entryentity.get(i);
                DynamicObject a2 = (DynamicObject)entryentity.get(j);
                ValidateUtils.compareAccounting(msgList, a1, a2, FIELDS_SETTING);
            }
        }
        return msgList;
    }

    private static void compareAccounting(List<Map<String, Object>> msgList, DynamicObject a1, DynamicObject a2, String[] filtersName) {
        boolean equals = true;
        for (String field : filtersName) {
            if (null == a1.get(field) || a1.get(field).equals(a2.get(field))) continue;
            equals = false;
            break;
        }
        if (equals) {
            String msg = String.format(ValidateUtils.getErrorFormatAccounting(), a1.get("seq"), a2.get("seq"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, "error");
            map.put(KEY_MSG, msg);
            msgList.add(map);
        }
    }

    public static List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject a1 = (DynamicObject)entryentity.get(i);
            String dataType = a1.getString("datatype");
            if (!dataType.equals(DataType.JSFLQS.getCode()) && !dataType.equals(DataType.CYSLDSQS.getCode()) || BigDecimal.ZERO.compareTo(a1.getBigDecimal("vatrate")) != 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, "error");
            map.put(KEY_RULE, (String)rule);
            map.put(KEY_MSG, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002", (String)"ValidateUtils_1", (String)"taxc-tcsd", (Object[])new Object[0]), i + 1));
            msgList.add(map);
        }
        return msgList;
    }
}

