/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.declare;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareShowPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String ORG = "org";
    private static final String PARA_ORG = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TABPAGEAP2 = "tabpageap2";
    private static final String TABPAGEAP3 = "tabpageap3";
    private static final String TABPAGEAP4 = "tabpageap4";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "tabpageap4"};

    public void registerListener(EventObject e) {
        this.addClickListeners(tab_keys);
    }

    private void setActiveTab(String tabKey) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        this.getView().updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                this.getView().updateControlMetadata(key, stylemap1);
            }
        });
        this.showTab(tabKey);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (Arrays.asList(tab_keys).contains(key)) {
            this.setActiveTab(key);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)this.getParam(PARA_ORG));
        this.getModel().setValue(SKSSQQ, (Object)DateUtils.stringToDate((String)this.getParam(SKSSQQ)));
        this.getModel().setValue(SKSSQZ, (Object)DateUtils.stringToDate((String)this.getParam(SKSSQZ)));
        this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
        this.getView().setEnable(Boolean.FALSE, new String[]{"daterange"});
        this.setActiveTab(TABPAGEAP1);
    }

    public void tabSelected(TabSelectEvent event) {
        this.showTab(event.getTabKey());
    }

    private void showTab(String tableKey) {
        String formId = "";
        HashMap<String, Object> customParams = this.getView().getFormShowParameter().getCustomParams();
        if (TABPAGEAP1.equals(tableKey)) {
            formId = "bdtaxr_declare_old";
        } else if (TABPAGEAP2.equals(tableKey)) {
            formId = "tcsd_taxdata_tab";
            customParams = new HashMap<String, Object>();
            customParams.put(PARA_ORG, this.getParam(PARA_ORG));
            String skssqq = this.getParam(SKSSQQ);
            customParams.put(SKSSQQ, skssqq);
            String skssqz = this.getParam(SKSSQZ);
            customParams.put(SKSSQZ, skssqz);
            customParams.put("status", "3");
            customParams.put("from", "history");
            customParams.put("readonly", Boolean.TRUE);
        } else if (TABPAGEAP3.equals(tableKey)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("tcsd_tax_policy");
            parameter.setBillStatus(BillOperationStatus.VIEW);
            QFilter q1 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQQ)));
            QFilter q2 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQZ)));
            QFilter q3 = new QFilter(PARA_ORG, "=", (Object)Long.parseLong(this.getParam(PARA_ORG)));
            DynamicObject policy = QueryServiceHelper.queryOne((String)"tcsd_tax_policy", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
            if (policy != null) {
                parameter.setPkId(policy.get("id"));
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.getOpenStyle().setTargetKey("flexcontent");
                customParams.put("readonly", Boolean.TRUE);
                parameter.setCustomParams(customParams);
                this.getView().showForm((FormShowParameter)parameter);
            }
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        }
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramtype = (String)customParams.get(param);
        return paramtype;
    }
}

