/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.declare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractDeclarePlugin;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcsd.business.engine.EngineUtils;
import kd.taxc.tcsd.business.service.DeclareService;
import kd.taxc.tcsd.business.service.StatusService;
import kd.taxc.tcsd.business.service.UpdateStatusService;

public class TcsdDeclarationPlugin
extends AbstractDeclarePlugin {
    private static Log logger = LogFactory.getLog(TcsdDeclarationPlugin.class);
    public static final String STR = "\uff0c";
    private static final String DECLARE_PAGE_ENTITY = "bdtaxr_declare_old";
    private static final String TEMPLATE_TYPE = "yhs";
    private static final String ORG_ID = "orgid";
    public static final String AQHZ = "aqhz";
    public static final String HDZS = "hdzs";
    private static final String TCSD_RULE_CONFIGS = "tcsd_rule_configs";

    public TcsdDeclarationPlugin() {
        super.setDeclarePageMap(TaxStepsConstant.getTcsd());
        super.setStatusService((IStatusService)new StatusService());
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "year", "halfyear", "season"};
    }

    public String getTemplateType() {
        return TEMPLATE_TYPE;
    }

    public String getDeclarePageEntity() {
        return DECLARE_PAGE_ENTITY;
    }

    public Map<String, Object> createCustomParams(String orgId, String startdate, String enddate, String status, String focuspage) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if ("3".equals(focuspage)) {
            customParams.put("templatetype", this.getTemplateType());
            customParams.put("ParentCache", "true");
            customParams.put("refresh", String.valueOf(!"3".equals(status)));
        }
        return customParams;
    }

    protected void beforeShowInnerTbPage(String focuspage, String orgId) {
        String billStatus = this.getPageCache().get("cache_billstatus");
        if ("2".equals(focuspage)) {
            if (billStatus.equals("A")) {
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                DeclareService.checkCardNoRule(orgId, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), (AbstractFormPlugin)this);
            }
        } else if ("3".equals(focuspage) && "A".equals(billStatus)) {
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            List<DynamicObject> collect = DeclareService.getValidCard(orgId, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
            Map<String, List<DynamicObject>> validCardMap = collect.stream().filter(a -> !"false".equals(a.getString("isverify"))).collect(Collectors.groupingBy(s -> s.getString("taxrate.number") + (s.getString("isverify").equals("false") ? AQHZ : HDZS)));
            if (validCardMap.size() > 0) {
                StringBuilder msg = new StringBuilder();
                for (List<DynamicObject> value : validCardMap.values()) {
                    if (value.size() <= 1) continue;
                    msg.append(value.get(0).getString("taxrate.name"));
                    msg.append(STR);
                }
                if (msg.length() > 0) {
                    StringBuilder delete = msg.delete(msg.length() - 1, msg.length());
                    delete.append(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u7684\"\u6838\u5b9a\u6bd4\u4f8b\"\u4e0d\u552f\u4e00\uff0c\u4f1a\u5f71\u54cd\u7533\u62a5\u8868\u6838\u5b9a\u6bd4\u4f8b\u7684\u53d6\u6570\u4ee5\u53ca\u76f8\u5173\u7a0e\u989d\u8ba1\u7b97\u7ed3\u679c\u3002\u60a8\u53ef\u901a\u8fc7\u7f16\u8f91\u7533\u62a5\u8868\u6216\u7a0e\u79cd\u5361\u7247\u8fdb\u884c\u4fee\u6539\u3002", (String)"TcsdDeclarationPlugin_3", (String)"taxc-tcsd", (Object[])new Object[0]));
                    this.getView().showMessage(delete.toString());
                }
            }
        }
    }

    public boolean checkBeforeNextStep(String orgId, String startdate, String enddate, String status, String focusPage) {
        logger.info("checkBeforeNextStep()\u3002\u53c2\u6570orgId\uff1a" + orgId + ",status\uff1a" + status + ",focusPage:" + focusPage);
        if ("1".equals(focusPage) && !"3".equals(status) && !"2".equals(status)) {
            String policypageid = this.getPageCache().get("declarepageid");
            DynamicObject dataEntity = this.getView().getView(policypageid).getModel().getDataEntity(true);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"tcsd_tax_policy", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u4e0d\u5168\u5bfc\u81f4\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u5230\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u76f8\u5173\u7a0e\u52a1\u4fe1\u606f", (String)"TcsdDeclarationPlugin_1", (String)"taxc-tcsd", (Object[])new Object[0]));
                return false;
            }
            EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
            String taxperiod = startdate.substring(0, 7);
            engineModel.addCustom("taxperiod", (Object)taxperiod);
            engineModel.addCustom("validcard", DeclareService.getValidCard(orgId, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate)));
            try (TXHandle h = TX.requiresNew();){
                try {
                    EngineUtils.execute(engineModel);
                    UpdateStatusService.updateStatus(orgId, startdate, enddate, "2");
                    DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTcsd().size(), (String)"2", (String)"2", (IFormView)this.getView());
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if ("checkNoRuleCard".equals(event.getActionId())) {
            if (map == null || map.isEmpty()) {
                return;
            }
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(ORG_ID, this.getPageCache().get(ORG_ID));
            customParams.put("ruletype", "private");
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)TCSD_RULE_CONFIGS, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }
}

