/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.policy;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.business.service.DeclareService;

public class TaxItemConfirmPlugin
extends AbstractFormPlugin {
    private static final String TAX_ITEM = "taxitem";
    private static final String ORG_ID = "orgid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String TAXATION = "taxation";
    private static final String HDZS = "hdzs";
    private static final String AQHZ = "aqhz";
    private static final String PAY_TAX_PERIOD = "paytaxperiod";
    private static final String ENTRY_ENTITY = "entryentity";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        String taxation = d.getString(TAXATION);
        if (columnDesc != null && taxation != null && taxation.equals(AQHZ) && "hdrate".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)"\u2014\u2014");
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = (String)customParams.get(ORG_ID);
        if (!StringUtils.isEmpty((Object)orgId)) {
            this.getModel().setValue(ORG_ID, (Object)orgId);
            this.getPageCache().put(ORG_ID, orgId);
            this.initStartEndDate(customParams);
            Date start = (Date)this.getModel().getValue(START_DATE);
            Date end = (Date)this.getModel().getValue(END_DATE);
            this.loadTaxItemData(orgId, start, end);
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("readonly") != null && ((Boolean)customParams.get("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG_ID, START_DATE, END_DATE, ENTRY_ENTITY});
        }
    }

    public void loadTaxItemData(String orgId, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return;
        }
        List<DynamicObject> collect = DeclareService.getValidCard(orgId, startDate, endDate);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, collect.size());
        int row = 0;
        for (DynamicObject dynamicObject : collect) {
            this.getModel().setValue(TAX_ITEM, (Object)dynamicObject.getString("taxrate.id"), row);
            this.getModel().setValue(TAXATION, (Object)(dynamicObject.getString("isverify").equals("false") ? AQHZ : HDZS), row);
            String period = dynamicObject.getString("period");
            this.getModel().setValue(PAY_TAX_PERIOD, (Object)period, row);
            this.getModel().setValue("hdrate", dynamicObject.get("hdrate"), row);
            this.getModel().setValue("effectivedate", dynamicObject.get("effectivedate"), row);
            this.getModel().setValue("expirydate", dynamicObject.get("expirydate"), row);
            ++row;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void initStartEndDate(Map<String, Object> customParams) {
        Date now = new Date();
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)now);
        Date startDate = DateUtils.addMonth((Date)skssqq, (int)-1);
        if (null != customParams.get("skssqq")) {
            startDate = DateUtils.stringToDate((String)customParams.get("skssqq").toString(), (String)"yyyy-MM-dd");
        }
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        if (null != customParams.get("skssqz")) {
            endDate = DateUtils.stringToDate((String)customParams.get("skssqz").toString(), (String)"yyyy-MM-dd");
        }
        this.getModel().setValue(START_DATE, (Object)startDate);
        this.getModel().setValue(END_DATE, (Object)DateUtils.format((Date)endDate));
    }
}

