/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.rule;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.formplugin.rule.AbstractRulePlugin;

public class CqzysjRulePlugin
extends AbstractRulePlugin
implements BeforeF7SelectListener {
    public static final String TCSD_RULE_CQZYSJ = "tcsd_rule_cqzysj";
    private static final String RULE_TYPE_CODE = "RULE-CSD-DOC-0001";

    public void afterCreateNewData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L && TCSD_RULE_CQZYSJ.equals(this.getModel().getDataEntityType().getName()) && !this.setTaxation(null)) {
            this.getModel().setValue("taxation", (Object)"aqhz");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem");
        if (taxitem != null) {
            BasedataEdit subtaxitem = (BasedataEdit)this.getControl("subtaxitem");
            subtaxitem.setMustInput("02001".equals(taxitem.getString("number")));
        }
    }

    private boolean setTaxation(Long itemId) {
        Object org = this.getModel().getValue("org");
        Object taxitem = this.getModel().getValue("taxitem");
        if (org != null && taxitem != null) {
            TaxResult taxResult;
            Date now = new Date();
            Long id = ((DynamicObject)org).getLong("id");
            if (itemId == null) {
                itemId = ((DynamicObject)taxitem).getLong("id");
            }
            if ((taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(id))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                String finalItemId = itemId.toString();
                Optional<DynamicObject> present = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity").stream().filter(d -> d.getString("taxrate.id").equals(finalItemId)).filter(d -> d.getDate("effectivedate").compareTo(now) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(now) >= 0).findFirst();
                if (present.isPresent() && present.get().getBoolean("isverify")) {
                    this.getModel().setValue("taxation", (Object)"hdzs");
                    return true;
                }
            }
        }
        return false;
    }

    public void registerListener(EventObject e) {
        BasedataEdit taxitem = (BasedataEdit)this.getControl("taxitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subtaxitem = (BasedataEdit)this.getControl("subtaxitem");
        subtaxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        Boolean suitable;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("taxation".equals(name)) {
            this.getModel().deleteEntryData("entryentity");
        }
        if ("suitable".equals(name) && !(suitable = (Boolean)(changeSet = e.getChangeSet())[0].getNewValue()).booleanValue()) {
            this.getModel().setValue("deductioncode", null);
        }
        if ("taxitem".equals(name)) {
            changeSet = e.getChangeSet();
            if (changeSet[0].getNewValue() != null) {
                DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
                if (!this.setTaxation(newValue.getLong("id"))) {
                    this.getModel().setValue("taxation", (Object)"aqhz");
                }
                String number = newValue.getString("number");
                BasedataEdit subtaxitemEdit = (BasedataEdit)this.getControl("subtaxitem");
                subtaxitemEdit.setMustInput("02001".equals(number));
                DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue("subtaxitem");
                if (subtaxitem != null && !StringUtils.equals((CharSequence)subtaxitem.getString("parent.number"), (CharSequence)number)) {
                    this.getModel().setValue("subtaxitem", null);
                }
            } else {
                this.getModel().setValue("subtaxitem", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "taxitem": {
                this.taxitemBeforeF7(evt);
                break;
            }
            case "table": {
                this.tableBeforeF7(evt);
                break;
            }
            case "subtaxitem": {
                this.subtaxitemBeforeF7(evt);
                break;
            }
        }
    }

    private void subtaxitemBeforeF7(BeforeF7SelectEvent evt) {
        DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem");
        if (taxitem == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u76ee", (String)"CqzysjRulePlugin_1", (String)"taxc-tcsd", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("parent.number", "=", (Object)taxitem.getString("number")));
    }

    private void tableBeforeF7(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            formShowParameter.setUseOrgId(org.getLong("id"));
        }
        QFilter filter = new QFilter("basedataid.billno", "=", (Object)RULE_TYPE_CODE);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
    }

    private void taxitemBeforeF7(BeforeF7SelectEvent evt) {
        Date now = new Date();
        QFilter q1 = new QFilter("startdate", "<=", (Object)now);
        QFilter q2 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)now));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1, q2});
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u7a0e\u76ee\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"CqzysjRulePlugin_0", (String)"taxc-tcsd", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        Date date = DateUtils.stringToDate((String)"2022-08-01");
        listFilterParameter.setFilter(new QFilter("longnumber", "like", (Object)"1.02.%").or(new QFilter("longnumber", "like", (Object)"2.05.%")));
        QFilter treeFilter = new QFilter("number", "=", (Object)"1").or(new QFilter("number", "=", (Object)"2")).or(new QFilter("number", "=", (Object)"02")).or(new QFilter("number", "=", (Object)"05"));
        if (now.compareTo(date) >= 0) {
            listFilterParameter.setFilter(new QFilter("taxrange", "=", (Object)object.getLong("id")));
            treeFilter.and(new QFilter("taxrange", "=", (Object)object.getLong("id")));
        }
        List<QFilter> treeFilters = Collections.singletonList(treeFilter);
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(treeFilters);
    }
}

