/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.rule;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;

public class RuleConfigsPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    public static final String RULETYPE = "ruletype";
    private static Log logger = LogFactory.getLog(RuleConfigsPlugin.class);
    private static String TREE_ORG = "treeviewap";
    private static final String ENTITY_YSHTPZ = "tcsd_rule_yshtpz";
    private static final String ENTITY_CQZYSJ = "tcsd_rule_cqzysj";
    private static final String ENTITY_ZJZB = "tcsd_rule_zjzb";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TEMP_NODE = "CURRENT_TEMP_NODE";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String RULE_TYPE_YSHTPZ = "yshtpz";
    private static final String RULE_TYPE_CQZYSJ = "cqzysj";
    private static final String RULE_TYPE_ZJZB = "zjzb";
    private Set<String> yshtpzKeys = new HashSet<String>(Arrays.asList("yshtruleadd", "yshtruleup", "yshtruledown", "yshtrulelabel", "cardflexpanelap1", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap5", "cardflexpanelap6", "cardflexpanelap7", "yshtpz_image", "labelap_modifydate", "labelap_jzjt", "labelap_taxrate", "labelap_enable", "labelap_disable"));
    private Set<String> cqzysjKeys = new HashSet<String>(Arrays.asList("cqzysjruleadd", "cqzysjruleup", "cqzysjruledown", "cqzysjrulelabel", "cardflexpanelap11", "cardflexpanelap21", "cardflexpanelap31", "cardflexpanelap41", "cardflexpanelap51", "cardflexpanelap61", "cardflexpanelap71", "cqzysj_image", "labelap_modifydate1", "labelap_jzjt1", "labelap_cqzysjtype", "labelap_enable1", "labelap_disable1"));
    private Set<String> zjzbKeys = new HashSet<String>(Arrays.asList("zjzbruleadd", "zjzbruleup", "zjzbruledown", "zjzbrulelabel", "cardflexpanelap12", "cardflexpanelap22", "cardflexpanelap32", "cardflexpanelap42", "cardflexpanelap52", "cardflexpanelap62", "cardflexpanelap72", "zjzb_image", "labelap_modifydate2", "labelap_jzjt2", "labelap_zjzbtype", "labelap_enable2", "labelap_disable2"));

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addClickListeners(this.yshtpzKeys.toArray(new String[0]));
        this.addClickListeners(this.cqzysjKeys.toArray(new String[0]));
        this.addClickListeners(this.zjzbKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleConfigsPlugin_8", (String)"taxc-tcsd", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleConfigsPlugin_8", (String)"taxc-tcsd", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void afterCreateNewData(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        this.getPageCache().put(CURRENT_TAB, "yshtpzruletab");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put(RULETYPE, (String)customParams.get(RULETYPE));
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
        Date endDate = DateUtils.stringToDate((String)"2022-08-01 00:00:00");
        if (endDate.after(new Date())) {
            String tip = ResManager.loadKDString((String)"\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5370\u82b1\u7a0e\u6cd5\u300b\uff08\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4e3b\u5e2d\u4ee4\u7b2c89\u53f7\uff09\u4e8e2022\u5e747\u67081\u65e5\u8d77\u65bd\u884c\uff0c\u8bf7\u6ce8\u610f\u66f4\u65b0\u5370\u82b1\u7a0e\u7a0e\u76ee\u3002", (String)"RuleConfigsPlugin_10", (String)"taxc-tcsd", (Object[])new Object[0]);
            this.getView().showTipNotification(tip, Integer.valueOf(20000));
        }
    }

    private void loadyshtpzrule(String ruleType) {
        this.getModel().deleteEntryData("yshtpzentity");
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
        QFilter ruleTypeFilter = new QFilter(RULETYPE, "=", (Object)ruleType);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_YSHTPZ, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,taxitem.name as taxname,taxitem.taxrate as taxrate,taxation,subtaxitem.projectname as subtaxitem", (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"ruletype desc");
        Map taxationMap = MetadataUtil.getComboItemsMap((String)ENTITY_YSHTPZ, (String)"taxation");
        this.getModel().beginInit();
        for (DynamicObject rule : rules) {
            int row = this.getModel().createNewEntryRow("yshtpzentity");
            this.getModel().setValue("yshtpzid", rule.get("id"), row);
            this.getModel().setValue("yshtpzrulename", (Object)rule.getString("name"), row);
            this.getModel().setValue("yshtpzmodifydate", rule.get("modifytime"), row);
            this.getModel().setValue("yshtpzenable", rule.get("enable"), row);
            this.getModel().setValue("ruletaxation", taxationMap.get(rule.get("taxation")), row);
            String ruletype = rule.getString(RULETYPE);
            this.getModel().setValue("yshtpzruletype", (Object)ruletype, row);
            this.getModel().setValue("taxname", rule.get("taxname"), row);
            this.getModel().setValue("subtaxname", rule.get("subtaxitem"), row);
            this.getModel().setValue("taxrate", rule.get("taxrate"), row);
            this.setBackgroundAndImage(row, RULE_TYPE_YSHTPZ, ruletype);
        }
        this.getModel().endInit();
        this.getView().updateView("yshtpzentity");
    }

    private void loadcqzysjrule(String ruleType) {
        this.getModel().deleteEntryData("cqzysjentity");
        String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,taxitem.name as taxname,taxitem.taxrate as taxrate,taxation,subtaxitem.projectname as subtaxitem";
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
        QFilter ruleTypeFilter = new QFilter(RULETYPE, "=", (Object)ruleType);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_CQZYSJ, (String)fields, (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"ruletype desc");
        Map taxationMap = MetadataUtil.getComboItemsMap((String)ENTITY_YSHTPZ, (String)"taxation");
        this.getModel().beginInit();
        for (DynamicObject rule : rules) {
            int row = this.getModel().createNewEntryRow("cqzysjentity");
            this.getModel().setValue("cqzysjid", rule.get("id"), row);
            this.getModel().setValue("cqzysjrulename", (Object)rule.getString("name"), row);
            this.getModel().setValue("cqzysjmodifydate", rule.get("modifytime"), row);
            String ruletype = rule.getString(RULETYPE);
            this.getModel().setValue("cqzysjruletype", (Object)ruletype, row);
            this.getModel().setValue("cqzysjenable", (Object)rule.getString("enable"), row);
            this.getModel().setValue("cqzysjtaxname", rule.get("taxname"), row);
            this.getModel().setValue("cqzysjsubtaxname", rule.get("subtaxitem"), row);
            this.getModel().setValue("cqzysjtaxrate", rule.get("taxrate"), row);
            this.getModel().setValue("cqzysjtaxation", taxationMap.get(rule.get("taxation")), row);
            this.setBackgroundAndImage(row, RULE_TYPE_CQZYSJ, ruletype);
        }
        this.getModel().endInit();
        this.getView().updateView("cqzysjentity");
    }

    private void loadzjzbrule(String ruleType) {
        this.getModel().deleteEntryData("zjzbentity");
        String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,taxitem.name as taxname,taxitem.taxrate as taxrate,taxation";
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
        QFilter ruleTypeFilter = new QFilter(RULETYPE, "=", (Object)ruleType);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_ZJZB, (String)fields, (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"ruletype desc");
        Map taxationMap = MetadataUtil.getComboItemsMap((String)ENTITY_YSHTPZ, (String)"taxation");
        this.getModel().beginInit();
        for (DynamicObject rule : rules) {
            int row = this.getModel().createNewEntryRow("zjzbentity");
            this.getModel().setValue("zjzbid", rule.get("id"), row);
            this.getModel().setValue("zjzbrulename", (Object)rule.getString("name"), row);
            this.getModel().setValue("zjzbmodifydate", rule.get("modifytime"), row);
            String ruletype = rule.getString(RULETYPE);
            this.getModel().setValue("zjzbruletype", (Object)ruletype, row);
            this.getModel().setValue("zjzbenable", (Object)rule.getString("enable"), row);
            this.getModel().setValue("zjzbtaxname", rule.get("taxname"), row);
            this.getModel().setValue("zjzbtaxrate", rule.get("taxrate"), row);
            this.getModel().setValue("zjzbtaxation", taxationMap.get(rule.get("taxation")), row);
            this.setBackgroundAndImage(row, RULE_TYPE_ZJZB, ruletype);
        }
        this.getModel().endInit();
        this.getView().updateView("zjzbentity");
    }

    private void setBackgroundAndImage(int row, String type, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_86_86.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_86_86.png");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = cache.get(CURRENT_NODE);
        if (orgid == null || StringUtils.isEmpty((CharSequence)String.valueOf(orgid))) {
            orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        }
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "2".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE)))) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            org = null;
        }
        if (org != null && "1".equals(org.getString("enable"))) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.yshtpzKeys.contains(key)) {
            Object pkid;
            EntryGrid yshtpzentity = (EntryGrid)this.getControl("yshtpzentity");
            int[] selectRows = yshtpzentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("yshtpzid", selectRows[0]) : null;
            if (key.contains("ysht")) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_YSHTPZ, pkid, RULE_TYPE_YSHTPZ);
        } else if (this.cqzysjKeys.contains(key)) {
            Object pkid;
            EntryGrid cqzysjentity = (EntryGrid)this.getControl("cqzysjentity");
            int[] selectRows = cqzysjentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("cqzysjid", selectRows[0]) : null;
            if (key.contains(RULE_TYPE_CQZYSJ)) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_CQZYSJ, pkid, RULE_TYPE_CQZYSJ);
        } else if (this.zjzbKeys.contains(key)) {
            Object pkid;
            EntryGrid zjzbentity = (EntryGrid)this.getControl("zjzbentity");
            int[] selectRows = zjzbentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("zjzbid", selectRows[0]) : null;
            if (key.contains(RULE_TYPE_ZJZB)) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_ZJZB, pkid, RULE_TYPE_ZJZB);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IPageCache cache = this.getPageCache();
        this.checkNode(treeView, cache);
    }

    private void openRuleForm(String formId, Object pkid, String ruletype) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get(CURRENT_TEMP_NODE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RuleConfigsPlugin_4", (String)"taxc-tcsd", (Object[])new Object[0]));
                return;
            }
            String nodeId = this.getPageCache().get(CURRENT_TEMP_NODE);
            TreeView treeView = (TreeView)this.getControl(TREE_ORG);
            TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
            boolean check = this.checkOrg(nodeId);
            if (check) {
                return;
            }
        } else {
            boolean check = this.checkOrg(orgId);
            if (check) {
                return;
            }
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", orgId);
        customParams.put(RULETYPE, this.getPageCache().get(RULETYPE));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        boolean check;
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        if (nodeId.equals(current)) {
            current = null;
        }
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        String categoryType = "yhs";
        if ("public".equals(this.getPageCache().get(RULETYPE))) {
            categoryType = null;
        }
        if (check = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)nodeId, (String)"tcsd", (String)categoryType)) {
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)nodeId) && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(nodeId)).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u9009\u3002", (String)"RuleConfigsPlugin_9", (String)"taxc-tcsd", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        pageCache.remove(CURRENT_TEMP_NODE);
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        if (null != tab) {
            if ("yshtpzruletab".equals(tab)) {
                this.loadyshtpzrule(this.getPageCache().get(RULETYPE));
            } else if ("cqzysjruletab".equals(tab)) {
                this.loadcqzysjrule(this.getPageCache().get(RULETYPE));
            } else if ("zjzbruletab".equals(tab)) {
                this.loadzjzbrule(this.getPageCache().get(RULETYPE));
            }
        } else {
            this.loadyshtpzrule(this.getPageCache().get(RULETYPE));
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
        if ("yshtpzruletab".equals(tabKey)) {
            this.loadyshtpzrule(this.getPageCache().get(RULETYPE));
        } else if ("cqzysjruletab".equals(tabKey)) {
            this.loadcqzysjrule(this.getPageCache().get(RULETYPE));
        } else if ("zjzbruletab".equals(tabKey)) {
            this.loadzjzbrule(this.getPageCache().get(RULETYPE));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        String eventName = e.getEventName();
        if ("addNewRule".equals(eventName)) {
            if (LicenseCheckServiceHelper.check((Object)this.getPageCache().get(CURRENT_NODE), (IFormView)this.getView(), (String)"tcsd")) {
                return;
            }
            if ("public".equals(argsMap.get(RULETYPE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u65b0\u589e\u53ef\u5206\u914d\u89c4\u5219", (String)"RuleConfigsPlugin_7", (String)"taxc-tcsd", (Object[])new Object[0]));
                return;
            }
            String formId = ENTITY_YSHTPZ;
            Tab tabap = (Tab)this.getControl("tabap");
            if (tabap != null) {
                String currentTab = tabap.getCurrentTab();
                formId = "yshtpzruletab".equals(currentTab) ? ENTITY_YSHTPZ : ("cqzysjruletab".equals(currentTab) ? ENTITY_CQZYSJ : ENTITY_ZJZB);
            }
            this.openRuleForm(formId, null, (String)argsMap.get(RULETYPE));
        }
    }

    private boolean checkOrg(String orgId) {
        String categoryType = "yhs";
        if ("public".equals(this.getPageCache().get(RULETYPE))) {
            categoryType = null;
        }
        if (OrgCheckUtil.checkTaxcMainEnable((IFormView)this.getView(), (String)orgId, (boolean)true)) {
            return true;
        }
        return OrgCheckUtil.check((IFormView)this.getView(), (String)orgId, (String)"tcsd", (String)categoryType);
    }
}

