/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.formplugin.rule.AbstractRulePlugin;

public class YshtRulePlugin
extends AbstractRulePlugin
implements BeforeF7SelectListener {
    private static final String DEFAULT_RULE_CODE = "RULE-CSD-CON-0000";
    private static Map<String, String> map = new HashMap<String, String>();

    private boolean setTaxation(Long itemId) {
        Object org = this.getModel().getValue("org");
        Object taxitem = this.getModel().getValue("taxitem");
        if (org != null && taxitem != null) {
            TaxResult taxResult;
            Date now = new Date();
            Long id = ((DynamicObject)org).getLong("id");
            if (itemId == null) {
                itemId = ((DynamicObject)taxitem).getLong("id");
            }
            if ((taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(id))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                String finalItemId = itemId.toString();
                Optional<DynamicObject> present = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity").stream().filter(d -> d.getString("taxrate.id").equals(finalItemId)).filter(d -> d.getDate("effectivedate").compareTo(now) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(now) >= 0).findFirst();
                if (present.isPresent() && present.get().getBoolean("isverify")) {
                    this.getModel().setValue("taxation", (Object)"hdzs");
                    return true;
                }
            }
        }
        return false;
    }

    public void registerListener(EventObject e) {
        BasedataEdit taxitem = (BasedataEdit)this.getControl("taxitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subtaxitem = (BasedataEdit)this.getControl("subtaxitem");
        subtaxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem");
        if (taxitem != null) {
            BasedataEdit subtaxitem = (BasedataEdit)this.getControl("subtaxitem");
            subtaxitem.setMustInput("02001".equals(taxitem.getString("number")));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String newObject;
        Boolean suitable;
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("taxation".equals(name)) {
            this.getModel().deleteEntryData("entryentity");
        }
        if ("taxitem".equals(name)) {
            changeSet = e.getChangeSet();
            if (changeSet[0].getNewValue() != null) {
                DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
                if (!this.setTaxation(newValue.getLong("id"))) {
                    this.getModel().setValue("taxation", (Object)"aqhz");
                }
                String number = newValue.getString("number");
                BasedataEdit subtaxitemEdit = (BasedataEdit)this.getControl("subtaxitem");
                subtaxitemEdit.setMustInput("02001".equals(number));
                DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue("subtaxitem");
                if (subtaxitem != null && !StringUtils.equals((CharSequence)subtaxitem.getString("parent.number"), (CharSequence)number)) {
                    this.getModel().setValue("subtaxitem", null);
                }
            } else {
                this.getModel().setValue("subtaxitem", null);
            }
        }
        if ("suitable".equals(name) && !(suitable = (Boolean)(changeSet = e.getChangeSet())[0].getNewValue()).booleanValue()) {
            this.getModel().setValue("deductioncode", null);
        }
        if ("table".equals(name)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject table = (DynamicObject)this.getModel().getValue("table", index);
            List<String> list = Arrays.asList("rim_inv_electric", "rim_inv_motor", "rim_inv_special");
            if (null != table && list.contains(table.getString("entityname"))) {
                this.getModel().setValue("datatype", (Object)"zjqs", index);
            }
        }
        if ("datatype".equals(name) && !"zjqs".equals(newObject = (String)e.getChangeSet()[0].getNewValue())) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject table = (DynamicObject)this.getModel().getValue("table", index);
            List<String> list = Arrays.asList("rim_inv_electric", "rim_inv_motor", "rim_inv_special");
            if (null != table && list.contains(table.getString("entityname"))) {
                this.getModel().setValue("datatype", (Object)"zjqs", index);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u6e90\u7684\u53d6\u6570\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u76f4\u63a5\u53d6\u6570", (String)"YshtRulePlugin_2", (String)"taxc-tcsd", (Object[])new Object[0]), table.get("bizname")));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "taxitem": {
                this.taxitemBeforeF7(evt);
                break;
            }
            case "table": {
                this.tableBeforeF7(evt);
                break;
            }
            case "subtaxitem": {
                this.subtaxitemBeforeF7(evt);
                break;
            }
        }
    }

    private void subtaxitemBeforeF7(BeforeF7SelectEvent evt) {
        DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem");
        if (taxitem == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u76ee", (String)"YshtRulePlugin_1", (String)"taxc-tcsd", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("parent.number", "=", (Object)taxitem.getString("number")));
    }

    private void tableBeforeF7(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            formShowParameter.setUseOrgId(org.getLong("id"));
        }
        String number = null;
        DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem");
        if (taxitem != null) {
            number = taxitem.getString("number");
        }
        String ruleCode = map.getOrDefault(number, DEFAULT_RULE_CODE);
        QFilter filter = new QFilter("basedataid.billno", "in", Arrays.asList(ruleCode, DEFAULT_RULE_CODE));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
    }

    private void taxitemBeforeF7(BeforeF7SelectEvent evt) {
        Date now = new Date();
        QFilter q1 = new QFilter("startdate", "<=", (Object)now);
        QFilter q2 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)now));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1, q2});
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u7a0e\u76ee\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"YshtRulePlugin_3", (String)"taxc-tcsd", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        Date date = DateUtils.stringToDate((String)"2022-08-01");
        listFilterParameter.setFilter(new QFilter("longnumber", "like", (Object)"1.01.%").or(new QFilter("longnumber", "like", (Object)"2.04.%")));
        QFilter treeFilter = new QFilter("number", "=", (Object)"1").or(new QFilter("number", "=", (Object)"2")).or(new QFilter("number", "=", (Object)"01")).or(new QFilter("number", "=", (Object)"04"));
        if (now.compareTo(date) >= 0) {
            listFilterParameter.setFilter(new QFilter("taxrange", "=", (Object)object.getLong("id")));
            treeFilter.and(new QFilter("taxrange", "=", (Object)object.getLong("id")));
        }
        List<QFilter> treeFilters = Collections.singletonList(treeFilter);
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(treeFilters);
    }

    static {
        map.put("001", "RULE-CSD-CON-0001");
        map.put("002", "RULE-CSD-CON-0002");
        map.put("003", "RULE-CSD-CON-0003");
        map.put("004", "RULE-CSD-CON-0004");
        map.put("005", "RULE-CSD-CON-0005");
        map.put("006", "RULE-CSD-CON-0006");
        map.put("007", "RULE-CSD-CON-0007");
        map.put("008", "RULE-CSD-CON-0008");
        map.put("009", "RULE-CSD-CON-0009");
        map.put("010", "RULE-CSD-CON-0010");
    }
}

