/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.formplugin.rule;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcsd.formplugin.rule.AbstractRulePlugin;

public class ZjzbRulePlugin
extends AbstractRulePlugin
implements BeforeF7SelectListener {
    private static final String RULE_TYPE_CODE = "RULE-CSD-BK-0000";

    public void registerListener(EventObject e) {
        BasedataEdit taxitem = (BasedataEdit)this.getControl("taxitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        Boolean suitable;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("suitable".equals(name) && !(suitable = (Boolean)(changeSet = e.getChangeSet())[0].getNewValue()).booleanValue()) {
            this.getModel().setValue("deductioncode", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "taxitem": {
                this.taxitemBeforeF7(evt);
                break;
            }
            case "table": {
                this.tableBeforeF7(evt);
                break;
            }
        }
    }

    private void tableBeforeF7(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            formShowParameter.setUseOrgId(org.getLong("id"));
        }
        QFilter filter = new QFilter("basedataid.billno", "=", (Object)RULE_TYPE_CODE);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
    }

    private void taxitemBeforeF7(BeforeF7SelectEvent evt) {
        Date now = new Date();
        QFilter q1 = new QFilter("startdate", "<=", (Object)now);
        QFilter q2 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)now));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1, q2});
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u7a0e\u76ee\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"ZjzbRulePlugin_0", (String)"taxc-tcsd", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date date = DateUtils.stringToDate((String)"2022-08-01");
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("longnumber", "like", (Object)"1.03.%").or(new QFilter("longnumber", "like", (Object)"2.06.%")));
        QFilter treeFilter = new QFilter("number", "=", (Object)"1").or(new QFilter("number", "=", (Object)"2")).or(new QFilter("number", "=", (Object)"03")).or(new QFilter("number", "=", (Object)"06"));
        if (now.compareTo(date) >= 0) {
            listFilterParameter.setFilter(new QFilter("taxrange", "=", (Object)object.getLong("id")));
            treeFilter.and(new QFilter("taxrange", "=", (Object)object.getLong("id")));
        }
        List<QFilter> treeFilters = Collections.singletonList(treeFilter);
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(treeFilters);
    }
}

