/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcsd.opplugin.rule;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcsd.common.util.ValidateUtils;

public class RuleSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject rule = dataEntity.getDataEntity();
            DynamicObject org = rule.getDynamicObject("org");
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleSaveValidator_0", (String)"taxc-tcsd", (Object[])new Object[0]));
                continue;
            }
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String rulepurpose = dynamicObject.getString("rulepurpose");
            if (rulepurpose.contains("nssb")) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    if (entry == null || entry.getDynamicObject("table") == null || !"tcret_yhs_tax_source_info".equalsIgnoreCase(entry.getDynamicObject("table").getString("entityname"))) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u6e90\u4fe1\u606f\u6570\u636e\u6e90\u89c4\u5219\u7528\u9014\u4ec5\u9650\u4e8e\u6309\u6b21\u7533\u62a5\u7a0e\u6e90\u6570\u636e\u7684\u7a0e\u91d1\u8ba1\u63d0\u3002", (String)"RuleSaveValidator_1", (String)"taxc-tcsd", (Object[])new Object[0]));
                    break;
                }
            }
            if (rulepurpose.contains("sjjt") && EmptyCheckUtils.isEmpty((Object)dynamicObject.getString("declaretype"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"[\u7533\u62a5\u671f\u9650\u7c7b\u578b]\u672a\u586b\u5199\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574", (String)"RuleSaveValidator_2", (String)"taxc-tcsd", (Object[])new Object[0]));
                continue;
            }
            if (!rule.getBoolean("enable")) continue;
            this.validate(dataEntity, rule);
        }
    }

    private void validate(ExtendedDataEntity dataEntity, DynamicObject rule) {
        List<Map<String, Object>> errorList = ValidateUtils.validate(Collections.singletonList(rule));
        for (Map<String, Object> map : errorList) {
            this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
        }
    }
}

