/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.element.ElementSqlService;
import kd.taxc.tctb.common.element.TimeDeviatedEnum;
import kd.taxc.tctb.common.element.bean.EleTreeInfo;
import kd.taxc.tctb.common.element.util.EleTreeUtil;
import kd.taxc.tctb.common.element.util.ElementUtil;
import kd.taxc.tctb.common.util.CalUtils;

public class AutoUpateElementService {
    private static Log logger = LogFactory.getLog(AutoUpateElementService.class);

    public static void updateElemntResult(Map<String, DynamicObject> eleCode2InfoMap, Map<String, String> value, String type) {
        logger.info("\u7ec4\u7ec7\u76f8\u5173\u6570\u6240\u8ba1\u7b97\u5f00\u59cb type = " + type);
        QFilter qFilter = new QFilter("type", "=", (Object)type);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,name,subname", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty((Object)doc)) {
            logger.info("tctb_custom_datasource is null by type = " + type);
        }
        List<EleTreeInfo> eleTreeInfos = EleTreeUtil.createEleTree(eleCode2InfoMap);
        HashMap<String, List<String>> orgAndPeriodMap = new HashMap<String, List<String>>(16);
        ArrayList<String> vlist = new ArrayList<String>(20);
        vlist.add(value.get("startDate") + "," + value.get("endDate"));
        orgAndPeriodMap.put(value.get("orgid"), vlist);
        ElementSqlService elementSqlService = new ElementSqlService();
        for (DynamicObject d : doc) {
            logger.info(String.format("%s-%s \u5f00\u59cb\u8ba1\u7b97 \u5f00\u59cb\u65f6\u95f4%s \u7ed3\u675f\u65f6\u95f4 %s ", d.getString("name"), d.getString("subname"), value.get("startDate"), value.get("endDate")));
            String tableId = d.getString("id");
            List<String> autoEleNumber = AutoUpateElementService.getElementByTableId(eleCode2InfoMap, tableId);
            if (null == orgAndPeriodMap || null == autoEleNumber || 0 >= autoEleNumber.size()) continue;
            logger.info("\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97\u5143\u7d20codes=" + autoEleNumber.stream().collect(Collectors.joining(",")));
            Map<String, List<String>> deviatedTime2EleCodeListMap = AutoUpateElementService.getDeviatedTime2EleCodeListMap(eleCode2InfoMap, orgAndPeriodMap, autoEleNumber);
            logger.info("deviatedTime2EleCodeListMapSize=" + deviatedTime2EleCodeListMap.size());
            for (Map.Entry<String, List<String>> entry : deviatedTime2EleCodeListMap.entrySet()) {
                HashMap<String, List<String>> orgAndPeriodMap2 = new HashMap<String, List<String>>(32);
                for (Map.Entry listEntry : orgAndPeriodMap.entrySet()) {
                    ArrayList<String> vlist2 = new ArrayList<String>();
                    String[] split = entry.getKey().split(";");
                    vlist2.add(split[0] + "," + split[1]);
                    orgAndPeriodMap2.put((String)listEntry.getKey(), (List<String>)vlist2);
                }
                autoEleNumber = EleTreeUtil.findNestTopEleCodesByBottoms(eleTreeInfos, entry.getValue());
                logger.info("\u5c5e\u671f\u4e3a" + entry.getKey() + ";\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97\u5143\u7d20\u5305\u542b\u9876\u5c42codes=" + autoEleNumber.stream().collect(Collectors.joining(",")));
                try {
                    elementSqlService.batchCalElements(eleCode2InfoMap, orgAndPeriodMap2, autoEleNumber);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        logger.info("\u7ec4\u7ec7\u76f8\u5173\u6570\u636e\u8ba1\u7b97\u7ed3\u675f type = " + type);
    }

    private static Map<String, List<String>> getDeviatedTime2EleCodeListMap(Map<String, DynamicObject> eleCode2InfoMap, Map<String, List<String>> orgAndPeriodMap, List<String> autoEleNumberList) {
        String startDateStr = null;
        String endDateStr = null;
        for (Map.Entry<String, List<String>> entry : orgAndPeriodMap.entrySet()) {
            List<String> periods = entry.getValue();
            for (String period : periods) {
                startDateStr = period.split(",")[0];
                endDateStr = period.split(",")[1];
            }
        }
        HashMap<String, List<String>> deviatedTime2EleCodeListMap = new HashMap<String, List<String>>(256);
        HashSet<String> keys = new HashSet<String>(16);
        for (String string : autoEleNumberList) {
            DynamicObject ele = eleCode2InfoMap.get(string);
            if (EmptyCheckUtils.isEmpty((Object)ele) || !ele.getBoolean("bottom")) continue;
            if (ele.getInt("timedeviationcount") == 0) {
                keys.add(startDateStr + ";" + endDateStr);
            } else {
                int timeDeviationCount = ele.getInt("timedeviationcount");
                String calType = ele.getString("timedeviationtype");
                Date startDate = DateUtils.stringToDate((String)startDateStr);
                Date endDate = DateUtils.stringToDate((String)endDateStr);
                int monthDiff = DateUtils.getMonthDiff((Date)endDate, (Date)startDate);
                String deviatedStartDate = TimeDeviatedEnum.getDeviatedDateByMonth(startDateStr, timeDeviationCount, "");
                Date date = DateUtils.addMonth((Date)DateUtils.stringToDate((String)deviatedStartDate), (int)monthDiff);
                String deviatedEndDate = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)date));
                List<Map<String, Date>> calDate = CalUtils.getCalDate(calType, DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)deviatedStartDate)), DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)deviatedEndDate)));
                keys.addAll(calDate.stream().map(v -> DateUtils.format((Date)((Date)v.get("startdate"))) + ";" + DateUtils.format((Date)((Date)v.get("enddate")))).collect(Collectors.toList()));
            }
            for (String key : keys) {
                List deviatedEleCodes = (List)deviatedTime2EleCodeListMap.get(key);
                deviatedEleCodes = EmptyCheckUtils.isEmpty((Object)deviatedEleCodes) ? new ArrayList(128) : deviatedEleCodes;
                deviatedEleCodes.add(ele.getString("number"));
                deviatedTime2EleCodeListMap.put(key, deviatedEleCodes);
            }
        }
        for (Map.Entry entry : deviatedTime2EleCodeListMap.entrySet()) {
            logger.info((String)entry.getKey() + ((List)entry.getValue()).stream().collect(Collectors.joining(";")));
        }
        return deviatedTime2EleCodeListMap;
    }

    public static List<String> getElementByTableId(Map<String, DynamicObject> eleCode2InfoMap, String tableId) {
        ArrayList<String> autoEleNumberList = new ArrayList<String>();
        for (DynamicObject element : eleCode2InfoMap.values()) {
            String json_tag;
            if (!element.getBoolean("autorefresh") || !element.getBoolean("bottom") || null == (json_tag = element.getString("json_tag")) || json_tag.isEmpty() || !AutoUpateElementService.isExist(json_tag, tableId)) continue;
            autoEleNumberList.add(element.getString("number"));
        }
        return autoEleNumberList;
    }

    private static boolean isExist(String json_tag, String tableId) {
        List<Map<String, String>> list = ElementUtil.parseJson(json_tag);
        for (Map<String, String> ruleMap : list) {
            List<Map<String, String>> dataSourceMapList = ElementUtil.parseJson(ruleMap.get("datasoucejson"));
            for (Map<String, String> dataSourceMap : dataSourceMapList) {
                if (!tableId.equals(dataSourceMap.get("tableidd"))) continue;
                return true;
            }
        }
        return false;
    }
}

