/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.FunctionMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.cal.CalculateService;
import kd.taxc.common.util.BigDecimalUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.BooleanEnum;
import kd.taxc.tctb.common.element.Element;
import kd.taxc.tctb.common.element.Formula;
import kd.taxc.tctb.common.element.RiskCalSerivce;
import kd.taxc.tctb.common.element.TimeDeviatedEnum;
import kd.taxc.tctb.common.element.factory.ElementSqlServiceFactory;
import kd.taxc.tctb.common.element.util.EleTreeUtil;
import kd.taxc.tctb.common.element.util.ElementUtil;
import kd.taxc.tctb.common.util.CalUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ElementSqlService {
    private static Log logger = LogFactory.getLog(ElementSqlService.class);
    protected static final String VALUE = "value";
    protected static final String FALSE_STRING = "false";
    protected static final String TRUE_STRING = "true";
    protected static final String IS_EMPTY_FIELD = "isEmptyField";
    protected static final String IS_DENOMINATOR_ZERO = "isDenominatorZero";

    public static DynamicObjectCollection querySql(String json_tag, String orgid, String deviatedOriginalStartDate, String startData, String endData) {
        return ElementSqlService.querySqlByRiskSampling(json_tag, orgid, deviatedOriginalStartDate, startData, endData, "END");
    }

    public static Map<String, DynamicObject> queryAllEnableEleInfoMap() {
        QFilter qFilter = new QFilter("enable", "=", (Object)BooleanEnum.YES.getCode());
        DynamicObjectCollection elementColls = QueryServiceHelper.query((String)"tdm_element_group", (String)"id,number,name,json_tag,formula,json,bottom,timedeviationcount,timedeviationtype,timedeviationdirection,autorefresh,isvariable,describe,datatype,typevalue,risktimedeviationtype", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, DynamicObject> eleCode2InfoMap = new HashMap<String, DynamicObject>(elementColls.size());
        for (DynamicObject ele : elementColls) {
            eleCode2InfoMap.put(ele.getString("number"), ele);
        }
        return eleCode2InfoMap;
    }

    public static DynamicObjectCollection querySqlByRiskSampling(String json_tag, String orgid, String deviatedOriginalStartDate, String startDateStr, String endDateStr, String dataType) {
        Map<String, String> ruleMap;
        logger.info("ElementSqlService.querySql()\u3002\u5f00\u59cb\u67e5\u8be2\u53d6\u6570\u8868\u914d\u7f6e\u3002");
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startDateStr));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)endDateStr));
        if (!"SUM".equals(dataType)) {
            if ("START".equals(dataType)) {
                endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            } else {
                startDate = "CUMULATIVE".equals(dataType) ? DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)deviatedOriginalStartDate)) : DateUtils.getFirstDateOfMonth((Date)endDate);
            }
        }
        if (null == (ruleMap = ElementUtil.findRule(json_tag, orgid)) || EmptyCheckUtils.isEmpty((Object)ruleMap.get("tableid"))) {
            logger.error("datasource is null");
            return new DynamicObjectCollection();
        }
        String tableId = ruleMap.get("tableid");
        QFilter tableid = new QFilter("id", "=", (Object)Long.parseLong(tableId));
        QFilter[] filters = new QFilter[]{tableid};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,type,subname as zbsubname,ischild,entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
        ArrayList<DynamicObject> fields = new ArrayList<DynamicObject>();
        DynamicObject orgstate = null;
        DynamicObject datastate = null;
        DynamicObject yearstate = null;
        DynamicObject monthstate = null;
        for (DynamicObject d : collection) {
            String[] fieldIdArr;
            for (String field : fieldIdArr = ruleMap.get("fieldid").split(",")) {
                if (!d.getString("entryentity.id").equals(field)) continue;
                fields.add(d);
            }
            if (TRUE_STRING.equals(d.getString("entryentity.orgstate"))) {
                orgstate = d;
            }
            if (TRUE_STRING.equals(d.getString("entryentity.datastate"))) {
                datastate = d;
            }
            if (TRUE_STRING.equals(d.getString("entryentity.yearstate"))) {
                yearstate = d;
            }
            if (!TRUE_STRING.equals(d.getString("entryentity.monthstate"))) continue;
            monthstate = d;
        }
        if (fields.size() > 0) {
            boolean ischild = ((DynamicObject)fields.get(0)).getBoolean("ischild");
            String name = ((DynamicObject)fields.get(0)).getString("name");
            String subname = ((DynamicObject)fields.get(0)).getString("zbsubname");
            String tabletype = ((DynamicObject)fields.get(0)).getString("type");
            if (EmptyCheckUtils.isEmpty((Object)orgstate)) {
                logger.error("orgid = " + orgid);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u653f\u7b56\u8fd0\u7ef4 \u53d6\u6570\u8868\u914d\u7f6e\u51fa\u9519\u3002 \u5b9e\u4f53\u540d\u79f0\u4e3a%1$s,\u5b57\u8868\u540d\u79f0\u4e3a %2$s \u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a", (String)"ElementSqlService_1", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]), name, subname));
            }
            kd.taxc.tctb.common.element.factory.ElementSqlService factory = ElementSqlServiceFactory.factory(ischild, name);
            List<String> selectFieldList = factory.findSelectFieldList(ischild, fields, name, subname, ruleMap);
            selectFieldList = selectFieldList.stream().distinct().collect(Collectors.toList());
            String selectFields = String.join((CharSequence)",", selectFieldList);
            return factory.queryElement(orgid, startDate, endDate, ruleMap, orgstate, datastate, name, subname, selectFields, tabletype, yearstate, monthstate, startDateStr, endDateStr, dataType);
        }
        return new DynamicObjectCollection();
    }

    public static Map<String, Object> querySql(String json_tag, String orgid, String deviatedOriginalStartDate, String startDateStr, String endDateStr, String dataType) {
        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(256);
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        HashMap<String, Date> eleDateMap = new HashMap<String, Date>(16);
        logger.info("ElementSqlService.querySql()\u3002\u5f00\u59cb\u67e5\u8be2\u53d6\u6570\u8868\u914d\u7f6e\u3002");
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startDateStr));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)endDateStr));
        Date dataSourceDate = null;
        if (!"SUM".equals(dataType)) {
            if ("START".equals(dataType)) {
                dataSourceDate = endDate = DateUtils.getLastDateOfMonth((Date)startDate);
                dataSourceDate = DateUtils.getFirstDateOfMonth((Date)dataSourceDate);
            } else if ("CUMULATIVE".equals(dataType)) {
                startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)deviatedOriginalStartDate));
            } else {
                startDate = DateUtils.getFirstDateOfMonth((Date)endDate);
                dataSourceDate = endDate;
                dataSourceDate = DateUtils.getFirstDateOfMonth((Date)dataSourceDate);
            }
        }
        List<Map<String, String>> ruleMapList = ElementUtil.findNewRule(json_tag, orgid, startDate, endDate, dataSourceDate);
        eleDateMap.put("elestartdate", startDate);
        eleDateMap.put("eleenddate", endDate);
        resMap.put("eledatekey", eleDateMap);
        if (EmptyCheckUtils.isEmpty(ruleMapList)) {
            logger.error("ruleMapList is null");
            return resMap;
        }
        for (Map<String, String> ruleMap : ruleMapList) {
            if (null == ruleMap || EmptyCheckUtils.isEmpty((Object)ruleMap.get("tableidd"))) continue;
            Date queryStartDate = BooleanEnum.YES.getCode().equalsIgnoreCase(ruleMap.get("isNeedChangeQueryDate")) ? DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)ruleMap.get("querystartdate"))) : startDate;
            Date queryEndDate = BooleanEnum.YES.getCode().equalsIgnoreCase(ruleMap.get("isNeedChangeQueryDate")) ? DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)ruleMap.get("queryenddate"))) : endDate;
            String tableId = ruleMap.get("tableidd");
            QFilter tableid = new QFilter("id", "=", (Object)Long.parseLong(tableId));
            QFilter[] filters = new QFilter[]{tableid};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,type,subname as zbsubname,ischild,entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
            ArrayList<DynamicObject> fields = new ArrayList<DynamicObject>();
            DynamicObject orgstate = null;
            DynamicObject datastate = null;
            DynamicObject yearstate = null;
            DynamicObject monthstate = null;
            for (DynamicObject d : collection) {
                String[] fieldIdArr;
                for (String field : fieldIdArr = ruleMap.get("fieldidd").split(",")) {
                    if (!d.getString("entryentity.id").equals(field)) continue;
                    fields.add(d);
                }
                if (TRUE_STRING.equals(d.getString("entryentity.orgstate"))) {
                    orgstate = d;
                }
                if (TRUE_STRING.equals(d.getString("entryentity.datastate"))) {
                    datastate = d;
                }
                if (TRUE_STRING.equals(d.getString("entryentity.yearstate"))) {
                    yearstate = d;
                }
                if (!TRUE_STRING.equals(d.getString("entryentity.monthstate"))) continue;
                monthstate = d;
            }
            if (fields.size() <= 0) continue;
            boolean ischild = ((DynamicObject)fields.get(0)).getBoolean("ischild");
            String name = ((DynamicObject)fields.get(0)).getString("name");
            String subname = ((DynamicObject)fields.get(0)).getString("zbsubname");
            String tabletype = ((DynamicObject)fields.get(0)).getString("type");
            if (EmptyCheckUtils.isEmpty((Object)orgstate)) {
                logger.error("orgid = " + orgid);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u653f\u7b56\u8fd0\u7ef4 \u53d6\u6570\u8868\u914d\u7f6e\u51fa\u9519\u3002 \u5b9e\u4f53\u540d\u79f0\u4e3a%1$s,\u5b57\u8868\u540d\u79f0\u4e3a %2$s \u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a", (String)"ElementSqlService_1", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]), name, subname));
            }
            kd.taxc.tctb.common.element.factory.ElementSqlService factory = ElementSqlServiceFactory.factory(ischild, name);
            List<String> selectFieldList = factory.findSelectFieldList(ischild, fields, name, subname, ruleMap);
            selectFieldList = selectFieldList.stream().distinct().collect(Collectors.toList());
            String selectFields = String.join((CharSequence)",", selectFieldList);
            if ("gl_balance".equals(name)) {
                BigDecimal bigDecimal = factory.queryElementByBalance(orgid, queryStartDate, queryEndDate, ruleMap, orgstate, datastate, name, subname, selectFields, tabletype, yearstate, monthstate, startDateStr, endDateStr, dataType);
                if (null == bigDecimal) continue;
                vals.add(bigDecimal);
                continue;
            }
            DynamicObjectCollection dynamicObjects = factory.queryElement(orgid, queryStartDate, queryEndDate, ruleMap, orgstate, datastate, name, subname, selectFields, tabletype, yearstate, monthstate, startDateStr, endDateStr, dataType);
            for (DynamicObject dynamicObject : dynamicObjects) {
                vals.add(dynamicObject.getBigDecimal(0));
            }
        }
        resMap.put("elevalkey", vals);
        return resMap;
    }

    public static List<String> getFilterFieldNameList(String jsonTag) {
        Map map = (Map)SerializationUtils.fromJsonString((String)jsonTag, Map.class);
        ArrayList<String> filterFieldList = new ArrayList<String>();
        String filterJson = (String)map.get("filterJson");
        Map filterJsonMap = (Map)SerializationUtils.fromJsonString((String)filterJson, Map.class);
        List filterRows = (List)filterJsonMap.get("FilterRow");
        if (filterRows != null) {
            for (Map filterRowMap : filterRows) {
                String fieldName = (String)filterRowMap.get("FieldName");
                if (!StringUtils.isNotEmpty((CharSequence)fieldName)) continue;
                filterFieldList.add(fieldName);
            }
        }
        return filterFieldList;
    }

    public Map<String, Map<String, String>> autoUpdateEle(Map<String, DynamicObject> eleCode2InfoMap, Map<String, Map<String, String>> eleKey2EleResultMap, List<DynamicObject> elementResultList, String orgid, List<String> codes, String originalStartDate, String startDateStr, String endDateStr) {
        List<String> topCodes = EleTreeUtil.findNestTopEleCodesByBottoms(EleTreeUtil.createEleTree(), codes);
        if (EmptyCheckUtils.isEmpty(topCodes)) {
            return eleKey2EleResultMap;
        }
        logger.info("topelecodes:" + topCodes.stream().collect(Collectors.joining("-")));
        for (String code : topCodes) {
            this.calElement(eleCode2InfoMap, eleKey2EleResultMap, elementResultList, orgid, code, originalStartDate, startDateStr, endDateStr, null);
        }
        return eleKey2EleResultMap;
    }

    public Map<String, String> calElement(Map<String, DynamicObject> eleCode2InfoMap, Map<String, Map<String, String>> eleKey2EleResultMap, List<DynamicObject> elementResultList, String orgid, String code, String originalStartDate, String startDateStr, String endDateStr, String topdatatype) {
        String key = this.getKey(orgid, code, startDateStr, endDateStr);
        logger.info("\u5f00\u59cb\u91cd\u65b0\u8ba1\u7b97\u5143\u7d20 key = " + key);
        if (null != eleKey2EleResultMap && null != eleKey2EleResultMap.get(key)) {
            logger.info("query for local cache : key = " + key);
            return eleKey2EleResultMap.get(key);
        }
        DynamicObject element = eleCode2InfoMap.get(code);
        HashMap<String, String> elementResultMap = new HashMap<String, String>();
        if (element != null) {
            String json;
            String deviationType = element.getString("timedeviationtype");
            int timeDeviationCount = EmptyCheckUtils.isEmpty((Object)element.getString("timedeviationcount")) ? 0 : Integer.parseInt(element.getString("timedeviationcount").trim());
            String startDateStr2 = startDateStr;
            String endDateStr2 = endDateStr;
            if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType())) {
                startDateStr2 = DateUtils.format((Date)DateUtils.getFirstDateOfSeason((Date)DateUtils.stringToDate((String)startDateStr2)));
                endDateStr2 = DateUtils.format((Date)DateUtils.getLastDateOfSeason((Date)DateUtils.stringToDate((String)endDateStr2)));
            } else if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType())) {
                startDateStr2 = DateUtils.format((Date)DateUtils.getFirstDateOfHalfYear((Date)DateUtils.stringToDate((String)startDateStr2)));
                endDateStr2 = DateUtils.format((Date)DateUtils.getLastDateOfHalfYear((Date)DateUtils.stringToDate((String)endDateStr2)));
            } else if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType())) {
                startDateStr2 = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)startDateStr2)));
                endDateStr2 = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)DateUtils.stringToDate((String)endDateStr2)));
            }
            String deviatedStartDate = TimeDeviatedEnum.getDeviatedDateByMonth(startDateStr2, timeDeviationCount, "-");
            deviatedStartDate = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)deviatedStartDate)));
            String deviatedEndDate = TimeDeviatedEnum.getDeviatedDateByMonth(endDateStr2, timeDeviationCount, "-");
            deviatedEndDate = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)deviatedEndDate)));
            String deviatedOriginalStartDate = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)deviatedEndDate)));
            String bottom = element.getString("bottom");
            String elementName = element.getString("name");
            Long eleId = element.getLong("id");
            Date runtime = new Date();
            String jsonTag = element.getString("json_tag");
            if (TRUE_STRING.equals(bottom)) {
                String dataType = element.getString("datatype");
                boolean isEmptyField = true;
                Map<String, Object> resMap = ElementSqlService.querySql(jsonTag, orgid, deviatedOriginalStartDate, deviatedStartDate, deviatedEndDate, dataType);
                BigDecimal elementResultValue = null;
                Map eleDateMap = EmptyCheckUtils.isNotEmpty((Object)resMap.get("eledatekey")) ? (Map)resMap.get("eledatekey") : new HashMap();
                if (EmptyCheckUtils.isEmpty(resMap) || EmptyCheckUtils.isEmpty((Object)resMap.get("elevalkey"))) {
                    logger.info("=========== \u672a\u67e5\u8be2\u5230\u6570\u636e======");
                } else {
                    List vals = (List)resMap.get("elevalkey");
                    for (BigDecimal bigDecimal : vals) {
                        elementResultValue = BigDecimalUtil.addObject(elementResultValue, (Object)bigDecimal);
                        if (null == bigDecimal) continue;
                        isEmptyField = false;
                    }
                }
                String value = EmptyCheckUtils.isEmpty(elementResultValue) ? "null" : BigDecimalUtil.setScale(elementResultValue, (int)4).toPlainString();
                elementResultMap.put(VALUE, value);
                elementResultMap.put(IS_EMPTY_FIELD, String.valueOf(isEmptyField));
                this.addNoRepeatElementResultList(elementResultList, orgid, code, startDateStr, endDateStr, elementName, eleId, runtime, value, isEmptyField, false, eleKey2EleResultMap, eleDateMap);
                String key1 = this.getKey(orgid, code, startDateStr, endDateStr);
                if (null != key1 && key1.trim().length() > 0) {
                    eleKey2EleResultMap.put(key1, elementResultMap);
                }
                return elementResultMap;
            }
            HashMap<String, Date> eleDateMap = new HashMap<String, Date>(8);
            eleDateMap.put("elestartdate", DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startDateStr2)));
            eleDateMap.put("eleenddate", DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)endDateStr2)));
            String temp = json = (String)((Map)SerializationUtils.fromJsonString((String)jsonTag, Map.class)).get("formula");
            String[] formula = json.split(" ");
            boolean isEmptyField = true;
            for (String content : formula) {
                if (StringUtils.isEmpty((CharSequence)content) || "+-*/()<><=>=abs(".contains(content)) continue;
                if (ElementUtil.isConstantNumber(content, eleCode2InfoMap)) {
                    isEmptyField = false;
                    continue;
                }
                Map<String, String> map = this.calElement(eleCode2InfoMap, eleKey2EleResultMap, elementResultList, orgid, content, originalStartDate, startDateStr, endDateStr, topdatatype);
                String value = map.get(VALUE);
                if (!TRUE_STRING.equals(map.get(IS_EMPTY_FIELD))) {
                    isEmptyField = false;
                }
                if (value == null) continue;
                value = "null".equalsIgnoreCase(value) ? "0" : value;
                temp = temp.replace(content, value);
            }
            boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero(temp);
            String value = isEmptyField || isDenominatorZero ? "null" : BigDecimalUtil.setScale((Object)CalculateService.calculate((String)temp), (int)4).toPlainString();
            elementResultMap.put(VALUE, value);
            elementResultMap.put(IS_EMPTY_FIELD, String.valueOf(isEmptyField));
            elementResultMap.put(IS_DENOMINATOR_ZERO, String.valueOf(isDenominatorZero));
            this.addNoRepeatElementResultList(elementResultList, orgid, code, startDateStr, endDateStr, elementName, eleId, runtime, value, isEmptyField, isDenominatorZero, eleKey2EleResultMap, eleDateMap);
            eleKey2EleResultMap.put(key, elementResultMap);
            return elementResultMap;
        }
        return elementResultMap;
    }

    protected String getUserType() {
        return "1";
    }

    public String getKey(String orgid, String code, String startDateStr, String endDateStr) {
        return orgid + '_' + code + '_' + startDateStr + '_' + endDateStr + '_' + this.getUserType();
    }

    public void addNoRepeatElementResultList(List<DynamicObject> elementResultList, String orgid, String code, String startDateStr, String endDateStr, String elementName, Long eleId, Date runtime, String value, boolean isEmptyField, boolean isDenominatorZero, Map<String, Map<String, String>> eleKey2EleResultMap, Map<String, Date> eleDateMap) {
        if (EmptyCheckUtils.isNotEmpty(eleKey2EleResultMap.get(this.getKey(orgid, code, startDateStr, endDateStr)))) {
            logger.info("find in cache by key =" + this.getKey(orgid, code, startDateStr, endDateStr));
            return;
        }
        DynamicObject elementResult = this.createElementResult(orgid, code, elementName, startDateStr, endDateStr, value, runtime, eleId, isEmptyField, isDenominatorZero, eleDateMap);
        elementResultList.add(elementResult);
    }

    public List<DynamicObject> getNoRepeatElementList(List<DynamicObject> elementResultList) {
        if (CollectionUtils.isEmpty(elementResultList)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> noRepeatList = new ArrayList<DynamicObject>();
        noRepeatList.add(elementResultList.get(0));
        for (DynamicObject dyn : elementResultList) {
            DynamicObject dynamicObject;
            boolean isRepeatElementResult = false;
            Iterator iterator = noRepeatList.iterator();
            while (iterator.hasNext() && ((dynamicObject = (DynamicObject)iterator.next()) == null || dyn == null || !(isRepeatElementResult = dyn.getString("org").equals(dynamicObject.getString("org")) && dyn.getString("element").equals(dynamicObject.getString("element")) && dyn.getDate("startdata").compareTo(dynamicObject.getDate("startdata")) == 0 && dyn.getDate("enddata").compareTo(dynamicObject.getDate("enddata")) == 0))) {
            }
            if (isRepeatElementResult) continue;
            noRepeatList.add(dyn);
        }
        return noRepeatList;
    }

    public List<DynamicObject> batchCalElements(Map<String, DynamicObject> eleCode2InfoMap, Map<String, List<String>> orgsAndPeriods, List<String> codes) {
        HashMap<String, Map<String, String>> eleKey2EleResultMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<DynamicObject> eleResults = new ArrayList<DynamicObject>();
        if (EmptyCheckUtils.isNotEmpty(codes)) {
            logger.info("\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97\u5143\u7d20codes=" + codes.stream().collect(Collectors.joining(",")));
        }
        for (String code : codes) {
            for (Map.Entry<String, List<String>> entry : orgsAndPeriods.entrySet()) {
                String org = entry.getKey();
                List<String> periods = entry.getValue();
                DynamicObject element = eleCode2InfoMap.get(code);
                String originalStartDate = EmptyCheckUtils.isEmpty(periods) ? null : periods.get(0).split(",")[0];
                String deviationType = element.getString("timedeviationtype");
                for (String period : periods) {
                    String start = period.split(",")[0];
                    String end = period.split(",")[1];
                    List<Map<String, Date>> calDateList = CalUtils.getCalDate(deviationType, DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)start)), DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)end)));
                    for (Map<String, Date> dateMap : calDateList) {
                        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
                        logger.info("\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97\u5143\u7d20 code = " + code + " org = " + org + " startdate=" + start + " end = " + end);
                        this.calElement(eleCode2InfoMap, eleKey2EleResultMap, dynamicObjects, org, code, originalStartDate, DateUtils.format((Date)dateMap.get("startdate")), DateUtils.format((Date)dateMap.get("enddate")), null);
                        eleResults.addAll(dynamicObjects);
                    }
                }
            }
        }
        return eleResults;
    }

    private DynamicObject createElementResult(String orgid, String elementCode, String elementName, String startData, String endData, String value, Date runtime, Long eleId, boolean isEmptyField, boolean isDenominatorZero, Map<String, Date> eleDateMap) {
        DynamicObject dynamicObject;
        logger.info("ElementSqlService.createElementResult()\u3002\u521b\u5efa\u5143\u7d20\u8ba1\u7b97\u7ed3\u679c\u3002");
        logger.info("elementCode:" + elementCode + ",elementName:" + elementName + ",startData:" + startData + ",endData:" + endData + ",runtime:" + runtime + ",orgid:" + orgid);
        logger.info(" \u5143\u7d20\u7ed3\u679c\u503c\u4e3a\uff1a" + value);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("startDate", startData);
        map1.put("endDate", endData);
        List<Element> list = this.queryElementValue(orgid, elementCode, Collections.singletonList(map1));
        if (list != null) {
            logger.debug("size:" + list.size());
        }
        Boolean isExist = Boolean.TRUE;
        if (null != list && list.size() > 0) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getId(), (String)"tdm_element_result");
        } else {
            isExist = Boolean.FALSE;
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tdm_element_result");
        }
        dynamicObject.set("org", (Object)orgid);
        dynamicObject.set("element", (Object)elementCode);
        dynamicObject.set("name", (Object)elementName);
        dynamicObject.set("startdata", (Object)DateUtils.stringToDate((String)startData));
        dynamicObject.set("enddata", (Object)DateUtils.stringToDate((String)endData));
        dynamicObject.set(VALUE, (Object)value);
        dynamicObject.set("runtime", (Object)runtime);
        dynamicObject.set("elestartdate", (Object)eleDateMap.get("elestartdate"));
        dynamicObject.set("eleenddate", (Object)eleDateMap.get("eleenddate"));
        dynamicObject.set("elementDef", (Object)eleId);
        dynamicObject.set("usetype", (Object)this.getUserType());
        dynamicObject.set("isdenominatorzero", (Object)isDenominatorZero);
        dynamicObject.set("isemptyfield", (Object)isEmptyField);
        if (isExist.booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            try (FunctionMutex funMutex = FunctionMutex.create();){
                List<Element> doAgainQueryResList;
                boolean success = funMutex.require(Long.parseLong(orgid), "createElementResult" + elementCode + startData + endData);
                if (success && EmptyCheckUtils.isEmpty(doAgainQueryResList = this.queryElementValue(orgid, elementCode, Collections.singletonList(map1)))) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
            }
            catch (Exception e) {
                logger.error("\u4e92\u65a5\u9501\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return dynamicObject;
    }

    public List<Element> queryElementValue(String orgid, String elementCode, List<Map<String, String>> periodList) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5143\u7d20\u7ed3\u679c\u503c\u3002queryElementValue\u3002");
        ArrayList<Element> list = new ArrayList<Element>();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter elementFilter = new QFilter("element", "=", (Object)elementCode);
        QFilter useTypeFilter = new QFilter("usetype", "=", (Object)this.getUserType());
        if (periodList.isEmpty()) {
            return null;
        }
        QFilter qPeriods = null;
        for (int i = 0; i < periodList.size(); ++i) {
            String endDateStr = periodList.get(i).get("endDate");
            Date endDate = DateUtils.stringToDate((String)endDateStr);
            QFilter endFilter = new QFilter("enddata", "=", (Object)endDate).or("enddata", "=", (Object)DateUtils.stringToDate((String)(endDateStr.substring(0, 10) + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
            QFilter qFilter = new QFilter("startdata", "=", (Object)DateUtils.stringToDate((String)periodList.get(i).get("startDate"))).and(endFilter);
            if (0 == i || qPeriods == null) {
                qPeriods = qFilter;
                continue;
            }
            qPeriods.or(qFilter);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"tdm_element_result", (String)"id,name,startdata,enddata,value,isemptyfield", (QFilter[])new QFilter[]{orgFilter, elementFilter, useTypeFilter, qPeriods}, (String)"runtime asc");
        Field[] fields = Element.class.getDeclaredFields();
        Method[] method = Element.class.getDeclaredMethods();
        try {
            HashMap<String, Method> methods = new HashMap<String, Method>(method.length);
            for (Method e : method) {
                methods.put(e.getName(), e);
            }
            for (DynamicObject d : doc) {
                Element element = new Element();
                for (Field field : fields) {
                    String name = field.getName();
                    Method m = (Method)methods.get("set" + name.substring(0, 1).toUpperCase() + name.substring(1));
                    if (null == m) continue;
                    m.invoke((Object)element, d.getString(name));
                }
                list.add(element);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("\u7ed3\u675f\u67e5\u8be2\u5143\u7d20\u7ed3\u679c\u503c\u3002queryElementValue\u3002");
        return list;
    }

    public static List<Formula> queryElementValues(String orgid, List<Formula> elements, Date startData, Date endData) {
        if (elements.isEmpty()) {
            return null;
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5143\u7d20\u7ed3\u679c\u503c\u3002queryElementValues\u3002");
        QFilter qelements = null;
        for (Formula formula : elements) {
            if (!"1".equals(formula.getType())) continue;
            String elementCodes = formula.getCode();
            Date start = formula.getStartDate();
            Date end = formula.getEndDate();
            logger.info("queryElementValues()\u3002elementCodes:" + elementCodes + ",start:" + start + ",end:" + end + ",orgid:" + orgid);
            QFilter elementcode = new QFilter("element", "=", (Object)elementCodes);
            QFilter startdata = new QFilter("startdata", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)start)));
            QFilter enddata = new QFilter("enddata", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)end))));
            enddata.or(new QFilter("enddata", "=", (Object)DateUtils.getLastDateOfMonth((Date)end)));
            QFilter qelement = new QFilter("org", "=", (Object)Long.parseLong(orgid));
            QFilter usetype = new QFilter("usetype", "=", (Object)"0");
            qelement.and(elementcode);
            qelement.and(startdata);
            qelement.and(usetype);
            qelement.and(enddata);
            if (null == qelements) {
                qelements = qelement;
                continue;
            }
            qelements.or(qelement);
        }
        if (EmptyCheckUtils.isEmpty(qelements)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Formula> list = new ArrayList<Formula>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"tdm_element_result", (String)"id,element,name,startdata,enddata,value,isemptyfield,isdenominatorzero", (QFilter[])new QFilter[]{qelements}, (String)"runtime asc");
        for (DynamicObject dynamicObject : doc) {
            Formula formula = new Formula("1");
            formula.setStartDate(dynamicObject.getDate("startdata"));
            formula.setEndDate(dynamicObject.getDate("enddata"));
            formula.setValue(dynamicObject.getString(VALUE));
            formula.setCode(dynamicObject.getString("element"));
            formula.setName(dynamicObject.getString("name"));
            formula.setIsEmptyField(dynamicObject.getString("isemptyfield"));
            formula.setIsDenominatorZero(dynamicObject.getString("isdenominatorzero"));
            list.add(formula);
        }
        logger.info("\u7ed3\u675f\u67e5\u8be2\u5143\u7d20\u7ed3\u679c\u503c\u3002queryElementValues\u3002");
        return list;
    }
}

