/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.common.element.enums.MultiLangEnumBridge;

public enum TimeDeviatedEnum {
    TIME_DEVIATION_MONTH("1", new MultiLangEnumBridge("\u6708\u5ea6", "TimeDeviatedEnum_8", "taxc-tctb-tctrc-common"), 1, 13),
    TIME_DEVIATION_SEASON("2", new MultiLangEnumBridge("\u5b63\u5ea6", "TimeDeviatedEnum_9", "taxc-tctb-tctrc-common"), 3, 5),
    TIME_DEVIATION_HALF_YEAR("3", new MultiLangEnumBridge("\u534a\u5e74\u5ea6", "TimeDeviatedEnum_10", "taxc-tctb-tctrc-common"), 6, 3),
    TIME_DEVIATION_YEAR("4", new MultiLangEnumBridge("\u5e74\u5ea6", "TimeDeviatedEnum_11", "taxc-tctb-tctrc-common"), 12, 2);

    private String deviatedType;
    private Integer deviatedCount;
    private Integer comboValCount;
    private MultiLangEnumBridge bridge = null;

    public Integer getDeviatedCount() {
        return this.deviatedCount;
    }

    public String getDeviatedType() {
        return this.deviatedType;
    }

    public Integer getComboValCount() {
        return this.comboValCount;
    }

    public String getDeviatedTypeMsg() {
        return this.bridge.loadKDString();
    }

    private TimeDeviatedEnum(String deviatedType, MultiLangEnumBridge bridge, Integer deviatedCount, Integer comboValCount) {
        this.bridge = bridge;
        this.deviatedType = deviatedType;
        this.deviatedCount = deviatedCount;
        this.comboValCount = comboValCount;
    }

    public static String getDeviatedDesc(String deviatedDirection, Integer deviatedCount, String deviatedType) {
        String deviatedDesc = "";
        if (deviatedCount == 0) {
            return ResManager.loadKDString((String)"\u4e0d\u504f\u79fb", (String)"TimeDeviatedEnum_4", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]);
        }
        deviatedDesc = "+".equals(deviatedDirection) ? deviatedDesc.concat(ResManager.loadKDString((String)"\u5411\u524d\u504f\u79fb", (String)"TimeDeviatedEnum_5", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0])).concat(String.valueOf(deviatedCount)).concat(ResManager.loadKDString((String)"\u4e2a", (String)"TimeDeviatedEnum_6", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0])) : deviatedDesc.concat(ResManager.loadKDString((String)"\u5411\u540e\u504f\u79fb", (String)"TimeDeviatedEnum_7", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0])).concat(String.valueOf(deviatedCount)).concat(ResManager.loadKDString((String)"\u4e2a", (String)"TimeDeviatedEnum_6", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]));
        deviatedDesc = deviatedDesc + TimeDeviatedEnum.getMsgByDeviatedType(deviatedType);
        return deviatedDesc;
    }

    public static String getMsgByDeviatedType(String deviatedType) {
        for (TimeDeviatedEnum value : TimeDeviatedEnum.values()) {
            if (!value.getDeviatedType().equals(deviatedType)) continue;
            return value.getDeviatedTypeMsg();
        }
        return "";
    }

    public static TimeDeviatedEnum getEnumByDeviatedType(String deviatedType) {
        for (TimeDeviatedEnum deviatedEnum : TimeDeviatedEnum.values()) {
            if (!deviatedEnum.getDeviatedType().equals(deviatedType)) continue;
            return deviatedEnum;
        }
        return null;
    }

    public static String getDeviatedTypeByDeviatedCount(Integer deviatedCount) {
        for (TimeDeviatedEnum deviatedEnum : TimeDeviatedEnum.values()) {
            if (!deviatedEnum.getDeviatedCount().equals(deviatedCount)) continue;
            return deviatedEnum.getDeviatedType();
        }
        return TIME_DEVIATION_MONTH.getDeviatedType();
    }

    public static Integer getDeviatedMonth(String deviatedDirection, int timeDeviatedCount, String deviatedType) {
        int deviatedCharcter = -1;
        if ("-".equals(deviatedDirection)) {
            deviatedCharcter = 1;
        }
        for (TimeDeviatedEnum deviatedEnum : TimeDeviatedEnum.values()) {
            if (!deviatedEnum.getDeviatedType().equals(deviatedType)) continue;
            return timeDeviatedCount * deviatedCharcter * deviatedEnum.getDeviatedCount();
        }
        return 0;
    }

    public static String getDeviatedDate(String dateStr, String deviatedDirection, Integer timeDeviatedCount, String deviatedType) {
        Integer deviatedMonth = TimeDeviatedEnum.getDeviatedMonth(deviatedDirection, timeDeviatedCount, deviatedType);
        if (deviatedMonth == 0) {
            return dateStr;
        }
        Date date = DateUtils.stringToDate((String)dateStr);
        Date realDate = DateUtils.addMonth((Date)date, (int)deviatedMonth);
        return DateUtils.format((Date)realDate);
    }

    public static String getDeviatedDateByMonth(String dateStr, Integer deviatedMonth, String deviatedDirection) {
        if (deviatedMonth == 0) {
            return dateStr;
        }
        Date date = DateUtils.stringToDate((String)dateStr);
        Date realDate = DateUtils.addMonth((Date)date, (int)Integer.parseInt(deviatedDirection + deviatedMonth));
        return DateUtils.format((Date)realDate);
    }
}

