/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.factory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.FilterBuilderUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.common.element.factory.ElementSqlService;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractElementSqlService
implements ElementSqlService {
    private static Log logger = LogFactory.getLog(AbstractElementSqlService.class);

    public List<Map<String, String>> composeYearMonthMapsList(String startData, String endData, String dataType) {
        if (startData == null || endData == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        int startYear = NumberUtils.toInt((String)startData.substring(0, 4));
        int startMonth = NumberUtils.toInt((String)startData.substring(5, 7));
        int endYear = NumberUtils.toInt((String)endData.substring(0, 4));
        int endMonth = NumberUtils.toInt((String)endData.substring(5, 7));
        int yearNum = startYear;
        int monthNum = startMonth;
        if ("SUM".equals(dataType) || "CUMULATIVE".equals(dataType)) {
            while (yearNum != endYear || monthNum <= endMonth) {
                HashMap<String, String> yearMonthMap = new HashMap<String, String>();
                yearMonthMap.put("year", String.valueOf(yearNum));
                yearMonthMap.put("month", StringUtil.fillCharAtLeft((Object)monthNum, (int)2, (char)'0'));
                list.add(yearMonthMap);
                if (++monthNum == 13) {
                    monthNum = 1;
                    ++yearNum;
                }
                if (yearNum <= endYear) continue;
                break;
            }
        } else if ("START".equals(dataType)) {
            HashMap<String, String> yearMonthMap = new HashMap<String, String>();
            yearMonthMap.put("year", String.valueOf(startYear));
            yearMonthMap.put("month", StringUtil.fillCharAtLeft((Object)monthNum, (int)2, (char)'0'));
            list.add(yearMonthMap);
        } else {
            HashMap<String, String> yearMonthMap = new HashMap<String, String>();
            yearMonthMap.put("year", String.valueOf(endYear));
            yearMonthMap.put("month", StringUtil.fillCharAtLeft((Object)endMonth, (int)2, (char)'0'));
            list.add(yearMonthMap);
        }
        return list;
    }

    protected DynamicObjectCollection queryDataByDefaultWay(String orgid, Date startDate, Date endDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String selectFields, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter org = new QFilter(orgstate.getString("entryentity.fieldname"), "=", (Object)Long.parseLong(orgid));
        QFilter q = FilterBuilderUtils.buildFilter((String)(EmptyCheckUtils.isEmpty((Object)ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond")), (String)name);
        qFilterList.add(org);
        qFilterList.add(q);
        if (datastate != null) {
            QFilter skssqq = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)startDate);
            QFilter skssqz = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)endDate);
            qFilterList.add(skssqq);
            qFilterList.add(skssqz);
            return QueryServiceHelper.query((String)name, (String)selectFields, (QFilter[])new QFilter[]{org, skssqq, skssqz, q});
        }
        if (monthstate != null && yearstate != null) {
            String yearFieldName = yearstate.getString("entryentity.fieldname");
            String monthFieldName = monthstate.getString("entryentity.fieldname");
            logger.info("\u53d6\u6570\u8868\u914d\u7f6e\uff0c\u5e74\u4efd\u5b57\u6bb5:" + yearFieldName + ",\u6708\u4efd\u5b57\u6bb5:" + monthFieldName);
            List<Map<String, String>> list = this.composeYearMonthMapsList(DateUtils.format((Date)startDate), endDateStr, dataType);
            QFilter qFilterAll = null;
            for (Map<String, String> map1 : list) {
                String year = map1.get("year");
                String month = map1.get("month");
                QFilter qFilter = new QFilter(yearFieldName, "=", (Object)year).and(monthFieldName, "=", (Object)month);
                if (null == qFilterAll) {
                    qFilterAll = qFilter;
                    continue;
                }
                qFilterAll.or(qFilter);
            }
            qFilterList.add(qFilterAll);
            return QueryServiceHelper.query((String)name, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u8868\u81f3\u5c11\u8981\u914d\u7f6e\u201c\u65f6\u95f4\u5b57\u6bb5\u201d\u6216\u201c \u5e74\u6708\u5b57\u6bb5 \u201d\u4e2d\u7684\u4efb\u610f\u4e00\u9879\u3002", (String)"AbstractElementSqlService_0", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]));
    }

    @Override
    public List<String> findSelectFieldList(boolean ischild, List<DynamicObject> fields, String masterTbName, String subname, Map<String, String> ruleMap) {
        ArrayList<String> selectFieldList = new ArrayList<String>(fields.size());
        for (DynamicObject field : fields) {
            String tbFlag = field.getString("entryentity.fieldsubname");
            String fieldname = field.getString("entryentity.fieldname");
            if ("gl_voucher".equalsIgnoreCase(masterTbName)) {
                if ("gl_vouchertype".equalsIgnoreCase(tbFlag)) {
                    selectFieldList.add(fieldname);
                    continue;
                }
                if ("bd_accountview".equalsIgnoreCase(tbFlag)) {
                    selectFieldList.add(subname + "." + fieldname);
                    continue;
                }
            } else if ("gl_balance".equalsIgnoreCase(masterTbName) && ("bd_accountbookstype".equalsIgnoreCase(tbFlag) || "bd_accountview".equalsIgnoreCase(tbFlag))) {
                selectFieldList.add(fieldname);
                continue;
            }
            if (!masterTbName.equalsIgnoreCase(tbFlag) && fieldname.indexOf(".") < 0) {
                selectFieldList.add(tbFlag + "." + fieldname);
                continue;
            }
            selectFieldList.add(fieldname);
        }
        QFilter qFilter = FilterBuilderUtils.buildFilter((String)(EmptyCheckUtils.isEmpty((Object)ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond")), (String)masterTbName);
        if (null != qFilter) {
            List qFilters;
            if (!selectFieldList.contains(qFilter.getProperty())) {
                selectFieldList.add(qFilter.getProperty());
            }
            if (EmptyCheckUtils.isNotEmpty((Object)(qFilters = qFilter.getNests(true)))) {
                for (QFilter.QFilterNest filterNest : qFilters) {
                    String field = filterNest.getFilter().getProperty();
                    if (selectFieldList.contains(field)) continue;
                    selectFieldList.add(field);
                }
            }
        }
        selectFieldList.add("id");
        return selectFieldList;
    }

    @Override
    public BigDecimal queryElementByBalance(String orgid, Date queryStartDate, Date queryEndDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String subname, String selectFields, String tabletype, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        return null;
    }
}

