/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.cal.CalculateService;
import kd.taxc.common.entity.ContrastTypeEnum;
import kd.taxc.common.entity.Element;
import kd.taxc.common.entity.FilterElement;
import kd.taxc.common.template.TemplateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.element.ElementSqlService;
import kd.taxc.tctb.common.element.IRiskCalService;
import kd.taxc.tctb.common.element.RiskElementSqlService;
import kd.taxc.tctb.common.element.VariableService;
import org.apache.commons.lang3.StringUtils;

public class ElementVerifyService
implements IRiskCalService {
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";
    private static final String TCTRC_RESULT_RECORDS = "tctrc_result_records";
    private static final String RISK_TYPE = "risktype";
    private static final String RISK_TYPE_VERIFY = "3";
    private static final String NO_EXIST = "0";
    private static final String RISK_LEVEL = "risklevel";
    private static final String RISK_DESC = "riskdesc";
    private static final String IS_DENOMINATOR_ZERO = "isDenominatorZero";
    private static final String IS_EMPTY_FIELD = "isEmptyField";

    @Override
    public Map<String, String> calVerify(Map<String, DynamicObject> eleCode2InfoMap, String resultid, String orgid, String riskCode, String originalStartDate, String startDate, String endDate) {
        DeleteServiceHelper.delete((String)TCTRC_RESULT_RECORDS, (QFilter[])new QFilter[]{new QFilter("resultid", "=", (Object)Long.parseLong(resultid))});
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter number = new QFilter(NUMBER, "=", (Object)riskCode);
        QFilter risktype = new QFilter(RISK_TYPE, "=", (Object)RISK_TYPE_VERIFY);
        DynamicObjectCollection riskEntryList = QueryServiceHelper.query((String)"tctrc_element_verify", (String)"risklevel,variableids,caltype,suggestion,entryentity.exist as exist,entryentity.title as title,entryentity.text as text, entryentity.json_tag as json", (QFilter[])new QFilter[]{number, risktype});
        if (riskEntryList.size() > 0) {
            map.put("resultid", resultid);
            map.put(RISK_LEVEL, ((DynamicObject)riskEntryList.get(0)).getString(RISK_LEVEL));
            String suggestion = ((DynamicObject)riskEntryList.get(0)).getString("suggestion");
            String caltype = ((DynamicObject)riskEntryList.get(0)).getString("caltype");
            map.put(RISK_DESC, this.calVariableInSuggestion(eleCode2InfoMap, orgid, originalStartDate, startDate, endDate, suggestion, caltype));
            ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>();
            Boolean isRisk = null;
            HashSet<String> elementIds = new HashSet<String>();
            HashMap<String, String> idValueMapping = new HashMap<String, String>();
            HashMap<String, String> id2NameValMap = new HashMap<String, String>();
            StringBuilder sb2 = new StringBuilder();
            HashMap<String, Map<String, String>> eleKey2EleResultMap = new HashMap<String, Map<String, String>>(16);
            for (DynamicObject riskEntry : riskEntryList) {
                String exist = riskEntry.getString("exist");
                if (StringUtils.isEmpty((CharSequence)exist)) {
                    exist = "1";
                }
                DynamicObject record = this.createNewRecord(resultid, riskEntry, exist);
                ArrayList<DynamicObject> elementResultList = new ArrayList<DynamicObject>();
                List list = SerializationUtils.fromJsonStringToList((String)riskEntry.getString("json"), FilterElement.class);
                if (list != null && list.size() > 0) {
                    this.collectEleIds(elementIds, list);
                    List elementList = eleCode2InfoMap.values().stream().filter(v -> elementIds.contains(v.getString("id"))).collect(Collectors.toList());
                    Iterator iterator = elementList.iterator();
                    while (iterator.hasNext()) {
                        RiskElementSqlService elementSqlService = new RiskElementSqlService();
                        DynamicObject dynamicObject = (DynamicObject)iterator.next();
                        String elementNumber = dynamicObject.getString(NUMBER);
                        Map<String, String> elementResultMap = ((ElementSqlService)elementSqlService).calElement(eleCode2InfoMap, eleKey2EleResultMap, elementResultList, orgid, elementNumber, originalStartDate, startDate, endDate, caltype);
                        String value = elementResultMap.get(VALUE);
                        if (value != null) {
                            value = "null".equalsIgnoreCase(value) ? NO_EXIST : value;
                        }
                        String id = dynamicObject.getString("id");
                        idValueMapping.put(id, value);
                        String valueStr = "null".equalsIgnoreCase(value) ? "null" : TemplateUtils.formatMicrometer((String)value);
                        id2NameValMap.put(id, "\u3010" + dynamicObject.getString("name") + "\uff08" + valueStr + "\uff09\u3011");
                    }
                    map.put(IS_DENOMINATOR_ZERO, FALSE_STRING);
                    map.put(IS_EMPTY_FIELD, FALSE_STRING);
                }
                StringBuilder sb = new StringBuilder();
                this.concatFormulaStr(idValueMapping, id2NameValMap, sb2, list, sb);
                boolean currentBiDuiFormulaResultBoolean = CalculateService.check((String)sb.toString());
                boolean currentBiDuiWithExistOrNotExistBoolean = NO_EXIST.equals(exist) ? !currentBiDuiFormulaResultBoolean : currentBiDuiFormulaResultBoolean;
                if (null == isRisk) {
                    isRisk = currentBiDuiWithExistOrNotExistBoolean;
                } else if (isRisk.booleanValue()) {
                    isRisk = currentBiDuiWithExistOrNotExistBoolean;
                }
                record.set("fieldid", (Object)elementResultList.stream().filter(v -> EmptyCheckUtils.isNotEmpty((Object)v)).map(e -> e.getString("id")).collect(Collectors.joining(",")));
                recordList.add(record);
            }
            if (null == isRisk) {
                isRisk = Boolean.FALSE;
            }
            for (DynamicObject record : recordList) {
                record.set("isrisk", (Object)isRisk);
            }
            map.put("result", isRisk.toString());
            if (isRisk.booleanValue()) {
                map.put("json", EmptyCheckUtils.isEmpty((Object)sb2) ? "" : sb2.substring(0, sb2.length() - 1));
            } else {
                map.put(RISK_LEVEL, NO_EXIST);
                map.put(RISK_DESC, "");
            }
            SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[0]));
        } else {
            map.put(RISK_LEVEL, NO_EXIST);
            map.put(RISK_DESC, "");
        }
        return map;
    }

    private void concatFormulaStr(Map<String, String> idValueMapping, Map<String, String> id2NameValMap, StringBuilder sb2, List<FilterElement> list, StringBuilder sb) {
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                FilterElement filterElement = list.get(i);
                sb.append(filterElement.getBracketLeft());
                sb2.append(filterElement.getBracketLeft());
                sb.append(idValueMapping.get(filterElement.getElement().getId()));
                sb2.append(id2NameValMap.get(filterElement.getElement().getId()));
                sb.append(filterElement.getCondition());
                sb2.append(filterElement.getCondition());
                if (filterElement.getContrasType().equals(ContrastTypeEnum.CONTRAST_TYPE_ENUM_ELEMENT.getKey())) {
                    sb.append(idValueMapping.get(filterElement.getContrastValue().getElement().getId()));
                    sb2.append(id2NameValMap.get(filterElement.getContrastValue().getElement().getId()));
                } else {
                    sb.append(filterElement.getContrastValue().getInput());
                    sb2.append(filterElement.getContrastValue().getInput());
                }
                sb.append(filterElement.getBracketRight());
                sb2.append(filterElement.getBracketRight());
                if (i != list.size() - 1) {
                    sb.append(filterElement.getOperator());
                    sb.append(filterElement.getOperator());
                    sb2.append(filterElement.getOperator());
                    sb2.append(filterElement.getOperator());
                    continue;
                }
                sb2.append(';');
            }
        }
    }

    private void collectEleIds(Set<String> elementIds, List<FilterElement> list) {
        for (FilterElement filterElement : list) {
            Element compareElement;
            Element element = filterElement.getElement();
            if (EmptyCheckUtils.isNotEmpty((Object)element.getId())) {
                elementIds.add(element.getId());
            }
            if (!filterElement.getContrasType().equals(ContrastTypeEnum.CONTRAST_TYPE_ENUM_ELEMENT.getKey()) || !EmptyCheckUtils.isNotEmpty((Object)(compareElement = filterElement.getContrastValue().getElement())) || !EmptyCheckUtils.isNotEmpty((Object)compareElement.getId())) continue;
            elementIds.add(compareElement.getId());
        }
    }

    private DynamicObject createNewRecord(String resultid, DynamicObject riskEntry, String exist) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)TCTRC_RESULT_RECORDS);
        record.set("resultid", (Object)resultid);
        record.set("title", (Object)riskEntry.getString("title"));
        record.set("text", (Object)riskEntry.getString("text"));
        record.set("exist", (Object)exist);
        record.set("json_tag", (Object)riskEntry.getString("json"));
        return record;
    }

    public String calVariableInSuggestion(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String originalStartDate, String startDate, String endDate, String suggestion, String calType) {
        String riskDesc = VariableService.replaceVariable(eleCode2InfoMap, orgid, suggestion, originalStartDate, startDate, endDate, calType);
        return riskDesc;
    }
}

