/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.element.ElementSqlService;
import kd.taxc.tctb.common.element.IRiskCalService;
import kd.taxc.tctb.common.element.VariableService;

public class SamplingService
implements IRiskCalService {
    @Override
    public Map<String, String> calVerify(Map<String, DynamicObject> eleCode2InfoMap, String resultid, String orgid, String riskCode, String originalStartDate, String startDate, String endDate) {
        DeleteServiceHelper.delete((String)"tctrc_result_records", (QFilter[])new QFilter[]{new QFilter("resultid", "=", (Object)Long.parseLong(resultid))});
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter number = new QFilter("number", "=", (Object)riskCode);
        QFilter risktype = new QFilter("risktype", "=", (Object)"2");
        DynamicObjectCollection riskEntryList = QueryServiceHelper.query((String)"tctrc_risk_sampling", (String)"risklevel,variableids,caltype,suggestion,entryentity.exist as exist,entryentity.title as title, entryentity.tableid as tableid,entryentity.text as text,entryentity.fieldid as fieldid, entryentity.json_tag as json", (QFilter[])new QFilter[]{number, risktype});
        ArrayList<String> recordValueList = new ArrayList<String>();
        if (riskEntryList.size() > 0) {
            Boolean isRisk = null;
            map.put("resultid", resultid);
            String risklevel = ((DynamicObject)riskEntryList.get(0)).getString("risklevel");
            String caltype = ((DynamicObject)riskEntryList.get(0)).getString("caltype");
            map.put("risklevel", risklevel);
            String risklevelDes = risklevel.equalsIgnoreCase("1") ? ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"SamplingService_0", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]) : (risklevel.equalsIgnoreCase("2") ? ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"SamplingService_1", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"SamplingService_2", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]));
            map.put("json", risklevelDes);
            String suggestion = ((DynamicObject)riskEntryList.get(0)).getString("suggestion");
            map.put("riskdesc", this.calVariableInSuggestion(eleCode2InfoMap, orgid, originalStartDate, startDate, endDate, riskEntryList, suggestion, caltype));
            ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>();
            ArrayList<String> filterFieldValueList = new ArrayList<String>();
            for (DynamicObject riskEntry : riskEntryList) {
                List<String> filterFieldNameList = ElementSqlService.getFilterFieldNameList(riskEntry.getString("json"));
                String exist = riskEntry.getString("exist");
                if (StringUtils.isEmpty((CharSequence)exist)) {
                    exist = "1";
                }
                DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_result_records");
                record.set("resultid", (Object)resultid);
                record.set("exist", riskEntry.get("exist"));
                record.set("title", (Object)riskEntry.getString("title"));
                record.set("text", (Object)riskEntry.getString("text"));
                record.set("json_tag", (Object)riskEntry.getString("json"));
                record.set("fieldid", (Object)riskEntry.getString("fieldid"));
                record.set("tableid", riskEntry.get("tableid"));
                DynamicObjectCollection sql = ElementSqlService.querySql(riskEntry.getString("json"), orgid, originalStartDate, startDate, endDate);
                if (EmptyCheckUtils.isNotEmpty((Object)sql)) {
                    DynamicObjectCollection recordEntryList = record.getDynamicObjectCollection("entryentity");
                    String fieldid = riskEntry.getString("fieldid");
                    QFilter filter = new QFilter("entryentity.id", "in", Arrays.stream(fieldid.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.orgstate,entryentity.datastate", (QFilter[])new QFilter[]{filter});
                    List<String> fieldname = this.getfieldname(collection);
                    DataEntityPropertyCollection properties = ((DynamicObject)sql.get(0)).getDataEntityType().getProperties();
                    for (DynamicObject object : sql) {
                        for (IDataEntityProperty property : properties) {
                            String propertyName = property.getName();
                            for (String filterFieldName : filterFieldNameList) {
                                if (!propertyName.equals(filterFieldName)) continue;
                                String filterFieldValue = object.getString(propertyName);
                                filterFieldValueList.add(filterFieldValue);
                            }
                            if ("id".equals(propertyName) || !fieldname.contains(propertyName)) continue;
                            DynamicObject resultObj = recordEntryList.addNew();
                            resultObj.set("index", object.get("id"));
                            resultObj.set("key", (Object)propertyName);
                            resultObj.set("value", object.get(propertyName));
                            recordValueList.add(String.valueOf(object.get(propertyName)));
                        }
                    }
                }
                boolean currentBiDuiFormulaResultBoolean = EmptyCheckUtils.isNotEmpty((Object)sql);
                boolean currentBiDuiWithExistOrNotExistBoolean = "0".equals(exist) ? !currentBiDuiFormulaResultBoolean : currentBiDuiFormulaResultBoolean;
                if (null == isRisk) {
                    isRisk = currentBiDuiWithExistOrNotExistBoolean;
                } else if (isRisk.booleanValue()) {
                    isRisk = currentBiDuiWithExistOrNotExistBoolean;
                }
                recordList.add(record);
            }
            if (null == isRisk) {
                isRisk = Boolean.FALSE;
            }
            for (DynamicObject record : recordList) {
                record.set("isrisk", (Object)isRisk);
            }
            map.put("result", String.valueOf(isRisk));
            map.put("recordValueList", recordValueList.stream().collect(Collectors.joining(",")));
            map.put("filterFieldValueList", filterFieldValueList.stream().collect(Collectors.joining(",")));
            map.put("recordList", String.valueOf(recordList));
            if (!isRisk.booleanValue()) {
                map.put("risklevel", "0");
                map.put("riskdesc", "");
            }
            SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[0]));
        } else {
            map.put("risklevel", "0");
            map.put("riskdesc", "");
        }
        return map;
    }

    private List<String> getfieldname(DynamicObjectCollection collection) {
        ArrayList<String> result = new ArrayList<String>();
        for (DynamicObject dynamicObject : collection) {
            boolean ischild = dynamicObject.getBoolean("ischild");
            String subname = dynamicObject.getString("subname");
            String fieldsubname = dynamicObject.getString("entryentity.fieldsubname");
            String name = dynamicObject.getString("entryentity.fieldname");
            if (ischild && fieldsubname.equals(subname)) {
                result.add(dynamicObject.getString("subname") + "." + name);
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public String calVariableInSuggestion(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String originalStartDate, String startDate, String endDate, DynamicObjectCollection riskEntryList, String suggestion, String calType) {
        String riskDesc = VariableService.replaceVariable(eleCode2InfoMap, orgid, suggestion, originalStartDate, startDate, endDate, calType);
        return riskDesc;
    }
}

