/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.entity.ContrastTypeEnum;
import kd.taxc.common.entity.Element;
import kd.taxc.common.entity.FilterElement;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.common.element.AbstractRiskOperate;
import kd.taxc.tctb.common.element.RecalculateRiskResult;
import kd.taxc.tctb.common.element.TimeDeviatedEnum;

public class VerifyRisk
extends AbstractRiskOperate {
    @Override
    public List<Long> queryRiskByElementCodes(List<String> eleCodes) {
        ArrayList<Long> riskIds = new ArrayList<Long>();
        QFilter qRiskType = new QFilter("risktype", "=", (Object)"3");
        DynamicObjectCollection riskDefs = QueryServiceHelper.query((String)"tctrc_element_verify", (String)"id,risklevel,variableids,suggestion,entryentity.exist as exist,entryentity.title as title,entryentity.text as text, entryentity.json_tag as json", (QFilter[])new QFilter[]{qRiskType});
        DynamicObjectCollection eleDefCollection = QueryServiceHelper.query((String)"tdm_element_group", (String)"id,number,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", null);
        HashMap<String, String> elementMap = new HashMap<String, String>();
        HashMap<String, String> idCodeMap = new HashMap<String, String>();
        for (DynamicObject element : eleDefCollection) {
            elementMap.put(element.getString("number"), element.getString("json") + "," + element.getString("bottom"));
            idCodeMap.put(element.getString("id"), element.getString("number"));
        }
        block1: for (DynamicObject riskDef : riskDefs) {
            HashSet<String> elementCodes = new HashSet<String>();
            String jsonStr = riskDef.getString("json");
            if (StringUtil.isEmpty((CharSequence)jsonStr)) continue;
            List list = SerializationUtils.fromJsonStringToList((String)jsonStr, FilterElement.class);
            if (list != null && list.size() > 0) {
                for (FilterElement filterElement : list) {
                    Element element = filterElement.getElement();
                    elementCodes.add((String)idCodeMap.get(element.getId()));
                    if (!filterElement.getContrasType().equals(ContrastTypeEnum.CONTRAST_TYPE_ENUM_ELEMENT.getKey())) continue;
                    Element compareElement = filterElement.getContrastValue().getElement();
                    elementCodes.add((String)idCodeMap.get(compareElement.getId()));
                }
            }
            HashMap<String, String> codesMap = new HashMap<String, String>();
            RecalculateRiskResult.splitElements(elementCodes, elementMap, codesMap);
            for (String code : eleCodes) {
                if (null == codesMap.get(code)) continue;
                riskIds.add(riskDef.getLong("id"));
                continue block1;
            }
        }
        return riskIds;
    }

    @Override
    public List<DynamicObject> queryRiskResult(List<DynamicObject> elementUpdateList, List<String> orgList, List<Long> riskIds) {
        ArrayList<DynamicObject> isUpdateResults = new ArrayList<DynamicObject>();
        QFilter qOrgs = new QFilter("runorg", "in", orgList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
        QFilter qRisks = new QFilter("risk", "in", riskIds);
        QFilter qRiskType = new QFilter("risk.risktype", "=", (Object)"3");
        DynamicObject[] riskResultArr = BusinessDataServiceHelper.load((String)"tctrc_risk_run_result", (String)"id,assignorg,plannumber,runorg,risk,runtime,risklevel,riskdesc,result,datestring,caltype,status,dealresult,startdate,enddate,transmit,runtime", (QFilter[])new QFilter[]{qOrgs, qRisks, qRiskType});
        DynamicObjectCollection eleDefCollection = QueryServiceHelper.query((String)"tdm_element_group", (String)"id,number,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", null);
        HashMap<String, String> elementMap = new HashMap<String, String>();
        HashMap<String, String> elementIdMap = new HashMap<String, String>();
        for (Object element : eleDefCollection) {
            String string = element.getString("timedeviationtype");
            String deviationDirection = element.getString("timedeviationdirection");
            int timeDeviationCount = EmptyCheckUtils.isEmpty((Object)element.getString("timedeviationcount")) ? 0 : Integer.parseInt(element.getString("timedeviationcount").trim());
            int diffMonth = TimeDeviatedEnum.getDeviatedMonth(deviationDirection, timeDeviationCount, string);
            String bottom = element.getString("bottom");
            elementMap.put(element.getString("number"), element.getString("json") + "," + diffMonth + "," + bottom);
            elementIdMap.put(element.getString("id"), element.getString("number"));
        }
        HashMap<String, String> updateElementMap = new HashMap<String, String>(elementUpdateList.size());
        for (DynamicObject dynamicObject : elementUpdateList) {
            String number = dynamicObject.getString("element");
            String start = DateUtils.format((Date)dynamicObject.getDate("startdata"));
            String end = DateUtils.format((Date)dynamicObject.getDate("enddata"));
            updateElementMap.put(number + "," + start + "," + end, number);
        }
        ArrayList<Long> resultRiskIds = new ArrayList<Long>(riskResultArr.length);
        for (DynamicObject result : riskResultArr) {
            resultRiskIds.add(result.getDynamicObject("risk").getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", resultRiskIds);
        HashMap riskIdAndJsonMap = new HashMap();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctrc_element_verify", (String)"id,entryentity.json_tag as json", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            long pkId = dynamicObject.getLong("id");
            Set<String> set = new HashSet<String>();
            if (null != riskIdAndJsonMap.get(pkId)) {
                set = (Set)riskIdAndJsonMap.get(pkId);
            }
            set.add(dynamicObject.getString("json"));
            riskIdAndJsonMap.put(pkId, set);
        }
        block4: for (DynamicObject result : riskResultArr) {
            HashMap<String, String> codePeriodMap = new HashMap<String, String>();
            String start = DateUtils.format((Date)result.getDate("startdate"));
            String end = DateUtils.format((Date)result.getDate("enddate"));
            Set josnSet = (Set)riskIdAndJsonMap.get(result.getLong("risk.id"));
            boolean isUpdate = false;
            for (String jsonStr : josnSet) {
                List list = SerializationUtils.fromJsonStringToList((String)jsonStr, FilterElement.class);
                if (list != null && list.size() > 0) {
                    for (FilterElement filterElement : list) {
                        Element element = filterElement.getElement();
                        String json = (String)elementIdMap.get(element.getId());
                        this.resolveExpressionByPeriod(json, elementMap, codePeriodMap, 0, start, end);
                        isUpdate = this.containsElement(updateElementMap, codePeriodMap);
                        if (isUpdate) break;
                        if (!filterElement.getContrasType().equals(ContrastTypeEnum.CONTRAST_TYPE_ENUM_ELEMENT.getKey())) continue;
                        Element compareElement = filterElement.getContrastValue().getElement();
                        json = (String)elementIdMap.get(compareElement.getId());
                        this.resolveExpressionByPeriod(json, elementMap, codePeriodMap, 0, start, end);
                        isUpdate = this.containsElement(updateElementMap, codePeriodMap);
                        if (!isUpdate) continue;
                        break;
                    }
                }
                if (!isUpdate) continue;
                isUpdateResults.add(result);
                continue block4;
            }
        }
        return isUpdateResults;
    }

    private boolean containsElement(Map<String, String> updateElementMap, Map<String, String> codePeriodMap) {
        for (Map.Entry<String, String> entry : codePeriodMap.entrySet()) {
            String key = entry.getKey();
            if (null == updateElementMap.get(key)) continue;
            return true;
        }
        return false;
    }
}

