/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.FunctionMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.org.OrgCheckUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.OrgUtils;

public class TctrcRiskSharingReCalUtil {
    private static Log logger = LogFactory.getLog(TctrcRiskSharingReCalUtil.class);

    private static List<Long> getSubOrgIds(Long orgid) {
        List<Long> orgList = Collections.singletonList(orgid);
        List subOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), orgList, (boolean)true);
        if (EmptyCheckUtils.isNotEmpty((Object)subOrgList)) {
            ArrayList<Long> subOrgResList = new ArrayList<Long>(10);
            for (Long needCheckOrgid : subOrgList) {
                TreeNode treeNode = new TreeNode();
                treeNode.setId(String.valueOf(needCheckOrgid));
                if (!OrgCheckUtil.licenseCheckByAppid((TreeNode)treeNode, (String)"tctrc") || !OrgCheckUtil.isTaxPayer((Long)needCheckOrgid)) continue;
                subOrgResList.add(needCheckOrgid);
            }
            return subOrgResList;
        }
        return subOrgList;
    }

    private static List<Long> getOrgsByOrgAttrAndParentOrg(List<Long> attrids, List<Long> subOrgIds) {
        QFilter qFilter = new QFilter("orgattr.fbasedataid", "in", attrids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.id", (QFilter[])new QFilter[]{qFilter});
        List<Long> previeworgs = new ArrayList<Long>(10);
        if (!EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
            return previeworgs;
        }
        previeworgs = dynamicObjects.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(subOrgIds)) {
            return new ArrayList<Long>();
        }
        return previeworgs.stream().filter(v -> subOrgIds.contains(v)).collect(Collectors.toList());
    }

    public static final void riskSharingReCal(DynamicObject riskSharingDy) {
        Long riskSharingPkid = riskSharingDy.getLong("id");
        Long riskSharingCreateOrgId = riskSharingDy.getDynamicObject("org").getLong("id");
        QFilter filter = new QFilter("sharingid", "=", (Object)riskSharingPkid);
        DynamicObject[] riskrunlist = BusinessDataServiceHelper.load((String)"tctrc_risk_run_list", (String)"id,risk,runorg,planid,plannumber,month,day,runtime", (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> originalMap = new HashMap<String, DynamicObject>(riskrunlist.length);
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : riskrunlist) {
            String risk = dynamicObject.getString("risk.id");
            String runorg = dynamicObject.getString("runorg.id");
            String string = dynamicObject.getString("planid");
            originalMap.put((String)risk + "-" + runorg + "-" + string, dynamicObject);
        }
        DynamicObjectCollection planentity = riskSharingDy.getDynamicObjectCollection("planentity");
        HashSet<String> currents = new HashSet<String>();
        ArrayList<DynamicObject> riskRunList = new ArrayList<DynamicObject>();
        List<Long> subOrgs = TctrcRiskSharingReCalUtil.getSubOrgIds(riskSharingCreateOrgId);
        for (Object plan : planentity) {
            DynamicObjectCollection dynamicObjectCollection = plan.getDynamicObjectCollection("subentryentity");
            if (EmptyCheckUtils.isEmpty((Object)dynamicObjectCollection)) continue;
            DynamicObjectCollection orgentity = ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObjectCollection("mulsharingorg");
            DynamicObjectCollection orgAttrentity = ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObjectCollection("mulsharingorgattr");
            List<Long> attrids = orgAttrentity.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            List orgentityids = orgentity.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            List orgentityexculeunsonids = orgentityids.stream().filter(v -> subOrgs.contains(v)).collect(Collectors.toList());
            List<Long> attrOrgIds = TctrcRiskSharingReCalUtil.getOrgsByOrgAttrAndParentOrg(attrids, subOrgs);
            List orgids = Stream.concat(attrOrgIds.stream(), orgentityexculeunsonids.stream()).distinct().collect(Collectors.toList());
            DynamicObjectCollection riskentity = plan.getDynamicObjectCollection("riskentity");
            for (Long orgid : orgids) {
                for (DynamicObject risk : riskentity) {
                    String day;
                    String month;
                    DynamicObject riskRun = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_risk_run_list");
                    DynamicObject riskDynamicObject = risk.getDynamicObject("riskid");
                    String riskid = riskDynamicObject.getString("id");
                    String planid = plan.getString("id");
                    String key = riskid + "-" + orgid + "-" + planid;
                    currents.add(key);
                    QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(riskid));
                    DynamicObject riskDefinition = QueryServiceHelper.queryOne((String)"tctrc_risk_definition", (String)"id,risktype,month,day", (QFilter[])new QFilter[]{qFilter});
                    DynamicObject update = (DynamicObject)originalMap.get(key);
                    if (null != update) {
                        update.set("plannumber", (Object)plan.getString("name"));
                        if (riskDefinition != null) {
                            month = riskDefinition.getString("month");
                            update.set("month", (Object)month);
                            day = riskDefinition.getString("day");
                            update.set("day", (Object)day);
                            update.set("runtime", (Object)(month + "," + day));
                        }
                        updates.add(update);
                        continue;
                    }
                    riskRun.set("risk", (Object)riskid);
                    riskRun.set("assignorg", (Object)riskSharingCreateOrgId);
                    riskRun.set("runorg", (Object)orgid);
                    riskRun.set("planid", (Object)planid);
                    riskRun.set("plannumber", (Object)plan.getString("name"));
                    riskRun.set("sharingid", (Object)riskSharingPkid);
                    if (riskDefinition != null) {
                        month = riskDefinition.getString("month");
                        riskRun.set("month", (Object)month);
                        day = riskDefinition.getString("day");
                        riskRun.set("day", (Object)day);
                        riskRun.set("runtime", (Object)(month + "," + day));
                    }
                    riskRunList.add(riskRun);
                }
            }
        }
        ArrayList<Long> needDeleteIds = new ArrayList<Long>();
        for (Map.Entry entry : originalMap.entrySet()) {
            String key = (String)entry.getKey();
            if (currents.contains(key)) continue;
            needDeleteIds.add(((DynamicObject)entry.getValue()).getLong("id"));
        }
        QFilter idsFilter = new QFilter("id", "in", needDeleteIds);
        DeleteServiceHelper.delete((String)"tctrc_risk_run_list", (QFilter[])new QFilter[]{idsFilter});
        SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        if (EmptyCheckUtils.isNotEmpty(riskRunList)) {
            for (DynamicObject dynamicObject : riskRunList) {
                String risk = dynamicObject.getString("risk");
                String runorg = dynamicObject.getString("runorg");
                String planid = dynamicObject.getString("planid");
                String assignorg = dynamicObject.getString("assignorg");
                try {
                    FunctionMutex funMutex = FunctionMutex.create();
                    Throwable throwable = null;
                    try {
                        DynamicObject[] doAgainQueryResList;
                        boolean success = funMutex.require(Long.parseLong(risk), "createRiskRunList" + runorg + planid + assignorg);
                        logger.info("createRiskRunList Lock " + String.format("%s-%s-%s-%s", risk, runorg, planid, assignorg));
                        if (!success || !EmptyCheckUtils.isEmpty((Object)(doAgainQueryResList = TctrcRiskSharingReCalUtil.queryRiskRunList(risk, runorg, planid, assignorg)))) continue;
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (funMutex == null) continue;
                        if (throwable != null) {
                            try {
                                funMutex.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        funMutex.close();
                    }
                }
                catch (Exception e) {
                    logger.error("\u4e92\u65a5\u9501\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    private static DynamicObject[] queryRiskRunList(String risk, String runorg, String planid, String assignorg) {
        QFilter filter = new QFilter("risk", "=", (Object)Long.parseLong(risk));
        QFilter filter2 = new QFilter("runorg", "=", (Object)Long.parseLong(runorg));
        QFilter filter3 = new QFilter("planid", "=", (Object)Long.parseLong(planid));
        QFilter filter4 = new QFilter("assignorg", "=", (Object)Long.parseLong(assignorg));
        return BusinessDataServiceHelper.load((String)"tctrc_risk_run_list", (String)"id,risk,runorg,planid,plannumber,month,day,runtime", (QFilter[])new QFilter[]{filter, filter2, filter3, filter4});
    }
}

