/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.element.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.element.ElementSqlService;
import kd.taxc.tctb.common.element.bean.EleTreeInfo;
import kd.taxc.tctb.common.element.util.ElementUtil;

public class EleTreeUtil {
    private static Log logger = LogFactory.getLog(EleTreeUtil.class);

    public static final List<String> findAllTopEleCodes(List<EleTreeInfo> treeInfoList) {
        return treeInfoList.stream().map(EleTreeInfo::getEleCode).collect(Collectors.toList());
    }

    public static final List<String> findTopEleCodesByBottoms(List<EleTreeInfo> treeInfoList, List<String> codes) {
        List ukcodes = codes.stream().distinct().collect(Collectors.toList());
        return treeInfoList.stream().filter(top -> (long)(top.getBottomEleCodes().size() + ukcodes.size()) - Stream.concat(top.getBottomEleCodes().stream(), ukcodes.stream()).distinct().count() != 0L).map(EleTreeInfo::getEleCode).collect(Collectors.toList());
    }

    public static final List<String> findNestTopEleCodesByBottoms(List<EleTreeInfo> treeInfoList, List<String> bottoms) {
        HashSet<String> reCalTopEleCodes = new HashSet<String>(20);
        EleTreeUtil.doFindNestTopEleCodesByBottoms(treeInfoList, bottoms, reCalTopEleCodes);
        return new ArrayList<String>(reCalTopEleCodes);
    }

    public static final void doFindNestTopEleCodesByBottoms(List<EleTreeInfo> treeInfoList, List<String> codes, Set<String> reCalEleCodes) {
        for (String code : codes) {
            Boolean isUsed = Boolean.FALSE;
            for (EleTreeInfo rootTree : treeInfoList) {
                if (!rootTree.getBottomEleCodes().contains(code)) continue;
                isUsed = Boolean.TRUE;
                if (reCalEleCodes.contains(rootTree.getEleCode())) continue;
                reCalEleCodes.add(rootTree.getEleCode());
                EleTreeUtil.doFindNestTopEleCodesByBottoms(treeInfoList, rootTree.getBottomEleCodes(), reCalEleCodes);
            }
            if (isUsed.booleanValue()) continue;
            reCalEleCodes.add(code);
        }
    }

    public static final List<EleTreeInfo> createEleTree() {
        Map<String, DynamicObject> code2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        Long time = System.currentTimeMillis();
        List<EleTreeInfo> treeList = EleTreeUtil.createEleTree(code2InfoMap);
        logger.info(String.format("\u5143\u7d20\u6784\u9020\u6210\u6811\u8017\u65f6 %s ", System.currentTimeMillis() - time));
        return treeList;
    }

    public static List<EleTreeInfo> createEleTree(Map<String, DynamicObject> code2InfoMap) {
        ArrayList<EleTreeInfo> treeList = new ArrayList<EleTreeInfo>(10);
        List<DynamicObject> dynamicObjects = EleTreeUtil.findRootUnBottomEles(code2InfoMap);
        for (DynamicObject topLevelEle : dynamicObjects) {
            EleTreeInfo topLevelEleTree = EleTreeUtil.initTreeBean(topLevelEle);
            HashSet<String> bottomEleCodes = new HashSet<String>(30);
            EleTreeUtil.findChildren(topLevelEleTree, code2InfoMap, bottomEleCodes);
            bottomEleCodes.add(topLevelEle.getString("number"));
            topLevelEleTree.setBottomEleCodes(new ArrayList<String>(bottomEleCodes));
            treeList.add(topLevelEleTree);
        }
        return treeList;
    }

    private static void findChildren(EleTreeInfo parent, Map<String, DynamicObject> code2InfoMap, Set<String> bottomEleCodes) {
        List<String> eleCodes = ElementUtil.getUnBottomNextLevelEles(parent.getEle(), code2InfoMap);
        if (EmptyCheckUtils.isNotEmpty(eleCodes)) {
            bottomEleCodes.addAll(eleCodes);
        }
        parent.setChildrenList(EleTreeUtil.createChildren(code2InfoMap, eleCodes, bottomEleCodes));
    }

    private static List<EleTreeInfo> createChildren(Map<String, DynamicObject> code2InfoMap, List<String> eleCodes, Set<String> bottomEleCodes) {
        ArrayList<EleTreeInfo> childrens = new ArrayList<EleTreeInfo>(10);
        for (String eleCode : eleCodes) {
            if (!EmptyCheckUtils.isNotEmpty((Object)code2InfoMap.get(eleCode))) continue;
            EleTreeInfo children = EleTreeUtil.initTreeBean(code2InfoMap.get(eleCode));
            childrens.add(children);
            if (children.getEle().getBoolean("bottom")) continue;
            EleTreeUtil.findChildren(children, code2InfoMap, bottomEleCodes);
        }
        return childrens;
    }

    private static EleTreeInfo initTreeBean(DynamicObject dynamicObject) {
        EleTreeInfo treeInfo = new EleTreeInfo();
        treeInfo.setEle(dynamicObject);
        treeInfo.setEleCode(dynamicObject.getString("number"));
        return treeInfo;
    }

    public static boolean isNotTop(DynamicObject compareBean, DynamicObject tempBean, Map<String, DynamicObject> code2InfoMap) {
        List<String> eleCodes = ElementUtil.getUnBottomNextLevelEles(tempBean, code2InfoMap);
        if (EmptyCheckUtils.isEmpty(eleCodes)) {
            return false;
        }
        return eleCodes.contains(compareBean.getString("number"));
    }

    private static List<DynamicObject> findRootUnBottomEles(Map<String, DynamicObject> code2InfoMap) {
        List allInfos = code2InfoMap.values().stream().collect(Collectors.toList());
        List allUnBottomInfos = allInfos.stream().filter(v -> !v.getBoolean("bottom")).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(allUnBottomInfos)) {
            return new ArrayList<DynamicObject>(10);
        }
        Predicate<DynamicObject> isMidLeaf = v -> {
            for (DynamicObject unBottom : allUnBottomInfos) {
                if (!EleTreeUtil.isNotTop(v, unBottom, code2InfoMap)) continue;
                return true;
            }
            return false;
        };
        return allUnBottomInfos.stream().filter(v -> !isMidLeaf.test((DynamicObject)v)).collect(Collectors.toList());
    }
}

