/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.task;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.threadpools.Task;
import kd.taxc.common.threadpools.ThreadPoolsService;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.BooleanEnum;
import kd.taxc.tctb.common.element.ElementSqlService;
import kd.taxc.tctb.common.element.bean.EleTreeInfo;
import kd.taxc.tctb.common.element.util.EleTreeUtil;
import kd.taxc.tctb.common.task.EleDoCheckPlanExe;
import kd.taxc.tctb.common.task.helper.EleCheckPlanHelper;

public class EleCheckPlanExeTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        EleCheckPlanExeTask.executeCheck();
    }

    public static void executeCheck() {
        QFilter qFilter = new QFilter("enable", "=", (Object)BooleanEnum.YES.getCode());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdm_ele_check_plan", (String)"planno,planname,checkrange,plandatestart,plandateend,checkeles,checkorgs,runtime", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return;
        }
        Long today = DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.stringToDate((String)DateUtils.format((Date)new Date())))).getTime();
        List needExeCheckPlans = Arrays.stream(dynamicObjects).filter(v -> EmptyCheckUtils.isEmpty((Object)v.get("runtime")) || today >= DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.addDay((Date)DateUtils.stringToDate((String)DateUtils.format((Date)v.getDate("runtime"))), (int)v.getInt("checkrange")))).getTime()).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(needExeCheckPlans)) {
            return;
        }
        Map<String, DynamicObject> code2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        List<EleTreeInfo> eleTreeInfos = EleTreeUtil.createEleTree();
        EleCheckPlanHelper.distant();
        for (DynamicObject checkPlan : needExeCheckPlans) {
            ThreadPoolsService.getInstance().submit((Task)new EleDoCheckPlanExe(checkPlan, eleTreeInfos, code2InfoMap));
        }
    }
}

