/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.common.element.TimeDeviatedEnum;

public class CalUtils {
    public static final String FIELD_STARTDATE = "startdate";
    public static final String FIELD_ENDDATE = "enddate";

    public static List<Map<String, Date>> getCalDate(String calType, Date startDate, Date endDate) {
        ArrayList<Map<String, Date>> list = new ArrayList<Map<String, Date>>();
        Date startdate = DateUtils.trunc((Date)startDate);
        Date enddate = endDate;
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType)) {
            CalUtils.getMonthTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType)) {
            CalUtils.getSeasonTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(calType)) {
            CalUtils.getYearTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(calType)) {
            CalUtils.getHalfYearTypeList(list, startdate, enddate);
        }
        return list;
    }

    private static void getMonthTypeList(List<Map<String, Date>> list, Date startDate, Date endDate) {
        startDate = DateUtils.getFirstDateOfMonth((Date)startDate);
        endDate = DateUtils.getLastDateOfMonth((Date)endDate);
        while (startDate.compareTo(endDate) < 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            Date lastDateOfMonth = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)startDate));
            if (lastDateOfMonth.compareTo(endDate) > 0) break;
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put(FIELD_STARTDATE, startDate);
            map.put(FIELD_ENDDATE, lastDateOfMonth);
            startDate = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)startDate), (int)1);
            list.add(map);
        }
    }

    private static void getSeasonTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfSeason((Date)startdate);
        enddate = DateUtils.getLastDateOfSeason((Date)enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)startdate, (int)2));
            if (DateUtils.trunc((Date)end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc((Date)end));
            list.add(map);
            startdate = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)startdate), (int)3);
        }
    }

    private static void getYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfYear((Date)startdate);
        enddate = DateUtils.getLastDateOfYear((Date)enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            String end = DateUtils.getYearOfDate((Date)startdate) + "-12-31";
            Date endData = DateUtils.stringToDate((String)end);
            if (DateUtils.trunc((Date)endData).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc((Date)endData));
            list.add(map);
            startdate = DateUtils.addYear((Date)DateUtils.getFirstDateOfMonth((Date)startdate), (int)1);
        }
    }

    private static void getHalfYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfHalfYear((Date)startdate);
        enddate = DateUtils.getLastDateOfHalfYear((Date)enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)startdate, (int)5));
            if (DateUtils.trunc((Date)end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc((Date)end));
            list.add(map);
            startdate = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)startdate), (int)6);
        }
    }

    private static int getStartQMonth(int month) {
        if (month < 3) {
            return 0;
        }
        if (month < 6) {
            return 3;
        }
        if (month < 9) {
            return 6;
        }
        return 9;
    }

    private static int getEndQMonth(int month) {
        if (month < 3) {
            return 2;
        }
        if (month < 6) {
            return 5;
        }
        if (month < 9) {
            return 8;
        }
        return 11;
    }
}

